
import Layout from '@/views/layout/Layout'


const PushRouter = {
  path: '/push',
  component: Layout,
  redirect: '/push/list',
  name: 'Push',
  meta: {
    title: 'Push管理',
    icon: 'example'
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/push/list'),
      name: 'PushList',
      meta: {title: 'Push列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/push/create'),
      name: 'CreatePush',
      meta: {title: '创建Push', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/push/edit'),
      name: 'EditPush',
      meta: {title: '编辑Push', noCache: true},
      hidden: true
    }
  ]
}

export default PushRouter
