
import Layout from '@/views/layout/Layout'


const StarRouter = {
  path: '/star',
  component: Layout,
  redirect: '/star/list',
  name: 'Star',
  meta: {
    title: '明星管理',
    icon: 'example'
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/star/list'),
      name: 'StarList',
      meta: {title: '明星列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/star/create'),
      name: 'CreateStar',
      meta: {title: '创建明星', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/star/edit'),
      name: 'EditStar',
      meta: {title: '编辑明星', noCache: true},
      hidden: true
    }
  ]
}

export default StarRouter
