#!/usr/bin/env python
# coding=utf-8
import re
import datetime
import json

from django.conf import settings
from django.http import JsonResponse
from django.contrib.auth.hashers import make_password
from django.http.response import HttpResponseBadRequest

from utils.logger import auth_logger


def require_login(request, origin=''):
    """
    医生后台和app的返回需要登陆的方式不一样

    @param: origin 需要登录发生的位置来源

    !!!!!   这个方法只能结合 return 一起使用
    """
    if 'api/client' in request.path_info:
        # TODO Skyler 这个暂时这么处理，之后需要换种方式处理
        login_require = HttpResponseBadRequest(status=403)
    else:
        login_require = JsonResponse({
            'error': 401,
            'message': '需要登录',
            'data': None,
        })
    # 打印日志
    info_msg = '!ascle {origin} {path} {session} {doctor_id} _dd:{target_uid}'
    auth_logger.info(info_msg.format(
        origin=origin,
        path=request.path,
        session=request.COOKIES.get(settings.USER_COOKIE_NAME, '-'),
        doctor_id=getattr(request, 'doctor_user', {}).get('doctor', {}).get('id', '-'),
        target_uid=request.GET.get('_dd', '-'),
    ))
    return login_require


def py(password):
    """生成密码hash
    """
    return make_password(password, None, 'pbkdf2_sha256')
