#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/19
import time
from utils.base import APIView
from gm_upload import upload, upload_file

FACE_IMAGE_TYPE = '-99'


class FileUpload(APIView):

    args_POST = {
        'img_type': {
            'access': int,
        },
    }

    def post(self, request):
        image_type = self.args_post.get('uploadType')
        image = request.FILES.get('file')
        data = image.read()

        if image_type == FACE_IMAGE_TYPE:
            types = str(image).split('.')[-1]
            full_image_url, _ = upload_file(data, 'face/' + str(int(time.time())) + '.' + types)
        else:
            full_image_url = upload(data, img_type=int(image_type)) + '-w'
        return {
            'file_url': full_image_url
        }
