import request from '@/utils/request'

export function fetchList(query) {
  return request({
    url: '/api/celebrity/list',
    method: 'get',
    params: query
  })
}

export function starCreate(data) {
  return request({
    url: '/api/celebrity/create',
    method: 'post',
    data
  })
}

export function starDetail(id) {
  return request({
    url: '/api/celebrity/detail',
    method: 'get',
    params: { id }
  })
}

export function OffLineOrOnLine(data) {
  return request({
    url: '/api/celebrity//list/update',
    method: 'post',
    data
  })
}

export function fetchStarRelatedGroup(query) {
  return request({
    url: '/api/celebrity/celebrity_related_group_info',
    method: 'get',
    params: query
  })
}
