#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

import json
from utils.base import APIView
from utils.time_utils import analysis_time


class TopicListView(APIView):
    def get(self, request):
        user_id = request.GET.get('user_id', '')
        group_id = request.GET.get('group_id', '')
        offset = int(request.GET.get('page', 0))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        if user_id:
            filter.update({'user_id': user_id})
        if group_id:
            filter.update({'group_id': group_id})
        try:
            data = self.rpc['venus/sun/topic/list'](offset=(offset - 1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            raise e
        return data


class TopicUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')

        try:
            data = self.rpc['venus/sun/topic/get'](id=id).unwrap()
        except Exception as e:
            raise e
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id', '')

        posting_time = analysis_time(request.POST.get('posting_time', 0))
        topic_images = list(map(lambda x: x[:-2], json.loads(request.POST.get('topic_images', []))))

        data = {
            'topic_images': topic_images,
            # 'reply_ids': json.loads(request.POST.get('topic_ids', '')),
            'video_url': request.POST.get('video_url', ''),
            'posting_time': posting_time,
            'content': request.POST.get('content', ''),
            'content_level': request.POST.get('content_level', ''),
            'group_id': request.POST.get('group_name', ''),
            'user_id': request.POST.get('user_name', ''),
            'star_id': request.POST.get('star_name', ''),
            'tag_ids': json.loads(request.POST.get('tag_ids', [])),
        }
        try:
            self.rpc['venus/sun/topic/edit'](id=id, data=data).unwrap()
        except Exception as e:
            raise e
        return {
            'message': '更新成功'
        }


class ReplyUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')
        offset = int(request.GET.get('page', 0))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        filter.update({'topic_id': id})
        try:
            data = self.rpc['venus/sun/topic/reply/list'](offset=(offset-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            raise e
        return data

    def post(self, request):
        reply_ids = json.loads(request.POST.get('reply_ids', []))
        try:
            self.rpc['venus/sun/topic/reply/batch_delete'](data=reply_ids).unwrap()
        except Exception as e:
            raise e
        return {
            'message': '操作成功'
        }


class ReplyCreate(APIView):
    def post(self, request):
        data = {
            'user_id': request.POST.get('user_id'),
            'replied_id': request.POST.get("replied_id", None),
            'topic_id': request.POST.get("topic_id", None),
            'content': request.POST.get('content'),
        }
        try:
            data = self.rpc['venus/sun/topic/reply/edit'](id=None, data=data).unwrap()
        except Exception as e:
            raise e
        return {'data': data}

