#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

import json
from utils.base import APIView


class GroupListView(APIView):
    def get(self, request):
        star_id = request.GET.get('star_id')
        user_id = request.GET.get('user_id')
        offset = int(request.GET.get('page', 0))
        limit = int(request.GET.get('limit', 10))
        filters = self.handle_filter(request.GET.get('filter', ""))
        if star_id:
            filters.update({'star_id': star_id})
        if user_id:
            filters.update({'user_id': user_id})
        try:
            data = self.rpc['venus/sun/group/list'](filters=filters, offset=(offset-1)*limit, limit=limit).unwrap()
        except Exception as e:
            raise e
        return data

    def post(self, request):
        ids = request.POST.get('ids', '').split()
        type = request.POST.get('type')
        updates = {}
        if type == 'offline':
            updates['is_online'] = False
        elif type == 'is_recommend':
            updates['is_recommend'] = True
        else:
            updates['is_online'] = True
        try:
            self.rpc['venus/sun/group/batch/update'](updates=updates, ids=ids).unwrap()
        except Exception as e:
            raise e
        return {
            "message": "更新成功"
        }


class GroupUpdateOrCreate(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/group/get'](id=id).unwrap()
        except Exception as e:
            raise e
        return data

    def post(self, request):
        id = request.POST.get('id')
        data = {
            'name': request.POST.get('name', ''),
            'description': request.POST.get('description', ''),
            'creator_id': request.POST.get('user_id', ''),
            'star_ids': json.loads(request.POST.get('star', '')),
            'is_online': request.POST.get('is_online', ''),
            'is_recommend': request.POST.get('is_recommend', ''),
            'user_ids': json.loads(request.POST.get('user_ids', ''))
        }
        try:
            self.rpc['venus/sun/group/edit'](id=id, data=data).unwrap()
        except Exception as e:
            raise e
        return {
            'message': '更新成功'
        }


class GroupRelatedUser(APIView):
    def get(self, request):
        print(request.GET)
        id = request.GET.get('id')
        offset = int(request.GET.get('page', 0))
        count = int(request.GET.get('limit', 10))
        filters = {'group_id': id}
        try:
            data = self.rpc['venus/sun/group/user/list'](filters=filters, offset=offset, limit=count).unwrap()
        except Exception as e:
            raise e
        return data


class GroupRelatedUserGET(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/group/user/get'](id=id).unwrap()
        except Exception as e:
            raise e
        return [data, ]
