#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/17

from utils.base import APIView


class GroupSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/group/search'](name=name).unwrap()
        except Exception as e:
            raise e

        return {'data': data}


class RegionSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/country/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {'data': data}


class UserSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/user/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {'data': data}


class TagSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/tag/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {'data': data}


class StarSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/star/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {'data': data}


class CitySearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/city/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {'data': data}
