import request from '@/utils/request'

export function fetchList(query) {
  return request({
    url: '/api/star/list',
    method: 'get',
    params: query
  })
}

export function starCreate(data) {
  return request({
    url: '/api/star/create',
    method: 'post',
    data
  })
}

export function starDetail(id) {
  return request({
    url: '/api/star/detail',
    method: 'get',
    params: { id }
  })
}

export function OffLineOrOnLine(data) {
  return request({
    url: '/api/star/update_or_create',
    method: 'post',
    data
  })
}

export function fetchStarRelatedGroup(id) {
  return request({
    url: '/api/star/star_related_group_info',
    method: 'get',
    params: { id }
  })
}
