#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/17

from utils.base import APIView


class GroupSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/group/search'](name=name).unwrap()
        except Exception as e:
            raise e

        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }


class CountrySearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/country/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }


class UserSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/user/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }


class TagSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        platform = request.GET.get('platform')
        try:
            data = self.rpc['venus/sun/tag/search'](name=name, platform=platform).unwrap()
        except Exception as e:
            raise e
        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }


class CelebritySearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/celebrity/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }


class CitySearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/city/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }


class TopicSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/topic/search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }


class TagTypeSearchView(APIView):
    def get(self, request):
        name = request.GET.get('name')
        try:
            data = self.rpc['venus/sun/tag/tagtype_search'](name=name).unwrap()
        except Exception as e:
            raise e
        return {
            'data': ['{id}:{name}'.format(id=search_data['id'], name=search_data['name']) for search_data in data]
        }