#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView
from utils.logger import error_logger


class PushListView(APIView):
    def get(self, request):
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/sun/push/list'](offset=(page-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取push列表失败%s', e)
            raise
        return data


class PushUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/push/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取%s-push信息失败%s' %(id, e))
            raise
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id', '')
        creator_id = request.POST.get('creator_id')
        pictorial_topic_id = request.POST.get('pictorial_topic_id', '')
        icon = request.POST.get('icon', '')
        if icon.endswith('-w'):
            icon = request.POST.get('icon', '')[:-2]

        url = request.POST.get('url', '')
        if url == '推送帖子':
            url = 'alpha://topic_detail?topic_id='
        elif url == '推送画报':
            url = 'alpha://pictorial_detail?pictorial_id='
        full_url = url + pictorial_topic_id

        data = {
            'url': full_url,
            'push_time': request.POST.get('push_time'),
            'icon': icon,
            'content': request.POST.get('content', ''),
            'title': request.POST.get('title', ''),
            'creator_id': creator_id
        }
        try:
            rep = self.rpc['venus/sun/push/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑%s-push信息失败%s' % (id, e))
            raise
        return {
            "message": '更新成功',
            "id": rep['id']
        }


class EffectPushTaskView(APIView):
    def get(self, request):
        push_task_id = request.GET.get('id')
        try:
            self.rpc['venus/sun/push/effect_push_task'](id=push_task_id).unwrap()
        except Exception as e:
            error_logger.error(u'%s-push生效失败%s' % (push_task_id, e))
            raise
        return {
            'message': '操作成功'
        }


class PushBlackListView(APIView):
    def get(self, request):

        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))

        try:
            data = self.rpc['venus/sun/push/black_list'](offset=(page-1) * limit, limit=limit).unwrap()
        except Exception as e:
            error_logger.error(u'获取push黑名单列表失败%s', e)
            raise

        return data


class AddBlackListView(APIView):
    def post(self, request):

        user_id = request.POST.get('user_id').split(':')[0]

        try:
            self.rpc['venus/sun/push/add_black_list'](user_id=user_id).unwrap()
        except Exception as e:
            error_logger.error(u'添加失败%s', e)
            raise

        return {
            "message": '添加成功'
        }


class RmBlackListView(APIView):
    def post(self, request):

        user_id = request.POST.get('user_id').split(':')[0]

        try:
            self.rpc['venus/sun/push/rm_black_list'](user_id=user_id).unwrap()
        except Exception as e:
            error_logger.error(u'删除失败%s', e)
            raise

        return {
            "message": '添加成功'
        }
