from utils.base import APIView
from utils.base import APIView, get_offset_count


class SurveyListView(APIView):

    def get(self, request):

        offset, count = get_offset_count(request)

        data = self.rpc['venus/sun/survey/list'](offset=offset, count=count).unwrap()

        return data


class SurveyView(APIView):

    def get(self, request):
        id_ = int(request.GET.get('template_id'))

        data = self.rpc['venus/sun/survey/get'](id_=id_).unwrap()
        return data

    def post(self, request):

        questions = request.POST.get('questions')

        data = {
            "name": request.POST.get('name', ""),
            "questions": questions,
            "template_id": int(request.POST.get('template_id', 0)),
        }

        self.rpc['venus/sun/survey/add'](data=data).unwrap()

        return {
            "status": 1
        }


