import Layout from '@/views/layout/Layout'

const TagRouter = {
  path: '/tag',
  component: Layout,
  redirect: '/tag/list',
  name: 'Tag',
  meta: {
    title: '标签管理',
    icon: 'component',
    roles: ['staff', 'anonymous']
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/tag/list'),
      name: 'TagList',
      meta: {title: '标签列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/tag/create'),
      name: 'CreateTag',
      meta: {title: '创建标签', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/tag/edit'),
      name: 'EditTag',
      meta: {title: '编辑标签', noCache: true},
      hidden: true
    },
    {
      path: 'tagtype/list',
      component: () => import('@/views/tag_type/list'),
      name: 'TagTypeList',
      meta: {title: '标签类型列表', icon: 'list'}
    },
    {
      path: 'tagtype/create',
      component: () => import('@/views/tag_type/create'),
      name: 'CreateTagType',
      meta: {title: '创建标签类型', icon: 'edit'},
      hidden: true
    },
    {
      path: 'tagtype/edit/:id(\\d+)',
      component: () => import('@/views/tag_type/edit'),
      name: 'EditTagType',
      meta: {title: '编辑标签类型', noCache: true},
      hidden: true
    },
  ]
}

export default TagRouter
