#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

import json
from django.conf import settings
from utils.base import APIView
from utils.time_utils import generate_id
from django.contrib.auth.hashers import make_password


class UserListView(APIView):
    def get(self, request):
        group_id = request.GET.get('group_id', '')
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        if group_id:
            filter.update({'group_id': group_id})
        try:
            data = self.rpc['venus/sun/user/list'](offset=(page-1)*limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            raise e
        return data


class UserUpdateOrCreate(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/user/get'](id=id).unwrap()
        except Exception as e:
            raise e
        return data

    def post(self, request):
        id = request.POST.get('id', '')
        user_id = request.POST.get('user_id', '')
        tag_ids = list(map(lambda x: x.split(":")[0], json.loads(request.POST.get('tags', '[]'))))
        password = make_password(settings.PUPPET_PASSWORD, None, 'pbkdf2_sha256')
        if not user_id:
            user_id = generate_id()
        data = {
            'user_id': user_id,
            'password': password,
            'is_recommend': request.POST.get('is_recommend'),
            'profile_pic': request.POST.get('avatar')[:-2],
            'nick_name': request.POST.get('nick_name'),
            'tag_ids': tag_ids,
            'is_puppet': request.POST.get('is_puppet'),
            'city_id': request.POST.get('city', '').split(":")[0],
            'phone': request.POST.get('phone'),
            'email': request.POST.get('email'),
            'gender': request.POST.get('gender'),
        }

        try:
            self.rpc['venus/sun/user/edit'](id=id, data=data).unwrap()
        except Exception as e:
            raise e
        return {
            'message': '更新成功'
        }


class UserGroupView(APIView):
    def get(self, request):
        user_id = request.GET.get('id')
        offset = int(request.GET.get('page', 0))
        count = int(request.GET.get('limit', 10))
        filters = {'user_id': user_id}
        try:
            data = self.rpc['venus/sun/group/user/list'](filters=filters, offset=(offset - 1) * count, limit=count).unwrap()
        except Exception as e:
            raise e
        return data