import request from '@/utils/request'

export function fetchList(query) {
  return request({
    url: '/api/group/list',
    method: 'get',
    params: query
  })
}

export function OffLineOrOnLine(data) {
  return request({
    url: '/api/group/list/update',
    method: 'post',
    data
  })
}

export function GroupDetail(id) {
  return request({
    url: '/api/group/get',
    method: 'get',
    params: { id }
  })
}

export function createGroup(data) {
  return request({
    url: '/api/group/create',
    method: 'post',
    data
  })
}

export function fetchGroupRelateduser(query) {
  return request({
    url: '/api/group/user/list',
    method: 'get',
    params: query
  })
}

export function GroupUserDetail(id) {
  return request({
    url: '/api/group/user/get',
    method: 'get',
    params: { id }
  })
}

