/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

class ApkSigningPayload {
    private final int id;
    private final ByteBuffer buffer;

    ApkSigningPayload(int id, ByteBuffer buffer) {
        this.id = id;
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
        this.buffer = buffer;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getByteBuffer() {
        byte[] array = this.buffer.array();
        int arrayOffset = this.buffer.arrayOffset();
        return Arrays.copyOfRange(array, arrayOffset + this.buffer.position(), arrayOffset + this.buffer.limit());
    }
}

