/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.meituan.android.walle.ChannelWriter;
import com.meituan.android.walle.SignatureNotFoundException;
import com.meituan.android.walle.commands.IWalleCommand;
import com.meituan.android.walle.utils.CommaSeparatedKeyValueConverter;
import com.meituan.android.walle.utils.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Parameters(commandDescription="channel apk batch production")
public class BatchCommand
implements IWalleCommand {
    @Parameter(required=true, description="inputFile [outputDirectory]", arity=2, converter=FileConverter.class)
    private List<File> files;
    @Parameter(names={"-e", "--extraInfo"}, converter=CommaSeparatedKeyValueConverter.class, description="Comma-separated list of key=value info, eg: -e time=1,type=android")
    private Map<String, String> extraInfo;
    @Parameter(names={"-c", "--channelList"}, description="Comma-separated list of channel, eg: -c meituan,xiaomi")
    private List<String> channelList;
    @Parameter(names={"-f", "--channelFile"}, description="channel file")
    private File channelFile;

    @Override
    public void parse() {
        File inputFile = this.files.get(0);
        File outputDir = null;
        if (this.files.size() == 2) {
            outputDir = Util.removeDirInvalidChar(this.files.get(1));
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
        } else {
            outputDir = inputFile.getParentFile();
        }
        if (this.channelList != null) {
            for (String channel : this.channelList) {
                this.generateChannelApk(inputFile, outputDir, channel);
            }
        }
        if (this.channelFile != null) {
            try {
                List<String> lines = IOUtils.readLines((InputStream)new FileInputStream(this.channelFile), "UTF-8");
                for (String line : lines) {
                    String channel;
                    String lineTrim = line.trim();
                    if (lineTrim.length() == 0 || lineTrim.startsWith("#") || (channel = line.split("#")[0].trim()).length() == 0) continue;
                    this.generateChannelApk(inputFile, outputDir, channel);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateChannelApk(File inputFile, File outputDir, String channel) {
        String name = FilenameUtils.getBaseName(inputFile.getName());
        String extension = FilenameUtils.getExtension(inputFile.getName());
        String newName = name + "_" + channel + "." + extension;
        File channelApk = new File(outputDir, newName);
        try {
            FileUtils.copyFile(inputFile, channelApk);
            ChannelWriter.put(channelApk, channel, this.extraInfo);
        }
        catch (SignatureNotFoundException | IOException e) {
            e.printStackTrace();
        }
    }
}

