#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15


from django.core.cache import cache
from django.core.exceptions import PermissionDenied

import helios.rpc
from helios.rpc.object_mapping import SimpleMapper
import gm_logging.django.middleware
from django.conf import settings
from utils.logger import auth_logger, log_error


switch_key = lambda s, d: "SESSION_SWITCH:{}::{}".format(s, d)


rpc_invoker = helios.rpc.create_default_invoker(debug=settings.DEBUG).with_config(dump_curl=settings.DEBUG)
simple_mapper = SimpleMapper()
rpc_mapper = rpc_invoker.with_config(object_mapper=simple_mapper)


class MiddlewareMixin(object):
    def __init__(self, get_response=None):
        self.get_response = get_response
        super(MiddlewareMixin, self).__init__()

    def __call__(self, request):
        response = None
        if hasattr(self, 'process_request'):
            response = self.process_request(request)
        if not response:
            response = self.get_response(request)
        if hasattr(self, 'process_response'):
            response = self.process_response(request, response)
        return response


class RPC(object):
    def __init__(self, session, request):
        self.rpc_invoker = rpc_invoker.with_config(
            session_key=session,
            client_info=gm_logging.django.middleware.get_client_info_of_request(request),
        )
        self.origin = self.rpc_invoker
        self.mapper = self.rpc_invoker.with_config(object_mapper=simple_mapper)


class RPCSetupMiddleware(MiddlewareMixin):
    def process_request(self, request):
        ori_session = request.COOKIES.get(settings.USER_COOKIE_NAME, '')
        request.login_session = ori_session
        rpc = RPC(request=request, session=ori_session)
        request.rpc = rpc
        return None
