
import Layout from '@/views/layout/Layout'


const GroupRouter = {
  path: '/group',
  component: Layout,
  redirect: '/group/list',
  name: 'Group',
  meta: {
    title: '小组管理',
    icon: 'component',
    roles: ['staff']
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/group/list'),
      name: 'GroupList',
      meta: {title: '小组列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/group/create'),
      name: 'CreateGroup',
      meta: {title: '创建小组', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/group/edit'),
      name: 'EditGroup',
      meta: {title: '编辑小组', noCache: true},
      hidden: true
    }
  ]
}

export default GroupRouter
