#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json

from alpha_types.venus.enum import (
    SKIN_ALL_CLASSIFY,
    SKIN_CHECK_ITEMIZE_TYPE,
    SKIN_QUALITY_COLOR_DESC,
    SKIN_QUALITY_TEMPERATURE,
    SKIN_QUALITY_OIL_LEVEL,
    SKIN_PORE_SEVERITY,
    SKIN_ROUGHNESS_TYPE,
    SKIN_ACNE_TYPE,
    SKIN_BLACK_HEADS_TYPE,
    SKIN_DARK_CIRCLE_TYPE,
)

from utils.base import APIView, get_offset_count
from utils.logger import error_logger


class SkinCheckPictorial(APIView):

    def get(self, request):
        try:
            data = self.rpc['venus/sun/skin_check/get_pictorial_info']().unwrap()

            for item in data:
                if item.get("skin_classify") == SKIN_ALL_CLASSIFY.SKIN_QUALITY:
                    item["skin_classifiy_desc"] = u"肤色"

        except Exception as e:
            error_logger.error(u'获取测肤榜单配置失败%s', e)
            raise

        return data

    def post(self, request):

        modify_data = []
        try:
            self.rpc['venus/sun/skin_check/pictorial_update_or_create'](
                modify_data=modify_data
            ).unwrap()

        except Exception as e:
            error_logger.error(u'变更测肤榜单配置失败%s', e)
            raise

        return {
            "message": u"操作成功",
        }


class SkinCheckConfig(APIView):

    def get(self, request):

        data = {
            "skin_color": {},  # 肤色
            "temperature": {},  # 色温
            "oil_level": {},  # 干油性
            "severity": {},  # 毛孔
            "roughness": {},  # 粗糙度
            "black_head": {},  # 黑头
            "dark_circle": {},  # 黑眼圈
            "acne": {},  # 痘痘
        }

        try:
            venus_data = self.rpc['venus/sun/skin_check/all_config']().unwrap()
            data.update({
                "skin_color": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.SKIN_COLOR, {}),  # 肤色
                "temperature": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.TEMPERATURE, {}),  # 色温
                "oil_level": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.OIL_LEVEL, {}),  # 干油性
                "severity": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.SEVERITY, {}),  # 毛孔
                "roughness": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.ROUGHNESS, {}),  # 粗糙度
                "black_head": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.BLACK_HEAD, {}),  # 黑头
                "dark_circle": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.DARK_CIRCLE, {}),  # 黑眼圈
                "acne": venus_data.get(SKIN_CHECK_ITEMIZE_TYPE.ACNE, {}),  # 痘痘
            })
        except Exception as e:
            error_logger.error(u'获取测肤配置失败%s', e)
            raise

        return data

    def post(self, request):

        modify_data = []
        try:
            self.rpc['venus/sun/skin_check/config_update_or_create'](
                modify_data=modify_data
            ).unwrap()

        except Exception as e:
            error_logger.error(u'变更测肤配置失败%s', e)
            raise

        return {
            "message": u"操作成功",
        }
