import json
from utils.base import APIView, get_offset_count
from utils.logger import error_logger


class BeautyListView(APIView):

    def get(self, request):
        offset, count = get_offset_count(request)
        word_parent_id = request.GET.get('word_parent_id', None)
        is_online = request.GET.get('is_online', None)

        data = self.rpc['venus/sun/beauty/list'](offset=offset, count=count, word_parent_id=word_parent_id, is_online=is_online).unwrap()
        return data


class BeautyInfoView(APIView):
    
    def get(self, request):
        id_ = request.GET.get('id')

        data = self.rpc['venus/sun/beauty/get'](id_=id_).unwrap()
        return data


class BeautyCreateView(APIView):

    def post(self, request):
        url = request.POST.get('url', None)
        word_parent_id = request.POST.get('word_parent_id', None)

        if not url or not word_parent_id:
            return r'缺少参数'

        data = self.rpc['venus/sun/beauty/add'](url=url, word_parent_id=word_parent_id).unwrap()

        return data


class BeautyUpdateView(APIView):
    
    def post(self, request):
        id_ = request.POST.get('id', None)
        url = request.POST.get('url', None)
        word_parent_id = request.POST.get('word_parent_id', None)

        if not id_:
            return r'缺少参数'

        data = self.rpc['venus/sun/beauty/edit'](id_=id_, url=url, word_parent_id=word_parent_id).unwrap()
        if not data:
            return r'更新失败'

        return data


class BeautyDeleteView(APIView):
    
    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        
        if not ids:
            return r'缺少参数'

        for id_ in ids:

            data = self.rpc['venus/sun/beauty/delete'](id_=id_).unwrap()
            if not data:
                return r'操作失败'

        return data
