#article -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from .utils.enum import Enum, unique

__all__ = [  # for convenience to import * for back porting, you MUST NOT need to add this list
    "JUMP_TYPE", "STAGE_STATUS", "REPORT_ACTIONS", "REFUND_STATUS", "DIARY_ORDER_TYPE",
    "VERIFY_CODE_TYPE", "SLIDE_LAYOUT", "RECOMMEND_TYPE", "PLATFORM_CHOICES", "SERVICE_MONITOR_STATUS",
    "ORDER_STATUS", "PRIVATE_CONVERSATION_STATUS", "PROBLEM_RATE_CHOICES", "PRIVATE_MESSAGE_PUSH_STATUS",
    "NEW_CASH_BACK_STATUS", "BALANCE_PAYMENT_TYPE",
    "DIARY_QUERY_TYPE", "POINTS_OPERATION", "ORDER_QUERY_TYPE", "SERVICE_FLAG", "BLOCK_USER_REASON",
    "PRIVATE_STATUS", "MY_COMMENT_TYPE", "IMAGE_TYPE", "TOPIC_TYPE", "SERVICE_ACTIVITY_TYPE", "ACTIVITY_STATUS",
    "USER_ORDER_TYPE", "MESSAGE_ORDER_TYPE", "SERVICE_OPERATION_TYPE", "SECKILL_STATUS", "TAG_TYPE",
    "ALERT_RATING_TYPE", "SERVICE_MODE", "AUTHOR_TYPE", "SLIDE_POSITION", "ORDER_OPERATION_ROLE",
    "SERVICE_CHANNEL", "SERVICE_HOME_SECKILL_STATUS", "REPORT_REASON", "PLATFORM_CHANNEL", "ANTI_BRUTE_TYPE",
    "PAYMENT_CHANNEL", "PROBLEM_STATUS_CHOICES", "LOGIN_AUTH_TYPE", "USER_TYPE", "COMPAIGN_STATUS",
    "ORDER_DURATION", "PAYMENT_TYPE_V2", "SLIDE_TYPE", "PROBLEM_ORDER_TYPE", "REPORT_TYPE",
    "USER_TAG_CHOICES", "SERVICE_TYPE", "DOCTOR_ORDER_TYPE", "MESSAGE_TYPE", "CONVERSATION_STATUS",
    "ORDER_BY_TYPE", "TOPIC_ORDER_TYPE", "DOCTOR_REFUND_TYPE", "ORDER_SOURCE", "COUPON_TYPE",
    "DOCTOR_PROCESS_STATUS", "CASH_BACK_STATUS", "PHONE_LOGIN_TYPE", "PUSH_TYPE", "PROBLEM_FLAG_CHOICES",
    "PROBLEM_REVIEW_STATUS_CHOICES", "POINTS_TYPE", "PHONE_HINTS", "ORDER_OPERATION_TYPE", "SERVICEREGISTER_STATUS",
    "SERVICE_ORDER_TYPE", "DOCTOR_TYPE", "HOSPITAL_TYPE", "BUSINESS_CHANNEL", "PAYMENT_TYPE",
    "PASSWORD_CHANGE_TYPE", "VOTEOBJECT", "LOGIN_TYPE", 'TYPES', "SERVICE_ADVERTISE_TYPE", "MIXED_TYPE", "PLAN_TYPE",
    "TREATMENT_TYPE", "RECOVER_TIME_TYPE", "WIKI_COMPLEXITY_TYPE", "SURGICAL_GRADE_CHOICES", "TREATMENT_MEANS_CHOICES",
    "WIKI_RISK_FACTOR_TYPE", "ZONE_TYPE", "WIKI_HOSPITAL_TREATMENT_CHOICES", 'CONVERSATION_PARTNER_TYPE',
    "TOPIC_ORDER_IN_DIARY", "VOTE_PK_TYPE", "COMMUNITY_COLUMN_TYPE", "HERA_OPERATE_LOG_PACKAGE",
    "HERA_OPERATE_LOG_ACTION", "TOPIC_ORDER_IN_DIARY", "VOTE_PK_TYPE", "COMMUNITY_COLUMN_TYPE", "AGREEMENT_TYPE",
    "FREECUSTOM_STATUS_TYPE", "DIARY_AUDIT_STATUS", "DIARY_CONTENT_LEVEL", "DIARY_OPERATE", "SERVICE_REVIEW_STATUS",
    "SERVICE_REVIEW_TYPE", "OPTIMIZE_WIKI_TYPE", "ACHE_LEVEL", "ANESTHESIA_TYPE", "WIKI_LEVEL",
    "NOTIFY_EVENT", "NOTIFY_OPERATION", "STAGGERED_ENUM", "MAIDAN_REVIEW_STATUS", "TICKETS_STATUS", "SPECIAL_MODULE",
    "ZONE_DETAIL_SORT_TYPE", "ZONE_DETAIL_TAB_TYPE", "YINUO_TYPE", "ZHONGAN_TYPE",
    "ZONE_TYPE_V2", "DOCTOR_SECKILL_APPLY_STATUS", "WORLD_AREA_TYPE", "ADVER_MANAGEMENT_TYPE",
    "ADVER_MANAGEMENT_POSITION_TYPE", "TAB_ICON_SIZE", "FILTER_WORD_TYPE",
    "CATEGORY_TYPE", "ACCOUNT_TYPE", "PUSH_USER_TYPE",
    "SERVICE_COMMENT_OPTION_TYPES", "SERVICE_COMMENT_OPTION", "SPECIAL_EXTRA_POSITION",
    "ACTIVITY_TYPE_SOC", "RANK_LIST_TYPE", "MULTITOPIC_TYPE", "MULTITOPIC_SERVICE_TYPE", "XCX_LANDING_PAGE",
    "TRANSFER_SOURCE", "USER_NTENTION", "USER_POTENTIAL", "SINGLE_TYPE",
    "VOTE_CHANGE_TYPE", "VOTE_STATUS", "SPECIAL_RULE_SET", "PUNISHMENT_PV_LIMIT_DEMESION", "OPERTOR_REVIEW_TYPE",
    "CHECK_TYPE", "RECEVEIVINGEND", "DISPLAY_SITE","MERCHANT_LEVEL", "PULL_BLACK_TYPE", "RANGE_TYPE", "TAG_V3_TYPE"
]


@unique
class TYPES(Enum):
    """object types in our system, such as service, order, reservation etc."""

    RESERVATION = ('0', '预约')
    ORDER = ('1', '订单')
    REFUND_ORDER = ('2', '退款单')
    TOPIC = ('3', '帖子')
    DIARY = ('4', '日记本')


class CLIENT_TYPE(Enum):
    """
        端 的 来源
    """
    USER = (0, '用户版客户端')
    DOCTOR = (1, '医生版客户端')
    SHEQU = (2, '社区版客户端')  # for aso


class VOTEOBJECT(Enum):
    TOPIC = ('0', '帖子的赞')
    DIARY = ('1', '日记本的赞')
    QUESTION = ('2', '问题的赞')
    ANSWER = ('3', '回答的赞')
    TOPIC_REPLY = ('4', '日记帖回复的赞')
    TRACTATE = ('5', '帖子的赞')
    TRACTATE_REPLY = ('6', '帖子回复的赞')
    ANSWER_REPLY = ('7', '回答评论的赞')
    ACTIVITY_TOPIC = ('8', '活动贴点赞')
    SOFT_ARTICLE_REPLY = ('9', '医生短文评论点赞')


class FAVOROBJECT(Enum):
    TOPIC = ('0', '帖子的收藏')
    DIARY = ('1', '日记本的收藏')
    TRACTATE = ('2', '帖子的收藏')
    PROBLEM = ('3', '话题收藏')
    QUESTION = ('4', '问题收藏')
    ANSWER = ('5', '回答收藏')


class REPLYOBJECT(Enum):
    TOPIC = ('0', '帖子的评论')
    PROBLEM = ('1', '话题的评论')
    TRACTATE = ('2', '帖子的评论')
    ANSWER = ('3', '话题回答')
    ANSWER_REPLY = ('4', '回答评论')
    SOFT_ARTICLE = ('5', '医生短文评论')
    QUALITY_QUESTION = ('6', '追问')
    QUALITY_ANSWER = ('7', '追问回复')
    QUALITY_REPLY = ('8', '追问评论')


class TAG_FROM(Enum):
    """
    展示的标签 来源
    """
    CREATE_DIARY = ('0', '创建日记本时的热门标签')
    CREATE_ANSWER = ('1', '创建问题页选择标签')
    ALL_TYPE = ('2', '全部分类页面')
    TRACTATE_COMMEND = ('3', '创建日记本时的热门标签')


class JUMP_TYPE(Enum):
    TOPIC = ('0', '话题')
    URL = ('1', '指定网页')
    SERVICE = ('2', '服务详情')
    MY_POINTS = ('3', '我的积分')
    INVITE = ('4', '邀请好友')
    CREATE_TOPIC = ('5', '创建话题')
    CONVERSATION = ('6', '私信详情')


class QA_JUMP_TYPE(Enum):
    QUESTION = (0, '问题')
    ANSWER = (1, '回答')


class SERVICE_MONITOR_STATUS(Enum):
    NORMAL = (0, '正常')
    ALERT = (1, '报警')
    BLACK = (2, '黑名单')


class SEARCH_TAB_TYPE(Enum):
    """搜索页tab类型"""

    ALL = (0, '综合')
    SERVICE = (1, '美购')
    DIARY = (2, '日记')
    EXPERT = (3, '医生')
    HOSPITAL = (4, '医院')
    KNOWLEDGE = (5, '知识')
    WIKI = (6, '百科')
    TRACTATE = (7, '帖子')


class PROBLEM_RATE_CHOICES(Enum):
    SATISFIED = ('0', '满意')
    NORMAL = ('1', '一般般')
    UNSATISFIED = ('2', '不满意')


class REFUND_STATUS(Enum):
    PROCESSING = (0, '处理中')
    DOCTOR_REJECT = (1, '医生拒绝')
    ARBITING = (2, '等待仲裁')
    ARBIT_APPROVE = (3, '仲裁同意')
    ARBIT_REJECT = (4, '仲裁拒绝')
    REFUNDED = (5, '退款完成')
    CANCLED = (6, '已取消')
    # 以下两种状态仅供后端逻辑判断,不在商户后台显示. 详细请联系yangchuncheng#wanmeizhensuo.com
    REFUND_APPLY_SELLER_TIMEOUT = (7, '用户申请退款,商户决策超时')
    DOCTOR_APPROVE = (8, '商户主动同意退款')
    # 一旦进入此状态后, 此订单不可以再被退款or返现
    REFUNDING = (9, '已经开始进入第三方退款流程')


# LET BACKEND KNOW, IF UPDATED
# USE COUPON_STATUS, DON'T USE THIS
class COUPON_TYPE(Enum):
    UNCLAIMED = (0, '未领取')
    CLAIMED = (1, '已领取')
    FROZEN = (2, '被冻结')
    CONSUMED = (9, '已消费')


class BLOCK_USER_REASON(Enum):
    ad = ('0', '广告')
    harass = ('1', '恶意骚扰')
    other = ('2', '其他')


class MY_COMMENT_TYPE(Enum):
    RECEIVED = (0, '我的收到的评论')
    SENT = (1, '我发出的评论')


class SECKILL_STATUS(Enum):
    BEFORE = (0, '未开始')
    UNDERWAY = (1, '进行中')
    AFTER = (2, '已结束')


class SERVICE_HOME_SECKILL_STATUS(Enum):
    NONE = (-1, '没有秒杀')
    ACTIVE = (0, '进行中')
    NOT_START = (1, '未开始')


class USER_TYPE(Enum):
    NORMAL = (0, '普通用户')
    EXPERT = (1, '专家')
    OFFICER = (2, '机构')


class CONVERSATION_PARTNER_TYPE(Enum):
    DOCTOR = (0, '专家')
    NORMAL = (1, '普通用户')
    SUOZHANG = (2, '所长大人')


class ORDER_DURATION(Enum):
    NORMAL = (0, '正常')
    REFUND = (1, '退款')
    CASHBACK = (2, '返现')


class PROBLEM_ORDER_TYPE(Enum):
    DEFAULT = (0, '默认')
    CITY = (1, '同城在前')
    CHANNEL_HEADLINE = (2, '频道置顶')
    TO_BE_ANSWERED = (3, '等待回复')
    LATEST_CREATED = (4, '最新发布')
    HAS_IMAGE = (5, '图片优先')
    SEARCH_DEFAULT = (6, '搜索默认')
    PGC = (7, 'PGC内容')
    RANKING_POPULARITY = (8, '热度分')
    ZONE_SUGGEST = (9, '圈子推荐')


class SERVICE_TYPE(Enum):
    OPERATION = (0, '手术类')
    NO_OPERATION = (1, '非手术类')


class ORDER_STATUS(Enum):
    NOT_PAID = ('0', '未付款')
    PAID = ('1', '已付款')
    PAYING = ('10', '付款中')
    USED = ('2', '已使用')
    REFUNDED = ('3', '已退款')
    SETTLED = ('4', '已结算')
    CANCEL = ('5', '已取消')
    WAIT_REFUNDED = ('6', '退款处理中')
    OTHER = ('7', '其它')  # 已不用2016.06.24
    AUDITING = ('8', '审核中')  # 已不用2016.06.24
    SETTLING = ('9', '结算中')  # 已不用2016.06.24
    # 数据库中不存在正在退款这个状态, 这个状态对应以下两种退款状态：
    # REFUND_APPLY_SELLER_TIMEOUT = (7, '用户申请退款,商户决策超时')
    # DOCTOR_APPROVE = (8, '商户主动同意退款')
    REFUNDING = ('11', '正在退款')


class BALANCE_PAYMENT_TYPE(Enum):
    '''尾款支付方式'''
    ALL = (0, "全部") # 包含没有尾款的情况
    INSTALLMENT = (1, "分期") # 有尾款， 尾款分期
    NOT_INSTALLMENT = (2, "非分期") # 有尾款，尾款非分期


class ORDER_STATUS_FILTER(Enum):
    ALL = ('-1', '所有状态')
    NOT_PAID = ('0', '未付款')
    PAID = ('1', '已付款')
    PAYING = ('10', '付款中')
    USED = ('2', '已使用')
    REFUNDED = ('3', '已退款')
    SETTLED = ('4', '已结算')
    CANCEL = ('5', '已取消')
    WAIT_REFUNDED = ('6', '退款处理中')
    OTHER = ('7', '其它')  # 已不用2016.06.24
    AUDITING = ('8', '审核中')  # 已不用2016.06.24
    SETTLING = ('9', '结算中')  # 已不用2016.06.24


class ORDER_CATEGORY(Enum):
    NORMAL = (1, u'普通订单')
    FARMING = (2, u'刷单')


class DOCTOR_ORDER_TYPE(Enum):
    DEFAULT = (0, '智能排序')  # 1:与用户同城的专家在前; 2:有在售福利的专家在前; 3:与用户同城的专家在前; 4:按最后一次回复时间排序
    POPULARITY = (1, '好评专家')  # 1.专家相关日记数大于10在前; 2.按最新发布/回复时间排序;
    DEFAULT2 = (2, '智能排序2')  # 1:有在售福利的专家在前; 2:有日记本的在前; 3:与用户同城的专家在前; 4:按最后一次回复时间排序
    ONLINE_CONSULTATION = (3, '在线咨询')  # 1:支持私信功能的专家在前; 2:绑定了手机号的专家在前; 3:按最新回复时间（帖子+私信）排序
    ADVERTISE_ORDER = (4, '广告位')  # http://wiki.gengmei.cc/pages/viewpage.action?pageId=3367497
    DORIS_SMART = (5, '新智能排序')


class ORDER_BY_TYPE(Enum):
    DEFAULT = ('0', '智能排序')
    CASE = ('1', '日记最多')
    CONSULT = ('2', '在线咨询')
    REPLY = ('3', '回复活跃')


class TOPIC_ORDER_TYPE(Enum):
    WAIT_REPLY = (0, '等待回复')  # 1级排序：没有医生回复在前；2级排序：按照提问时间倒序；下沉
    JUST_RELEASED = (1, '最新发布')  # 按照提问时间倒序；下沉
    HAVE_IMG_TOP = (2, '图片优先')  # 1级排序：有图片在前；2级排序：提问时间倒序；下沉


class ORDER_OPERATION_TYPE(Enum):
    PAY = (0, '付款')
    VALIDATE = (1, '订单验证')
    CANCEL = (2, '取消付款')
    USE = (4, '使用')
    SETTLE = (5, '结算')
    REFUNDED = (6, '退款完成')
    CANCEL_REFUND = (7, '用户取消退款')
    DOCTOR_REJECT = (8, '医生拒绝退款请求')
    DOCTOR_APPROVE = (9, '医生同意退款请求')
    APPEAL_ARBIT = (10, '用户申诉')
    ARBIT_APPROVE = (11, '运营仲裁同意')
    ARBIT_REJECT = (12, '运营仲裁拒绝')
    APPLY_CASHBACK = (13, '申请返现')
    CASHBACKED = (14, '返现完成')
    CREATE = (15, '创建')
    APPLY_REFUND = (16, '申请退款')
    NOT_PAID = (17, '设置订单未支付')
    PAYING = (18, '设置订单为支付中')
    REFUND_TIMEOUT = (19, '医生超时未处理,系统自动退款')
    STALE_REFUND = (20, '支付渠道过期订单, 运营线下退款完成后')
    STALE_CASHBACK = (21, '支付渠道过期订单, 运营线下返现完成后')
    TAG_STALE_REFUND = (22, '支付渠道告知, 标记为过期退款单')
    TAG_STALE_CASHBACK = (23, '支付渠道告知, 标记为过期返现单')
    LOW_BALANCE = (24, '支付渠道预结算金额不足退款失败')
    REFUND_ERROR = (25, '退款网关发生错误')
    CASHBACK_ERROR = (26, '返现网关发生错误')
    GROUPBUY_FAIL = (27, '拼团未成功')


class SERVICE_ORDER_TYPE(Enum):
    DEFAULT = (0, '智能排序')  # 1:与用户同城的福利在前; 2:按展示顺序(小的在前); 3:按最后修改时间
    ORDER_HIGHEST_SALES = (4, '销量最高')  # 1:按显示销量; 2:按展示顺序; 3:按最后修改时间 # 大家都在买
    ORDER_LOWEST_PRICE = (5, '价格最低')
    ORDER_NEWEST_SALES = (6, '最新上架')  # DEPRECATED
    CASE_COUNT = (7, '日记最多')
    DISCOUNT = (8, '折扣最大')  # DEPRECATED
    DEFAULT_SPECIAL = (9, '专题页智能排序')
    PROMOTION99 = (10, '9.9大促专题页智能排序')  # DEPRECATED
    REGION = (11, '根据传入地区就近')
    DISTANCE = (12, '离我最近(geo sorting)')
    ORDER_EVALUATE = (13, '评价最高')
    POPULARITY = (14, '人气最高')
    LOWEST_PRICE_SPECIAL = (15, '专场中价格最低')
    ADVERTISE_ORDER = (16, '广告排序')
    DIARY_RECOMMENDED = (17, '日记本详情页推荐美购')
    DORIS_SMART = (18, '策略平台新智能排序')
    ORDERED_USER = (19, '用户买过')
    CLOSEST = (20, '离我最近')
    ORDER_HIGHEST_PRICE = (21, '价格最高')
    DEFAULT_REALTIME = (22, '实时智能排序')
    DEFAULT2 = (23, '智能排序2')
    NEARBY_REGION = (24, '临近地域排序')

    # 医生医院自定义排序
    DOCTOR_CUSTOMIZE_SORT = (26, u'医生自定义排序')
    HOSPITAL_CUSTOMIZE_SORT = (27, u'医生自定义排序')

    ORDER_LOWEST_PRICE_FOR_SKU = (28, '价格最低')  # sku mapping 价格最低
    HIGHEST_SALES_FOR_SMART_RANK2 = (29, '销量最高')  # 1:按smart_rank2; 2:按展示顺序; 3:按最后修改时间


class AUTHOR_TYPE(Enum):
    USER = ('0', '普通用户')
    DOCTOR = ('1', '医生')


class DIARY_ORDER_TYPE(Enum):
    DEFAULT = ('0', '默认')
    RATE_ASC = ('1', '评价上升')
    RATE_DESC = ('2', '评价下降')
    PRICE_ASC = ('3', '价格上升')
    PRICE_DESC = ('4', '价格下降')
    POPULARITY = ('5', '按热度排序')
    LAST_UPDATE_TIME = ('6', '最后更新时间')
    GREATEST_HITS = ('7', '编辑精选')  # 1:【精华】【首页推荐】日记本在前，其他在后; 2:按照楼主最新回复时间排列
    HOT = ('8', '热门日记')  # 1:【热门】日记本在前，其它在后; 2:按照楼主最新回复时间排列
    DOCTOR_CASE = ('9', '专家日记')  # 1:已关联【福利】日记本在前，其他在后; 2: 已关联【更美上架专家】日记本在前，其他在后; 3:按照楼主最新回复时间排列
    YOU_MAY_LIKE = ('10', '猜你喜欢')  # 1:打了“所长推荐”“热门关注”“美购日记”tag or 标了“首页推荐”; 2:有cover的在前; 3:最后回复时间
    CREATE_TIME = ('11', '创建时间')
    LAST_TOPIC_ADDED_ASC = ('12', '最后发帖时间升序')
    LAST_TOPIC_ADDED_DESC = ('13', '最后发帖时间降序')
    SERVICE_RELATED = ('14', '美购(福利)详情页相关案例(日记本)')
    # http://wiki.gengmei.cc/pages/viewpage.action?pageId=1048926
    # Order: 1级：首页推荐的在前, 2级：5星好评的在前, 3级：赞数多的日记本在前, 4级：最后回复时间近的在前
    SUGGEST = '15', '推荐案例'
    STICKY_POST = ('16', '置顶')
    SERVICE_DETAIL = ('17', '美购详情页关联')  # http://wiki.gengmei.cc/pages/viewpage.action?pageId=2628662
    INDEX = ('18', '首页推荐')
    REPLY_NUM = ('19', '日记本评论数')  # 评论多的排前面
    FEED_FILTER = ('20', 'feed实时过滤') # feed 实时过滤候选集

    SEARCH_V1 = ('21', '搜索结果规则') # 用户没有做地区选择
    RECOMMEND = ('22', '推荐')
    # v 7.6.65 满足内容聚合页需求，新增排序
    NATIVE = ("23", "本地")  # 1、按照{同城、临近城市、全国}排列; 2、按照综合排序排列;
    BEST = ("24", "精华")  # 1、按照{优秀、良好}排序; 2、按照{同城、临近城市、全国}排列; 3、按照综合排序排列
    BEST_EVALUATION = ("25", "评价最优")  # 日记本对应美购的评价 1、评价得分 {5.0，4.8-4.9，4.5-4.7，4-4.4，<4}; 2、按照{同城、临近城市、全国}排列; 3、按照综合排序排列

    # 医生医院自定义排序
    DOCTOR_CUSTOMIZE_SORT = ('26', u'医生自定义排序')
    HOSPITAL_CUSTOMIZE_SORT = ('27', u'医生自定义排序')

    TOPIC_COUNT = ('28', "贴子数排序")
    TOPIC_COUNT_DESC = ('29', "贴子数逆序排序")

    REPLY_COUNT = ('30', "回复数排序")
    REPLY_COUNT_DESC = ('31', "贴子数逆序排序")

    VOTE_COUNT = ('32', "赞数排序")
    VOTE_COUNT_DESC = ('33', "赞数逆序排序")

    TOTAL_PV = ('34', "PV数排序")
    TOTAL_PV_DESC = ('35', "PV数逆序排序")

    CONCONTENT_LEVEL = ('36', "评级排序")
    CONCONTENT_LEVEL_DESC = ('37', "评级逆序排序")
    FEED = ('38','按feed得分排序')


class VERIFY_CODE_TYPE(Enum):
    CREATE = (0, '创建用户')
    LOGIN = (1, '登陆')
    BIND = (2, '手机绑定')
    UPDATE = (3, '修改属性')
    DOCREG = (4, '医生注册')
    UPDATE_PHONE = (5, '更新手机号')
    CHANGE_PHONE_NUMBER = (6, '修改提交的手机号码')
    ACTIVITY_APPLY = (7, '活动报名')
    USER_AUTHENTICATION = (8, '实名认证')
    REGIN = (9, '注册登录')


class PRIVATE_CONVERSATION_STATUS(Enum):
    NORMAL = ('0', '正常')
    ALERTED = ('1', '已提醒')
    NEED_TRANSFER = ('2', '需要转移')
    TRANSFERRED = ('3', '已转移')


class ORDER_QUERY_TYPE(Enum):
    ALL = (0, '全部')
    DOCTOR = (1, '医生')
    HOSPITAL = (2, '医院')
    SERVICE = (3, '福利名')
    AREA = (4, '地区')
    ORDER_NO = (5, '订单号')
    USERNAME = (6, '用户名')
    PHONE = (7, '手机号')


class ALERT_RATING_TYPE(Enum):
    RATED = ('0', '已经提醒过')
    ALERT_NEXT = ('1', '下次再提醒')
    NEVER_ALERT = ('2', '不再提醒')
    NEW_USER = ('3', '新用户')


class DOCTOR_TYPE(Enum):
    DOCTOR = ('0', '医生')
    OFFICER = ('1', '机构管理者')
    TRANSFER_CONSULTANT = ('2', '转诊咨询师')


class SEND_CHANNEL_TYPE(Enum):
    GMCXS = ('0', '更美尝鲜室')
    YMXBK = ('1', '医美小百科')
    SZWD = ('2', '所长问答')
    OTHER = ('3', '其他')


class ORDER_OPERATION_ROLE(Enum):
    USER = (0, '用户操作')
    DOCTOR = (1, '医生操作')
    STAFF = (2, '内部员工操作')
    SYSTEM = (3, '系统操作')


class SERVICE_CHANNEL(Enum):
    FAMOUS_DOCTOR = ('0', '名医')
    SPECIAL_OFFER = ('1', '特惠')
    GIFT = ('2', '免费')


class PLATFORM_CHANNEL(Enum):
    UNKNOWN = (0, '未知')
    IOS = (1, 'ios客户端')
    ANDROID = (2, 'android客户端')
    M = (3, 'm站')
    PC = (4, 'PC站')
    WECHAT_APP = (5, '微信小程序')
    MOMO = (6, "陌陌")
    DOCTOR = (7, "医生后台")


class COMPAIGN_STATUS(Enum):
    PENDING = (0, '待上线')
    ONLINE = (1, '已上线')
    OFFLINE = (2, '已下线')


class DOCTOR_PROCESS_STATUS(Enum):
    unprocessed = ('0', '未处理')
    processed = ('1', '已处理')


class REPORT_TYPE(Enum):
    TOPIC = ('0', '举报帖子')
    REPLY = ('1', '举报帖子回复')
    IMAGE = ('2', '举报图片')
    DIARY = ('3', '举报日记本')
    DIARY_REPLY = ('4', '举报日记本回复')


class PROBLEM_FLAG_CHOICES(Enum):
    MARK_DELETED = ('d', 'Mark Deleted')
    NORMAL = ('n', 'Normal')


class PHONE_HINTS(Enum):
    PERSONAL_PHONE = ('1', '医生个人电话')
    CLINIC_PHONE = ('2', '医生诊所电话')


class SERVICE_FLAG(Enum):
    HOSPITAL = (0, '医院')
    DOCTOR = (1, '医生')


class RECOMMEND_TYPE(Enum):
    NOT_RECOMMEND = ('0', '没有被推荐')
    RECOMMENDED_BY_SUOZHANG = ('1', '所长推荐')
    RECOMMENDED_HOT = ('2', '热门推荐')
    RECOMMENDED_IN_PAST = ('3', '往期推荐')
    RECOMMENDED_TO_FOLLOW = ('4', '推荐用户关注')
    RECOMMENDED_TRACTATE = ('5', '新帖子推荐')
    CLASS_A = ('6', '全部分类-A类别')
    CLASS_B = ('7', '全部分类-B类别')


class PRIVATE_MESSAGE_PUSH_STATUS(Enum):
    NOT_REVIEW = (0, '未审核')
    NOT_OK = (1, '审核未通过')
    OK = (2, '审核通过')


class POINTS_OPERATION(Enum):
    ADD = ('add', '添加')
    REMOVE = ('remove', '减去')


class DIARY_QUERY_TYPE(Enum):
    ALL = ('0', '全部')
    DOCTOR = ('1', '医生')
    HOSPITAL = ('2', '医院')
    SERVICE = ('3', '福利')
    USER = ('4', '用户名')
    ID = ('5', 'ID号')


class TOPIC_TYPE(Enum):
    # NOTE: ask + topic 统一为 讨论帖
    ASK = ('0', '寻求解答')  # 咨询帖
    SHARE = ('1', '经验分享')  # 日记贴
    TOPIC = ('2', '帖子')  # 讨论帖
    OLD_DIARY = ('3', '旧的日记帖')
    ACTIVITY = ('4', '免费活动帖')
    WEIXIN_NUM = ('5', '微信公众号')
    COLUMN_ARTICLE = ('6', '专栏文章')
    USER_ARTICLE = ('7', '优质用户文章')


class USER_ORDER_TYPE(Enum):
    LAST_LOGIN = (0, '最后登陆时间')


class MESSAGE_ORDER_TYPE(Enum):
    LAST_REPLY_TIME = (0, '最后回复时间')
    READ_STATUS = (1, '未读在前')


class REPORT_REASON(Enum):
    AD = ('0', '垃圾广告')
    SEXY = ('1', '色情内容')
    SOLICIT = ('2', '违规拉客')
    ATTACK = ('3', '人身攻击')
    FAKE = ('4', '虚假案例')
    OTHER = ('5', '其他')
    SPAM = ('6', '疑似广告')
    STEAL = ('7', '盗取案例')


class IMAGE_TYPE(Enum):
    PRE_OPERATION_IMAGE = (0, '术前图')
    POST_OPERATION_IMAGE = (1, '术后图')


class SERVICE_MODE(Enum):
    NORMAL = (0, '正常')
    SECKILL = (1, '秒杀')
    ACTIVITY = (2, '活动')


class PROBLEM_REVIEW_STATUS_CHOICES(Enum):
    NOT_REVIEW = (0, '待审核')
    OK = (1, '通过')
    CONTENT_LIMIT = (2, u'图片不足/字数不足')
    CONTENT_NOT_OK = (3, '内容不当')
    TEXT_LIMIT = (4, u'更新文字不足100字')
    IMG_COUNT_LIMIT1 = (5, u'图片不足6张')
    IMG_COUNT_LIMIT2 = (6, u'图片不足5张')
    IMG_GRAD_LIMIT1 = (7, u'隐私部位未穿戴内衣')
    IMG_GRAD_LIMIT2 = (8, u'局部有马赛克／遮挡物')
    FULL_FACE_LACK = (9, u'未提供全脸照')
    IMG_TEXT_LIMIT1 = (10, u'图片不足6张、更新文字不足100字')
    IMG_TEXT_LIMIT2 = (11, u'图片不足5张、更新文字不足50字')
    IMG_LIMIT1 = (12, u'局部照片过多')
    IMG_TEXT_LIMIT3 = (13, u'局部照片过多、更新文字不足100字')
    CONTENT_LIMIT2 = (14, u'内容无分享意义')
    IMG_TEXT_LIMIT4 = (15, u'图片有遮挡/马赛克、更新文字不足100字')
    IMG_TEXT_LIMIT5 = (16, u'图片有遮挡/马赛克、更新文字不足50字')
    IMG_IMG_LIMIT1 = (17, u'图片有遮挡/马赛克、图片不足6张')
    IMG_IMG_LIMIT2 = (18, u'图片有遮挡/马赛克、图片不足5张')
    TEXT_LIMIT2 = (19, u'更新文字不足50字')


# 迁移至msg submodule
from .msg import MESSAGE_TYPE


class PHONE_LOGIN_TYPE(Enum):
    NORMAL = ('0', '普通登陆')
    FIND_PASSWORD = ('1', '找回密码')


class STAGE_STATUS(Enum):
    SAVE = ('0', '待提交')
    SBMT = ('1', '已提交')
    DECL = ('2', '已拒绝')
    APRV = ('3', '已批准')
    DDWN = ('4', '已放款')
    CANL = ('5', '订单超时取消')
    POFF = ('6', '已还款毕')
    RESM = ('7', '用户取消贷款')
    RETN = ('8', '待补件')
    SBCT = ('9', '已提交合同')


class POINTS_TYPE(Enum):
    INVITE = ('0', '邀请好友')
    WAS_INVITE = ('1', '被邀请')
    VOTE = ('2', '回复被赞')
    SHARE = ('3', '发布经验帖')
    STAR = ('4', '帖子被加精华')
    BUY_SERVICE = ('5', '购买美购产品抵现金')
    CANCEL_ORDER = ('6', '取消订单退回美分')
    REGISTER = ('7', '注册成功更美账号')
    VOTE_OTHER = ('8', '赞别人')
    REPLY_OTHER = ('9', '回复帖子或评论')  # 7.6.20 后用REPLY_OTHERS
    REPLIED = ('a', '被回复')
    LOGIN = ('b', '签到赚美分')
    RATING = ('c', '给更美app好评')
    APP = ('d', '下载精品应用')
    HOT = ('e', '帖子被加热门')
    JOIN_ACTIVITY = ('f', '参加免费活动支出')
    TAKE_SOFA = ('g', '抢沙发回复帖子')
    EDIT_PROFILE = ('h', '完善头像')
    REPLY_DIARY = ('i', '给日记本评价')  # 7.6.20 后用REPLY_OTHERS
    PUBLISH_TOPIC = ('j', '发表术后日记帖')
    CHOSEN_DIARY = ('k', '日记被标记为优质')  # 日记被标记为优秀
    SIGN_IN = ('l', '每日签到')
    UPDATE_NICKNAME = ('m', '修改昵称')
    PAY = ('n', '特殊商品支付送美分')  # 2016双11大促添加
    SHARE_DOUBLE_11 = ('o', '分享有礼成功送美分')  # 2016双11大促添加
    REFUND_REMOVE_POINTS = ('p', '双十一大促退款扣美分')  # 2016双十一大促线下退款扣除美分
    INVITE_NEWBEE = ('q', '转盘新人邀请礼包')  # 新人邀请礼包
    REMOVE = ('r', '美分扣除')
    LEVEL_UPPER = ('s', '升级奖励美分200')
    REPLY_OTHERS = ('t', '在日记本/日记帖/回答下发布评论')  # added in 7.6.20
    REPLY_OTHERS_MULTI_TIMES = ('u', '累计评论6次')  # 7.6.20，累计6次
    VOTE_MULTI_TIMES = ('v', '累计点赞6次')  # 7.6.20，累计6次
    FOLLOW_MULTI_TIMES = ('w', '累计关注6次')  # 7.6.20，累计6次
    ANSWER_MULTI_TIMES = ('x', '累计回答6次')  # 7.6.20，累计6次
    ANSWER_QUESTION = ('y', '发现频道发布回答')
    ANSWER_RECOMMEND = ('z', '回答被标记为优质')
    BIND_PHONE = ('10', '绑定个人手机号')
    POINTS_LOTTERY = ('11', '美分商场抽奖')
    POINTS_EXCHANGE = ('12', '美分商场兑换')
    GET_POINTS_FROM_LOTTERY = ('13', '美分商场抽奖得到美分')
    SYSTEM_ADD = ('14', '系统异常,补偿美分')
    CLEAR_ANNUALLY = ('15', '年度美分清零')
    LIPSTICK_POINTS = ('16', '口红抽奖兑换')
    PLACE_ORDER = ('17', '下单返积分')

    # NOTE: !!!!!!!!!!!! only support two chars !!!!!!!!!!!!!
    # point_type = models.CharField(max_length=2, choices=POINTS_TYPE, null=False,
    #  default=POINTS_TYPE.INVITE, verbose_name=u'美分类型', unique=True)
    # NOTE: !!!!!!!!!!!! only support two chars !!!!!!!!!!!!!


class TASK_TYPE(Enum):
    DEFAULT = ('0', '普通任务')
    DAILY = ('1', '日常任务')
    ONCE = ('2', '一次性任务')


class PUSH_TYPE(Enum):
    MY_CONVERSATION = (8, '我的私信列表')
    DOCTOR_PRI_MSG_LIST = (19, '医生私信列表')


class PAYMENT_TYPE_V2(Enum):
    STANDARD = ('0', '标准')
    ENTITY = ('1', '实物')
    FREE_PAYMENT = ('2', '免费')


class PLATFORM_CHOICES(Enum):
    ANDROID = ('android', 'Android')
    IPHONE = ('iPhone', 'iPhone')
    WECHATXCX = ('xcx', "微信小程序")
    WECHAT_MouthGun = ('xcx-shudong ', "微信小程序-树洞")


# PAYMENT_TYPE 的定义被复制到 web/ship 项目中了。如有修改，请通知相关人员。
class PAYMENT_TYPE(Enum):
    FULL_PAYMENT = ('0', '全款')
    PREPAYMENT = ('1', '预付款')
    FREE_PAYMENT = ('2', '免费')
    EXCHANGE_GIFT = ('3', '礼品换购')


class PASSWORD_CHANGE_TYPE(Enum):
    CHANGE_PASSWORD = (0, '修改密码')
    SET_PASSWORD = (1, '设置密码')


class ANTI_BRUTE_TYPE(Enum):
    LOGIN_PHONE = ('0', '普通登陆')
    FIND_PASSWORD = ('1', '找回密码')
    LOGIN_PASSWORD = ('2', '密码登陆')


class NEW_CASH_BACK_STATUS(Enum):
    APPLY = (0, '申请返现')
    WAIT = (1, '返现审核中')
    SUCCESS = (2, '已返现')


class PAYMENT_CHANNEL(Enum):
    ALIPAY = ('0', '支付宝')
    WECHAT = ('1', '微信支付')
    APPLEPAY = ('2', 'apple pay')
    XIAOYING = ('3', '小赢分期')
    INSTALLMENT = ('4', '分期')


class SLIDE_LAYOUT(Enum):
    CAROUSEL = ('0', '轮播')
    FIXED = ('1', '固定')


class PRIVATE_STATUS(Enum):
    NORMAL = ('0', '普通问题')
    CONVERSATION = ('1', '可公开的私信')
    PRIVATE_CONVERSATION = ('2', '【私信】')
    TRANS_PRIVATE = ('3', '普通问题转成的私信')
    ASSIGN_DOCTOR = ('4', '指定医生')
    ASSIGN_DOCTOR_PRIVATE = ('5', '仅医生可见')
    ASSIGN_DOCTOR_ANSWERED = ('6', '指定医生[已回答]')
    ASSIGN_DOCTOR_PRIVATE_ANSWERED = ('7', '仅医生可见[已回答]')


# NOTE:
# SLIDE_TYPE 的定义被复制到 web/ship 项目中了。如有修改，请通知相关人员。
class SLIDE_TYPE(Enum):
    """跳转页类型
    """
    TOPIC = ('0', '话题')
    URL = ('1', '指定网页')
    SERVICE = ('2', '美购(spu)详情')
    MY_POINTS = ('3', '我的积分')
    INVITE = ('4', '邀请好友')
    CREATE_TOPIC = ('5', '创建话题')
    SERVICE_LIST = ('6', '美购列表')
    ZONE = ('7', '圈子首页')
    ZONE_SINGLE = ('8', '单个圈子列表页')
    DIARY = ('9', '日记本')
    TAG = ('10', '标签列表页')
    SPECIAL = ('11', '拼团专题')
    PROMOTION_GROUP = ('12', '大促聚合页')
    ANNIVERSARY_COUPON = ('13', '大促美劵页')
    SPECIAL_LIST_DIARY = ('14', '案例专题')
    ACTIVITY = ('15', '免费活动')
    SECKILL = ('16', '秒杀')
    SUOZHANG_COLUMN = ('17', '所长专栏')
    DOCTOR_DETAIL = ('18', '医生详情页')
    ORGANIZATION_DETAIL = ('19', '医院详情页')
    FREECUSTOM = ('20', '免费医美定制')
    ZHIBO = ('21', '直播')
    WIKI = ('22', '百科详情页')
    COLUMN_LIST = ('23', '专栏列表')
    COLUMN_ARTICLE = ('24', '专栏详情页')
    QUESTION = ('25', '问题')
    ANSWER = ('26', '回答')
    POLYMER = ('27', '专题聚合页')
    BDLIST = ('28', '榜单详情页')
    CALL_CENTER = ('29', '转诊呼叫中心')
    INDEX = ('30', '首页')
    CONTENT_POLYMER = ('31', '内容聚合页')
    SKU = ('32', 'SKU详情页')
    GIFT = ('33', '优惠券礼包')

    NEW_SPECIAL = ('39', '新专题')  # 仅用于自定义专题配置跳转
    # 新版秒杀
    NEW_SECKILL = ('40', '秒杀专场')
    SECKILL_POLYMER = ('41', '秒杀聚合')
    TOPIC_POLYMER = ('42', '新专题聚合')

    TOPRANK_DOCTOR = ('43', '医生榜单')
    TOPRANK_HOSPITAL = ('44', '机构榜单')
    VISUAL_PAGE = ('45', '自定义专题页面')

    DOCTOR_MESSAGE = ('50', '医生私信')
    TRACTATE = ('55', '新帖子详情')

    #内容聚合页
    POLYMER_SERVICE = ('56', '内容聚合页-大家都在买')
    POLYMER_DOCTOR = ('57', '内容聚合页-专家咨询')
    POLYMER_CHOICE = ('58', '内容聚合页-经验')


class SLIDE_SERVICE_TYPE(Enum):
    """
    业务类型
    """
    DEAL = ('0', '交易')
    COMMUNITY = ('1', '社区')
    ADV = ('2', '广告')


class FEED_SERVICE_TYPE(Enum):
    """
    首页feed流卡片业务类型
    """
    DEAL = ('0', '交易')
    COMMUNITY = ('1', '社区')
    ADV = ('2', '广告')
    SUPPLY = ('3', '补位')
    AI = ('4', 'AI')


class SERVICE_TYPE_EN(Enum):
    """
    统一
    业务类型
    """
    operating = ('0', '交易')
    community = ('1', '社区')
    advertise = ('2', '广告')

    @classmethod
    def get_name_by_value(cls, value):
        for i, (k, v) in enumerate(cls.__members__.iteritems()):
            if value == v._value_:
                return k
        return None


class SLIDE_LOCATION(Enum):
    """
        轮播图位置信息
    """
    OLD = ('0', '老轮播')
    NEW = ('1', '新轮播')
    FIRST = ('2', '大图横滑1')
    SECOND = ('3', '大图横滑2')


class DISPLAY_SITE(Enum):
    """
    轮播图展示位置，如：PC站，M站...
    """
    APP = ('0', 'app轮播')
    APPLET = ('1', '小程序轮播图')
    M_WEB = ('2', 'M站轮播图')
    PC_WEB = ('3', 'PC站轮播图')


class SERVICE_ACTIVITY_TYPE(Enum):
    FAMOUS_DOCTORS = ('0', '名医特惠')
    FREE = ('1', '免费活动')
    SPECIAL = ('2', '专题')


class ACTIVITY_STATUS(Enum):
    """
        免费活动的状态
    """
    CLOSED = (0, u'已结束')
    ON = (1, u'进行中')
    NOT_START = (2, u'未开始')
    FULL = (3, u'所有')


class SERVICE_OPERATION_TYPE(Enum):
    ALERT = (0, '报警')
    SET_BLACK = (1, '设置黑名单')
    CANCEL = (2, '取消黑名单')
    CANCEL_ALERT = (3, '取消报警')


class PROBLEM_STATUS_CHOICES(Enum):
    NEW = ('n', 'New')
    PENDING = ('p', 'Pending')  # 被举报的问题
    ANSWERED = ('s', 'Answered')
    VIEWED = ('v', 'Viewed')  # 用户看过医生的回复


class USER_TAG_CHOICES(Enum):
    FOLLOWED = ('0', '我follow的tag')
    CREATED = ('1', '我创建的tag')


class SLIDE_POSITION(Enum):
    FIRST = ('0', '首页轮播图')
    SECOND = ('1', '第二个')  # DEPRECATED
    THIRD = ('2', '第三个')  # DEPRECATED
    DIARY_LIST_BANNER = ('3', '日记本列表页banner')
    SERVICE_HOME = ('4', '美购首页banner')
    STORY = ('5', '体验故事滑动banner')
    SPECIAL = ('6', '专题滑动banner')
    SMALL = ('7', '首页小banner')
    CATEGORY = ('8', '品类聚合')
    BIGSALE_HOME = ('98', '首页大促')
    BIGSALE_OTHER = ('99', '大促聚合页')


class REPORT_ACTIONS(Enum):
    UNHANDLED = ('0', '未处理')
    DOCTOR_AD = ('1', '医生拉客')
    IMPROPER_SPEECH = ('2', '疑似广告')
    SERIOUS_AD = ('3', '严重垃圾广告')
    PERSONAL_ATTACK = ('4', '人身攻击')
    LEAVE_CONTACT = ('5', '留联系方式')
    USER_MISTAKE = ('6', '用户误点')
    DOCTOR_SOLICIT = ('7', '医生违规拉客')
    DOCTOR_LEAVE_CONTACT = ('8', '医生留联系方式')
    OTHER_DOCTOR_LEAVE = ('9', '其他医生活动下留言')
    ASK_FOR_CONTACT = ('a', '索取联系方式')
    STEAL = ('b', '盗取案例')


# 仅可用来修改order.cash_back_status状态. 新的返现单要用 NEW_CASH_BACK_STATUS
class CASH_BACK_STATUS(Enum):
    APPLY = ('0', '申请返现')
    WAIT = ('1', '返现审核中')
    SUCCESS = ('2', '已返现')


class LOGIN_AUTH_TYPE(Enum):
    backend = ('0', '后台用户')
    phone = ('1', '手机号码')
    SinaWeibo = ('2', '新浪微博')
    QZone = ('3', 'QQ')
    life_360 = ('4', '360生活助手')
    Wechat = ('5', '微信')
    COUPON = ('6', '领美劵')
    Email = ('7', '邮箱')

    # 20171015, pengfeix
    WechatPub = ('8', '微信公众号对接私信')

    # 20171226, xufukun
    WechatSmall = ('9', '微信小程序')
    # 20180525, zhangyingjie
    WechatSmall_MouthGun = ('10', "微信小程序-树洞")
    MOMO = ("11", "陌陌")
    IOS = ('12', '苹果登陆')
    CALL_CENTER = ('13', '呼叫中心')


class USER_ACCOUNT_TYPE(Enum):
    PHONE = ('1', '手机号')
    BLOG = ('2', '新浪微博')
    QQ = ('3', 'QQ')
    LIFE_360 = ('4', '360生活助手')
    WECHAT = ('5', '微信')    # 包含app, 小程序
    EMAIL = ('7', '邮箱')
    WECHAT_PUB = ('8', '微信公众号')  # 历史原因，公众号生成不同账号
    Wechat_MouthGun = ('10', '小程序-树洞')   # 已废弃
    MOMO = ('11', '陌陌')   # 已废弃
    IOS = ('12', '苹果登陆')
    CALL_CENTER = ('13', '呼叫中心')


class WECHAT_PLATFORM_TYPE(Enum):
    GM_SMALL = (1, '更美小程序')
    CLIENT_APP = (2, '客户端')


class CONVERSATION_STATUS(Enum):
    NEW = ('0', '新消息')
    OLD = ('1', '旧消息')


class TAG_TYPE(Enum):
    BODY_PART = ('1', '一级分类')
    BODY_PART_SUB_ITEM = ('2', '二级分类')
    ITEM_WIKI = ('3', '三级分类')
    CITY = ('4', '城市')
    FREE = ('5', '自由添加')
    DOCTOR = ('6', '医生')
    HOSPITAL = ('7', '医院')
    CHANNEL = ('8', '频道')
    PROVINCE = ('9', '省份')
    COUNTRY = ('10', '国家')
    YUNYING = ('11', '运营标签')
    COLLEGE = ('12', '大学')


class ORDER_SOURCE(Enum):
    UNKNOW = ('0', 'UNKNOW')
    MWEB = ('1', '移动网站')
    IOS = ('2', 'iOS客户端')
    ANDROID = ('3', 'Andorid客户端')
    WEB = ('4', '网站')
    BACKGROUND = ('5', '运营后台')
    WECHAT_APP = ('6', '微信小程序')
    MOMO = ('7', '陌陌')


class SERVICEREGISTER_STATUS(Enum):
    DRAFT = ('0', '草稿')
    WAIT_AUDIT = ('1', '待审核')
    PASS = ('2', '待编辑')
    REJECT = ('3', '被驳回')
    SPECIAL_APPROVAL = ('4', '申请特批')
    WAIT_ONLINE = ('5', '待上线')
    IS_ONLINE = ('6', '已上线')
    STAY = ('7', '创建中')


class BUSINESS_CHANNEL(Enum):
    ASSISTANT_360 = (0, '360生活助手')
    WECHAT = (1, '付款成功后微信分享')
    INTERNAL = (2, '内部使用')
    PANEL = (3, '易拉宝')
    CEO = (4, 'CEO发红包')
    Market = (5, '市场合作')
    REPAYMENT = (6, '8.5返场券')
    GAME_WISHTREE = (7, '游戏-愿望树')
    ANNUAL99 = (8, '99更美周年大礼包')
    WEIXINYAO = (9, '微信摇')
    BRANDACT = (10, '品牌组活动')
    MARKETACT = (11, '市场组活动')
    INVITE = (12, '邀请好友')
    ACCEPT_INVITE = (13, '接受邀请')
    BAIDU = (14, '百度优惠')
    NEWYEAR = (15, '2016元旦')
    MATRIX = (16, '经纬中国')
    FENZHONG = (17, '分众专享')
    DADA = (18, '嗒嗒巴士')


# 这个是针对 医生而言
class DOCTOR_REFUND_TYPE(Enum):
    PROCESSING = (0, '待处理')  # 对应 rpc 处理中
    REFUNDED = (1, '已退款')  # 对应 rpc 已退款 和 仲裁通过
    REJECT = (2, '已拒绝')  # 对应 rpc 已拒绝、等待仲裁和仲裁不通过
    REFUNDING = (3, '退款中')


class HOSPITAL_TYPE(Enum):
    PUBLIC = ('0', '公立医院')
    PRIVATE = ('1', '民营医院')


class ACTIVITY_PARTICIPATE_REASON(Enum):
    OK = ('0', '可以参加')
    CLOSED = ('1', '已结束')
    NOT_STARTED = ('2', '尚未开始')
    PARTICIPATE_LIMIT = ('3', '已经参加过')
    NOT_ENOUGH_POINTS = ('4', '没有足够美分')


class CAMPAIGN_MODULE(Enum):
    BANNER = (1, 'banner')
    SECKILL = (2, '秒杀')
    DESCRIPTION = (3, '图文混排')
    IMGMIX = (4, '内容混排')
    SUBMEETING = (5, '分会场')
    COUPON_FETCH = (6, '美券直领')
    COUPON_REDIRECT = (7, '美券跳转')
    OVERFLOW = (8, '超值美购')
    SERVICE_ZONE = (9, '美购分区')
    DESCRIPTION2 = (10, '图文混排2')
    DESCRIPTION3 = (11, '图文混排3')


class FEEDBACK_RELATED_OBJECT_TYPE(Enum):
    ORDER = ('0', '订单相关')


class FEEDBACK_MESSAGE_TYPE(Enum):
    TXT = ('0', '文字')
    IMAGE = ('1', '图片')


class ORDER_REASON_FIRST_CATEGORIES(Enum):
    R100 = (127, '退款/返现慢')
    R200 = (126, '到院多收费')
    R300 = (125, '对美购不认可')
    R400 = (124, '接待问题')
    R500 = (123, '医院环境差')
    R600 = (122, '药品问题')
    R700 = (121, '负面案例')


class ORDER_REASON_SECOND_CATEGORIES(Enum):
    R101 = (1, '退款慢')
    R102 = (2, '返现慢')
    R201 = (3, '收注册费')
    R202 = (4, '临时加价')
    R301 = (5, '价格不认可')
    R302 = (6, '活动到期')
    R303 = (7, '一直没货')
    R304 = (8, '没有这个活动')
    R401 = (9, '只能在特定时间接待用户')
    R402 = (10, '一直联系不上医生/医院')
    R403 = (11, '临时更换别的医生/护士')
    R404 = (12, '接待态度不好')
    R405 = (13, '过度开发，引起反感')
    R406 = (14, '医生爽约')
    R501 = (15, '太远、太小、破旧')
    R601 = (16, '不是正品')
    R701 = (17, '效果不好')


class RESERVATION_TYPE(Enum):
    DIAGNOSE = ('0', '面诊')
    SURGERY = ('1', '手术')
    ALL = ('2', '手术或面诊都接受')


class RESERVATION_STATUS(Enum):
    DEFAULT = ('0', '未预约')  # 此状态已废弃，不能使用！！！
    RESERVING = ('1', '预约中')
    ACCEPTED = ('2', '已确认')
    CANCELED = ('3', '已取消')
    EXPIRED = ('4', '已过期')


class TIME_TYPE(Enum):
    AM = ('1', '上午')
    PM = ('2', '下午')


class USE_COUPON_TYPE(Enum):
    NOT_USE = ('0', '没有使用美劵')
    SINGLE_SERVICE = ('1', '只用于单个美劵')
    WHOLE = ('2', '用于整个结算单')


# SAME AS PAYMENT_TYPE
class SERVICE_PAYMENT_TYPE(Enum):
    FULL_PAYMENT = ('0', '全款')
    PREPAYMENT = ('1', '预付款')
    EXCHANGE_GIFT = ('3', '礼品换购')


class SETTLEMENT_STATUS(Enum):
    NOT_PAID = ('0', '未付款')
    PAID = ('1', '已付款')
    CANCEL = ('2', '已取消')
    PAYING = ('3', '付款中')


class SETTLEMENT_CANCEL_REASON(Enum):
    UNKNOWN = (0, '无')
    TIMEOUT = (1, '超时未支付')
    WONT_BUY = (2, '不想买了')
    WRONG = (3, '买错了')
    NOT_USE_POINT = (4, '忘记使用美分')


class SETTLEMENT_BUY_AGAIN_RESULT(Enum):
    SUCCESS = (1, '成功')
    OUT_OF_STOCK = (2, '部分缺货')
    ALL_SOLD_OUT = (3, '全部卖完')


# 专题类型
class SPECIAL_TYPE(Enum):
    DOCTOR = ('0', '专家')
    TOPIC = ('1', '话题')
    SERVICE = ('2', '福利')
    USERCASE = ('3', '案列')
    RECOMMEND = ('4', '所长推荐')


# 专题样式类型
class SPECIAL_STYLE_TYPE(Enum):
    FIRST = ('0', '一排三个')
    SECOND = ('1', '一排一个')


class THEME_TYPE(Enum):
    A = ("0", "紧凑型")
    B = ("1", "非紧凑型")


class MEMBERSHIP_LEVEL(Enum):
    NORMAL = ('0', '普通用户')
    STAR = ('1', '医美达人')
    # MAKEUP=('2','美妆达人')
    # DRESS=('3','穿搭达人')
    # FASHION=('4','时尚达人')
    # BODYBUILDING=('5','健身达人')
    # ARTISTIC=('6','美学达人')


class SETTLE_STATUS(Enum):
    UNSETTLE = (0, '待打款')
    SETTLED = (1, '已打款')


class BUSINESS_TYPE(Enum):
    GROUP_MEMBER = (1, '商务组员')
    GROUP_LEADER = (2, '商务组长')
    LEADER = (3, '商务Leader')


# 可直接退款理由
class REFUND_COMMENT(Enum):
    refund_reason_doctor_notfound = ('2', '联系不上医生')
    refund_reason_doctor_notime = ('1', '联系上了医生，但他档期太满')
    refund_reason_plan_changed = ('6', '计划有变，不想做了')
    refund_reason_doctor_changed = ('3', '改找别的医生做这个项目')


class REFUND_TYPE(Enum):
    REFUND = ('0', '退款')
    CASHBACK = ('1', '返现')


class FEED_ITEM_TYPE(Enum):
    TOPIC = ('0', '帖子')
    DIARY = ('1', '日记')
    COMMENT = ('2', '回复')


class IN_FEED_REASON(Enum):
    MY_TOPIC = ('0', '我发布的帖子')

    FOLLOW_TOPIC = ('1', '我关注的人发布的帖子')
    FOLLOW_VOTE_TOPIC = ('2', '我关注的人赞的帖子')
    FOLLOW_REPLY_TOPIC = ('3', '我关注的人评论的帖子')
    FOLLOW_TAG = ('6', '关注的圈子中，点赞数超过XX的帖子')
    RECOMMEND_TOPIC = ('7', '热门推荐')
    FOLLOW_VOTE_DIARY = ('a', '我关注的人赞的日记本')
    FOLLOW_REPLY_DIARY = ('b', '我关注的人评论的日记本')
    FOLLOW_TAG_DIARY = ('c', '关注的圈子中，被置为首页推荐的日记本')
    FOLLOW_TAG_COMMENT = ('d', '关注的圈子中，被置为精选的回复')

    # my_topic_vote, my_topic_reply wont push to fans or user's feed list
    # it's used for big v mailbox, we should push these feeds in big mailbox
    # and wait for fans to pull the feeds.
    MY_TOPIC_VOTE = ('4', '我赞过的帖子')
    MY_TOPIC_REPLY = ('5', '我评论过的帖子')
    MY_DIARY_VOTE = ('8', '我赞过的日记本')
    MY_DIARY_REPLY = ('9', '我评论过的日记本')


class SOCIAL_FOLLOW_STATUS(Enum):
    STRANGER = (0, '互不关注')
    FOLLOWING = (1, '当前用户正在关注此用户')
    FOLLOWED = (2, '当前用户被此用户关注')
    FRIEND = (3, '互相关注')  # Make sure that FRIEND = FOLLOING + FOLLOED, because follow_status


@unique
class GADGET_PAGE_TYPE(int, Enum):
    INDEX = (1, '首页')
    COMMUNITY_HOME = (2, '社区首页')
    SERVICE_HOME = (3, '美购首页')
    POLYMER = (4, '内容聚合页')
    CATEGORY = (5, '品类聚合')


@unique
class GADGET_TEMPLATE_TYPE(int, Enum):
    """http://wiki.gengmei.cc/pages/viewpage.action?pageId=1048720#id-自定义展示位-首页配置-固定模版
    """
    SINGLE = (10, '单图')
    DOUBLE = (20, '双图')
    DOUBLE_NEW_SIZE = (21, '二图新尺寸')  #7770灰度使用新尺寸
    TRIPLE = (30, '三图')
    TRIPLE_NEW_SIZE = (31, '三图新尺寸')  #7770灰度使用新尺寸
    FOUR = (40, '四图')
    FOUR_NEW = (41, '四图new')
    FOUR_POLYMER = (42, '聚合四图')
    FOUR_NEW_SIZE =(43, '四图新尺寸')  #7770灰度使用新尺寸
    FIVE = (50, '五图')
    SIX = (60, '六图')
    SEVEN = (70, '七图')
    NINE_1 = (90, '九图(九宫格)')
    NINE_2 = (91, '九图2')


@unique
class SERVICE_FILTER_TYPE(int, Enum):
    """
    美购筛选类型
    """
    SPECIAL = (1, '专题')
    TIP = (2, '标签')


@unique
class TAG_ALERT_TYPE(int, Enum):
    """
    Tag 阶段性提醒的类型
    """
    PRE_OPERATION = (1, '术前提醒')
    AFTER_OPERATION = (2, '术后提醒')
    AFTER_OPERATION_DAYS = (3, '术后xx天提醒')


class SMALLIMAGE_TYPE(int, Enum):
    SMALLIMAGE = (1, '首页小图')
    SLIPSLIDE = (2, '单排横划模版')


class APP_CONFIG_TYPE(int, Enum):
    DEFAULT = (0, '无弹窗')
    FORCE_UPDATE = (1, '强制升级提示')
    UPDATE = (2, '更新提示')
    POPUP = (3, '小广告')
    CHANGE_CITY = (4, '更换城市提示')
    ALERT_RATING = (5, '求好评')
    CASH_PACKET = (6, '现金红包')
    INVITE_PACKET = (7, '邀请红包')


class LOGIN_TYPE(Enum):
    ONE = (0, '连续登陆一天')
    TWO = (1, '连续登陆两天')
    THREE = (2, '连续登陆三天')


class SERVICE_ADVERTISE_TYPE(int, Enum):
    DOCTORRECOMMEND = (1, '名医推荐')
    POPULARSERVICE = (2, '人气美购')


class MIXED_TYPE(int, Enum):
    """
        发帖，图文混排中的type
    """
    WORDS = (0, '文字')
    IMAGE = (1, '图片')
    VIDEO = (2, '视频')


class PLAN_TYPE(Enum):
    """
        免费定制医美预算范围
    """
    DEFAULT = ('0', "不限")  # 逐渐弃用
    ONETHOU = ('1', "1000以内")
    FIVETHOU = ('2', "5000以内")  # 逐渐弃用
    TENTHOU = ('3', "10000以内")  # 逐渐弃用
    UP_THOU = ('4', "1000-10000元")
    UP_TENTHOU = ('5', "10000-20000元")
    UP_TWENTYTHOU = ('6', "20000以上")


class TREATMENT_TYPE(Enum):
    """
        免费定制医美手术类型
    """
    DEFAULT = ('0', "不限")  # 逐渐弃用
    OPERATE = ('1', "手术(含微创手术)")
    INJECT = ('2', "注射(微创)")
    LIGHT = ('3', "光电(无创)")


class RECOVER_TIME_TYPE(Enum):
    """
        免费定制医美恢复周期
    """
    DEFAULT = ('0', "不限")  # 逐渐弃用
    HALFWEEK = ('1', "1-3天")
    ONEWEEK = ('2', "7天以内")  # 逐渐弃用
    THRMON = ('3', "3个月")  # 逐渐弃用
    NOW = ('4', "无恢复周期")
    UP_HALFWEEK = ('5', '3-14天')
    UP_TWOWEEK = ('6', '14天以上')


class SURGICAL_GRADE_CHOICES(Enum):
    """
    项目百科中的手术等级
    """
    ONE = ('1', u'一级手术')
    TWO = ('2', u'二级手术')
    THREE = ('3', u'三级手术')
    FOUR = ('4', u'四级手术')


class TREATMENT_MEANS_CHOICES(Enum):
    """
    """
    NULL = ('0', u'无')
    OPERATE = ('1', u"手术")
    LASER = ('2', u"激光")
    INJECT = ('3', u"注射")
    OTHER = ('4', u'其他')
    ORTHODONTIC = ('5', u"正畸")
    MUNSU = ('6', u"纹绣")
    LIGHT = ('7', u'光电（无创）')
    LIGHT_HURT = ('8', u'光电（有创）')
    MOUTH = ('9', u'口腔')
    LIGHT_LHURT = ('10', u'光电（微创）')


class WIKI_HOSPITAL_TREATMENT_CHOICES(Enum):
    """
    """
    NO = ('0', u'否')
    YES = ('1', u'是')


class WIKI_COMPLEXITY_TYPE(Enum):
    """
    项目百科中的复杂度
    """
    DEFAULT = (0, u'未知')
    ONE = (1, u'1')
    TWO = (2, u'2')
    THREE = (3, u'3')
    FOUR = (4, u'4')
    FIVE = (5, u'5')


class WIKI_RISK_FACTOR_TYPE(Enum):
    """
    项目百科中的风险系数
    """
    DEFAULT = (0, u'未知')
    ONE = (1, u'1')
    TWO = (2, u'2')
    THREE = (3, u'3')
    FOUR = (4, u'4')
    FIVE = (5, u'5')


class ZONE_TYPE(Enum):
    """
    圈子类型
    """
    ACTIVITY_ZONE = (0, "活动圈子入口")
    HOT_ZONE = (1, "热门圈子入口")


class ZONE_TYPE_V2(Enum):
    """
    圈子类型v2
    """
    NORMAL_ZONE = (0, "普通圈子")
    ACTIVITY_ZONE = (1, "活动圈子")


class VOTE_PK_TYPE(Enum):
    """
    投票类型
    """
    DOCTOR_PK = (0, '医生投票')
    USER_PK = (1, '用户投票')


class TOPIC_ORDER_IN_DIARY(Enum):
    """
    日记本详情中显示帖子的顺序
    """
    LATEST = (0, '最新在前')
    OLDEST = (1, '最老在前')


class COMMUNITY_COLUMN_TYPE(Enum):
    """
    """
    RECOMMEND = ('0', u'所长推荐')
    GOSSIP = ('1', u'扒扒扒')


class HERA_PUSH_TYPE(Enum):
    """
    HERA后台推送类型
    """
    TOPIC = (0, '话题')
    SERVICE = (1, '美购')
    SPECIAL = (2, '专题')
    DIARY = (3, '日记本')
    ZONE = (4, '圈子')
    WEBPAGE = (5, '网页')
    ACTIVITY = (6, '免费活动')
    APP_HOME = (7, '首页')
    ZONE_HOME = (8, '圈子首页')
    TAG = (9, '标签')
    ZHIBO = (10, '直播')
    COLUMN = (11, '专栏详情')
    QUESTION = (12, '问题详情')
    ANSWER = (13, '回答详情')
    TRACTATE = (14, '帖子')


class YOUNGDOCTOR_CASE_TYPE(Enum):
    """
    青年医生案例类型
    """
    FACE = (0, '面部填充')
    EYES = (1, '眼部')
    NOSE = (2, '鼻部')
    BREAST = (3, '假体隆胸')
    LASER = (4, '激光')


class YOUNGDOCTOR_APPLY_TYPE(Enum):
    """
    青年医生报名类型
    """
    DOCTOR = (1, '平台医生')
    NOT_DOCTOR = (2, '非平台医生')
    REGISTERED = (3, '注册认证中')
    OFFICER = (4, '机构管理者')


class BORROWER_RELATION_TYPE(Enum):
    """
    借款人联系人类型
    """

    IMMEDIATE = (0, '直系联系人')
    CONTACT = (1, '其他联系人')


class ID_IMAGE_TYPE(Enum):
    """
    证件照类型
    """
    FRONT = (0, '身份证正面照')
    BACK = (1, '身份证反面照')
    HANDHELD = (2, '身份证手持照')


class BORROWER_CONTACT_TYPE(Enum):
    """
    借款人联系人类型
    """
    IMMEDIATE = (0, '直系亲属')
    CONTACT = (1, '一般联系人')


class XIAOYING_SUPPLY_CODE(Enum):
    """
    小赢补件编码
    """
    POSITIVE_MISS = (1, '身份证正面照缺失')
    POSITIVE_NOT_CLEAR = (2, '身份证正面照不清晰')
    NEGATIVE_MISS = (3, '身份证反面照缺失')
    NEGATIVE_NOT_CLEAR = (4, '身份证反面照不清晰')
    C_MISS = (5, '手持身份证照片缺失')
    C_NOT_CLEAR = (6, '手持身份证照片不清晰')


class XIAOYING_CONFIRM_CODE(Enum):
    """
    确认放款或者确认退款
    """
    POSITIVE = (1, u"确认放款")
    NEGATIVE = (2, u"放弃贷款")


class XIAOYING_INSTALLMENT_STATUS(Enum):
    """
    小赢借款状态表
    """

    # 正常的(请无视翻译)
    TO_BE_SUBMIT = (0, "待提交审核")
    TO_BE_AUDIT = (10, "待风控审核")
    PAID = (13, "已放款待补录保单")
    TO_BE_RELEASE = (20, "待发布")
    TO_BE_SOLD = (22, "出借人投资完, 在平台上出售")
    RAISING = (30, "募集中")
    NORMAL_REPAY = (40, "正常还款中")
    REPAY_FINISH = (41, "还款完毕")
    REPAY_FINISH_AHEAD = (45, "提前还款完毕")
    AUDIT_SUCCESS = (50, "审核通过")
    AUDIT_REFUSE = (60, "审核拒绝")
    TO_BE_REPLENISH = (70, "待补件")
    BORROW_SUCCESS = (100, "借款成功")
    MONEY_SUCCESS = (101, '放款完成')
    WAIT_LEND = (102, '等待放款')

    # 失败的状态
    BORROW_FAIL = (34, "放款失败")
    LENDER_INVEST_FIAL = (62, "出借人投资失败")
    LENDER_MONEY_FAIL = (64, "出借人打款失败")
    LENDER_INSURE_FAIL = (66, "出借人承保失败")
    LENDER_INSURED_FAIL = (68, "出借人投保失败")
    INSURE_FAIL = (71, "投保失败")
    INSURED_FIAL = (73, "承保失败")
    RIGHT_TRANS_FAIL = (75, "保险债权转移失败")
    REFUND = (233, "主动放弃贷款")

    # 撤销
    AUDIT_FAIL = (11, "审核失败")
    UNDO_BORROW = (12, "撤销借款")


class XIAOYING_GENDER(Enum):
    """
    小赢性别
    """
    # UNKNOWN = (0, '未知')
    MAN = (1, '男')
    WOMAN = (2, '女')


class XIAOYING_MARRY_STATUS(Enum):
    """
    小赢婚姻状况
    """
    UNMARRIED = (1, '未婚')
    MARRIED = (2, '已婚')
    DIVORCED = (3, '离异')


class XIAOYING_EDUCATION(Enum):
    """
    小赢学历
    """
    OTHER = (0, '其他')
    # MIDDLE_SCHOOL = (1, '初中')
    # HIGH_SCHOOL = (2, '高中')
    JUNIOR_COLLEAGE = (3, '大专')
    BECHELOR = (4, '本科')
    MASTER = (5, '硕士')
    DOCTOR = (6, '博士')


class XIAOYING_RELATION_TYPE(Enum):
    """
    更美关系类型
    """
    OTHER = (0, '其他')
    PARENT = (1, '父母')
    SPOUSE = (2, '配偶')
    CHILDREN = (3, '子女')
    FRIEND = (4, '朋友')
    COLLEAGUES = (5, '同事')


class HERA_OPERATE_LOG_PACKAGE(Enum):
    """
    hera后台操作日志的package
    """
    UNIVERSE = (0, u'运营后台')
    DIARY = (1, u'日记本')
    COMMUNITY_ZONE = (2, u'社区圈子')
    USER = (3, u'用户')
    DOCTOR = (4, u'医生')
    SERVICE = (5, u'美购')
    ORDER_MANAGEMENT = (6, u'订单管理')
    SERVICE_CHANNEL = (7, u'美购频道')
    CAMPAIGN_MANAGEMENT = (8, u'活动管理')
    PUSH_MANAGEMENT = (9, u'推送管理')
    HOME_CONFIGURATION = (10, u'首页管理')
    BASE_CONFIGURATION = (11, u'基础配置')
    DOCTOR_OPERATE = (12, u'医生运营')
    PC_HOME_ADVERTISING = (13, u'PC首页广告')
    OPERATE_BUSINESS_GROUP = (14, u'运营商务小组')
    USER_RIGHTS = (15, u'用户权限')
    FIX_DOCTOR_BUSINESS = (16, u'医生商务关系修改器')
    DOCTOR_AGREEMENT = (17, u'医生强制签协议')
    ANDROID_CHANNEL_BUILD = (18, u'Android渠道打包')
    APPLICATION_CONSULTING = (19, u'咨询及应用')
    ASCLE_LOGIN = (20, u'自营医生运营列表')
    ADVERTISE_MANAGEMENT = (21, u'广告位管理')
    SIDESKIDCATEGORY = (22, u'首页横滑分类')
    SINGLERECORD = (23, u'飞单管理')
    MAIDANMANAGMENT = (24, u'买单管理')
    FENXIAO = (25, u'分销')
    INSTALLMENT = (26, u'分期')
    INSURANCE = (27, u'保险')
    TEAM = (28, u'组织架构')
    CHANNEL_VENDOR = (29, u'APP渠道商')
    ANSWER = (30, u'问答')
    ARTEMIS_ADVERTISE = (31, u'广告系统')
    SERVICE_COMMENT = (32, u'美购评价')
    ANSWERTOP = (33, u'问答置顶')
    SMARTRANK = (34, u'smart_rank')
    CUSTOM_PRODUCT = (35, u'自定义广告商品管理')
    TRACTATE = (36, u'新帖子')
    BUSINESS_KPI_DATA = (37, u'商务KPI数据')
    TAG_V3 = (38, u'新标签')
    SYNONYM = (39, u'同义词')
    MARK = (40, u'打卡')
    USER_CANCELLATION = (41, u'用户注销')

class HERA_OPERATE_LOG_ACTION(Enum):
    """
    hera后台操作日志的action
    """
    CREATE = (1, u'创建')
    MODIFY = (2, u'修改')
    DELETE = (3, u'删除')
    ONLINE = (4, u'上线')
    DOWNONLINE = (5, u'下线')
    SAVE = (6, u'保存')
    RECALL = (7, u'撤回')
    SET_USER_EFFECT = (8, u'设置账号生效')
    MODIFY_PASSWORD = (9, u'修改密码')
    SET_ONLINEORDOWN = (10, u'设置上下线')
    EXAMINATION_PASSED = (11, u'申请通过')
    TURN_DOWN = (12, u'驳回')
    CASHBACK = (13, u'返现')
    REFUND = (14, u'退款')
    EXPORT_EXCEL = (15, u'导出邮箱')
    SET_SETTLED = (16, u'统计结算额')
    STAT_ALL_TRADE = (17, u'统计交易额')
    DIARY_ADUIT = (18, u'日记本审核')
    PACKAGE = (19, u'包装')
    APPROVE = (20, u'特批')
    APPROVE_TURN_DOWN = (21, u'特批驳回')
    SERVICE_CHECK = (22, u'美购审核')
    MAIDAN_SETTING = (23, u'买单设置')
    DOCTOR_CHECK = (24, u'医生审核')
    ADD_DOCTOR = (25, u"添加可见医生")
    BID_OPERATE = (26, u'标单操作')
    ORDER_OPERATE = (27, u'订单操作')
    TRACTATE_AUDIT = (28, u'新帖子审核')
    DATA_INSERT = (29, u'数据导入')
    TAG_V3 = (30, u'新标签操作')
    USER_CANCELLATION = (31, u'用户注销')


class AGREEMENT_TYPE(Enum):
    """
    强制签协议,协议状态
    """

    DEFAULT = (0, u'已保存')
    IS_ONLINE = (1, u'已上线')
    IS_RECALL = (2, u'已撤回')


class FREECUSTOM_STATUS_TYPE(Enum):
    """
    免费定制跟进状态
    """
    DEFAULT = (0, u'未跟进')
    FOLLOW = (1, u'跟进中')
    DOWN = (2, u'已完成')


class ADVERTISE_SHOW_POSITION(Enum):
    """
    广告位展示位置
    """
    SERVICE_HOMEPAGE = (0, u'美购首页推荐')
    SERVICE_LIST = (1, u'美购列表页')


class LOGIN_KIND(Enum):
    """
    登入类型
    """
    PHONE = (0, u'手机')
    EMAIL = (1, u'邮箱')
    THREE_PARTY = (2, u'三方登入')


class DIARY_AUDIT_STATUS(Enum):
    """
    日记本审核状态
    """
    UNAUDITED = ('0', u'未审核')
    REAUDIT = ('1', u'再审核')
    AUDITED = ('2', u'已审核')


class DIARY_CONTENT_LEVEL(Enum):
    """
    日记本内容分级
    """
    UNAUDITED = ('0', u'未审核')
    ILLEGAL = ('1', u'不合规')
    BAD = ('2', u'差')
    GENERAL = ('3', u'一般')
    FINE = ('4', u'良好')
    EXCELLENT = ('5', u'优秀')
    BETTER = ('3.5', u'较好')
    OUTSTANDING = ('6', u'特别优秀')


class DIARY_OPERATE(Enum):
    """
    日记本操作
    """
    UPDATE_INFO = ('0', u'更新该日记本术前资料')
    UPDATE_TOPIC = ('1', u'修改帖子')
    DELETE_TOPIC = ('2', u'删除/下线帖子')
    ADD_TOPIC = ('3', u'新增帖子')


class SERVICE_REVIEW_STATUS(Enum):
    """
    美购审核状态
    """
    UNDER_REVIEW = ('0', u'审核中')
    TURN_DOWN = ('1', u'驳回')
    SPECIAL_APPROVAL_TURN_DOWN = ('2', u'特批驳回')
    PASS = ('3', u'审核通过')
    UNDER_OFFLINE = ('4', u'下线审核中')
    SPECIAL_UNDER_REVIEW = ('5', u'特批审核中')
    DRAFT = ('6', u'新建的草稿')


class SERVICE_REVIEW_TYPE(Enum):
    """
    美购审核类型
    """
    ORDINARY = ('0', u'普通审核')
    SPECIAL = ('1', u'特批')
    OFFLINE = ('2', u'下线申请')


class DRAFT_TYPE(Enum):
    """
    草稿类型
    """
    DIARY = (0, u'日记帖')
    DISCUSS = (1, u'讨论帖')


class DOCTOR_IDENTITY(Enum):
    """
        访问 gaia/doctor/view中一些方法的身份
    """
    DOCTOR = ('doctor', u'普通医生')
    STAFF = ('staff', u'运营')
    OFFICER = ('officer', u'机构运营者')


class OPTIMIZE_WIKI_TYPE(Enum):
    """
    优化wiki模块类型
    """
    ABSTRACT = ('1', u'简介')
    FILES = ('2', u'小档案')
    THEORY = ('3', u'项目／手术原理')
    EXAMPLES = ('4', u'效果示例')
    ADVANTAGE = ('5', u'优点')
    FAULT = ('6', u'缺点及风险')
    PRE_KNOW = ('7', u'术前锦囊')
    AFTER_KNOW = ('8', u'术后锦囊')
    OTHER = ('9', u'自定义模块')


class ACHE_LEVEL(Enum):
    """
    疼痛感等级
    """
    ZERO = ('0', u'0颗星')
    ONE = ('1', u'1颗星')
    TWO = ('2', u'2颗星')
    THREE = ('3', u'3颗星')
    FOUR = ('4', u'4颗星')
    FIVE = ('5', u'5颗星')


class ACHE_LEVEL_NEW(Enum):
    """
    疼痛感等级: update 750
    """
    ZERO = ('0', u'疼痛0星')
    ONE = ('1', u'疼痛1星')
    TWO = ('2', u'疼痛2星')
    THREE = ('3', u'疼痛3星')
    FOUR = ('4', u'疼痛4星')
    FIVE = ('5', u'疼痛5星')


class ANESTHESIA_TYPE(Enum):
    """
    麻醉方法
    """
    NONE = ('0', u'无')
    PART = ('1', u'局麻')
    ALL = ('2', u'全麻')
    SURFACE = ('3', u'表面麻醉')
    PART_ALL = ('4', u'局麻／全麻')


class WIKI_LEVEL(Enum):
    """
    wiki所在层级
    """

    ONE = ('1', u'一级百科')
    TWO = ('2', u'二级百科')
    THREE = ('3', u'三级百科')


class NOTIFY_EVENT(Enum):
    """
        通知事件类型，目前仅用于 未读消息
    """
    ORDER = ('order', u'订单相关')
    REFUND = ('refund', u'退款相关')
    RESERVE = ('reserve', u'预约相关')
    CONVERSATION = ('conversation', u'私信相关')
    SYSTEM = ('system', u'系统消息')
    DEAL = ('deal', u'订单及退款单浮窗消息')


class NOTIFY_OPERATION(Enum):
    ADD = ('add', u'新增')
    DELETE = ('delete', u'取消或者删除')
    CLEAR = ('clear', u'清除计数')


class STAGGERED_ENUM(Enum):
    TOPIC = (1, u'日记的瀑布流类型')
    DIARY = (2, u'日记本的瀑布流类型')
    CUSTOM = (3, u'运营位的瀑布流类型')


class MAIDAN_REVIEW_STATUS(Enum):
    """
    医生买单审核状态
    """
    UNDER_REVIEW = ('0', u'审核中')
    TURN_DOWN = ('1', u'审核拒绝')
    PASS = ('2', u'审核通过')


class MAIDAN_STATEMENT_STATUS(Enum):
    """
    医生买单对帐单状态
    """
    CREATED = (0, u'已生成')
    SETTLED = (1, u'已打款')
    VOID = (9, u'空对帐单')


class TICKETS_STATUS(Enum):
    DEFAULT = ('0', u'未处理')
    UNEXPIRED = ('1', u'未逾期')
    EXPIRED = ('2', u'已逾期')


class DIARY_OPERATION(Enum):
    CREATE_TOPIC = ('1', u'发布人新增日记帖')
    MODIFY_DIARY = ('2', u'发布人修改日记本（包括术前资料和帖子）')
    SELF_REPLY = ('3', u'发布人评论（包括日记本和日记帖）')
    OTHER_REPLY = ('4', u'其他用户评论（包括日记本和日记帖）')
    OTHER_VOTE = ('5', u'其他用户点赞（包括日记本和日记帖）')


class SPECIAL_MODULE(Enum):
    SPECIAL_DETAIL = (0, '专题详情')
    FLOOR = (1, '楼层设置')
    ICON = (2, '按钮设置')
    RECOMMEND_DOCTOR = (3, '医生设置')
    RECOMMEND_DIARY = (4, '案例设置')
    RECOMMEND_RANK = (5, '排序设置')
    COUPONS = (6, '美券直领')
    GADGET_TEMPLATE = (8, '固定模版')
    COUPON_PARTTION = (9, '美购分区')
    BUTTON = (10, '按钮区')
    TURNTABLE = (11, '转盘活动')
    VIDEO = (12, '视频设置')
    SUSPENSION_WINDOW = (13, '小程序悬浮窗')
    TOOL_BAR = (14, 'ToolBar配置')

class SECKILL_MODULE(Enum):
    COUPONS = (6, '美券直领')


class NOTIFICACTION_TYPE(Enum):
    MY = ('0', u'关于我')
    CHOSEN = ('1', u'精选')
    COMMUNITY = ('2', u'社区')


class PHONE400_VENDOR(Enum):
    BAIWU = ('baiwu', u'百悟')
    XTWY = ('xtwy', u'信通网赢')
    ZTTH = ('ztth', u'中通天鸿')


class PRICE_TYPE(Enum):
    SERVICE = ('0', u'更美价')
    DISCOUNT = ('1', u'抽成价')


class NOTIFICACTION_SHOW_TYPE(Enum):
    MY = ('0', u'通知的展示样式')
    TEXT = ('1', u'纯文字的样式')
    PIC = ('2', u'图文的样式')


class YINUO_TYPE(Enum):
    NONE = ('0', u'不选择保险')
    CASUALTY = ('1', u'25元意外险')


class ZHONGAN_TYPE(Enum):
    MICRO_SHAPING = ('51261011', u'微整')
    EYES_ONE = ('51261012', u'眼部计划一')
    EYES_TWO = ('51261013', u'眼部计划二')
    EYES_THERE = ('51261014', u'眼部计划三')
    NOSES_ONE = ('512610145', u'鼻部计划一')
    NOSES_TWO = ('51261018', u'鼻部计划二')
    NOSES_THERE = ('51261019', u'鼻部计划三')


class ZONE_DETAIL_SORT_TYPE(Enum):
    HOT = (0, u'按热度排序')
    TIME = (1, u'按时间排序')



class ZONE_DETAIL_TAB_TYPE(Enum):
    DIARY = (0, u'日记本')
    DISCUSS = (1, u'讨论')
    SERVICE = (2, u'美购')
    QUESTIONS = (3, u'问答')


class ACTIVITY_TYPE_ENUM(Enum):
    """
    活动类型
    """
    SPECIAL = (1, u'专场')
    SECKILL = (2, u'秒杀')
    GROUPBUY = (3, u'拼团')
    MOREBUY = (4, u'多买')


class SERVICE_ITEM_PRICE_TYPE(Enum):
    """
    SKU价格类型
    """
    DEFAULT = (0, u'默认价')
    SPECIAL = (1, u'专场')
    SECKILL = (2, u'秒杀')
    GROUPBUY = (3, u'拼团')
    MOREBUY = (4, u'多买')


class PHONE_AREA_CODE(Enum):
    CHINA = ('+86', '中国大陆')
    HONGKONG = ('+852', u'香港')
    TAIWAN = ('+886', u'台湾')
    KOREA = ('+82', u'韩国')
    JAPAN = ('+81', u'日本')
    THAILAND = ('+66', u'泰国')


class DOCTOR_SECKILL_APPLY_STATUS(Enum):
    DEFAULT = ('0', '未处理')
    REJECT = ('1', u'驳回')
    RE_APPLY = ('2', u'重新提报')
    PASS = ('3', u'报名成功')


class FENXIAO_PAY_RULE(Enum):
    GENGMEI_PRICE = ('0', u'更美价')
    GENGMEI_PRICE_MINUS_DEDUCTION = ('1', u'更美价-美分美券')


class VIDEO_CODE_STATUS(Enum):
    SUCCESS = (0, u'成功')
    WAITING = (-1, u'等待')
    NOSTART = (-2, u'未开始')
    FAIL = (-3, u"失败")
    OPERATING_LOCAL = (-4, u"处理中")


class INSTALLMENT_TYPE(Enum):
    NO_LOGION = (-1, u'未登录')
    RENMAI = (0, u'任买')
    YIRENDAI = (1, u'宜人贷')


class DIARY_TYPE_IN_INDEX(Enum):
    BASE_SORT = ('0', u'基础排序获取的日记本')
    RESYS = ('1', u'推荐引擎获取的日记本')


class WORLD_AREA_TYPE(Enum):
    NATIONWIDE = ('nationwide', u'全国')
    WORLDWIDE = ('worldwide', u'全世界')


class LIVE_MSG_TYPE(Enum):
    NOTIFI_MSG = ('0', u'系统通知')
    ENTER_MSG = ('1', u'进入通知')
    TEXT_MSG = ('2', u'普通消息')
    LIKE_MSG = ('3', u'点赞消息')


class LIVE_QINIU_STATUS_TYPE(Enum):
    CONNECTED = ('connected', u'connected')
    DISCONNECTED = ('disconnected', u'disconnected')


class ADVER_MANAGEMENT_TYPE(Enum):
    SERVICE = ('0', u'广告位管理－美购')
    DOCTOR = ('1', u'广告位管理－专家')


class ADVER_MANAGEMENT_POSITION_TYPE(Enum):
    SERVICE_HOME_RECOMMEND = ('0', u'美购首页推荐')
    SERVICE_LIST = ('1', u'美购列表页')
    SERVICE__HOME_BANNER = ('2', u'美购品类模块')
    SREACH_RESULT = ('3', u'搜索结果页')
    DOCTOR_LIST = ('4', u'医生/机构管理者列表页')


class TOPIC_LIVE_TYPE(Enum):
    NORMAL = ('0', u'普通帖子')
    REPLAY = ('1', u'回放帖子')


class LIVE_STATUS(Enum):
    NOLIVE = (0, u'无直播')
    LIVE = (1, u'直播中')
    NOTICE = (2, u'预告中')


class TAB_ICON_SIZE(Enum):
    ICON_SIZE_2X = (2, u'2X的ICON')
    ICON_SIZE_3X = (3, u'3X的ICON')


class ZTTH_400_PHONE_STATUS(Enum):
    SUCCESS_CODE = (200, u'成功码')
    SUCCESS_CODE_v1 = (500, u'成功码1')
    GENGMEI_ACCEPT_CODE = ('2', u'接通状态')
    GENGMEI_FAIL_CODE = ('1', u'未接听状态')


class UNION_400_PHONE_STATUS(Enum):
    VENDER_ACCEPT_CODE = ('1', u'接通状态')
    GENGMEI_ACCEPT_CODE = ('2', u'未接听状态')


class WRONG_DEVICE_ID(Enum):
    ANDROID_WRONG_DEVICE_ID = ('000000000000000', u'安卓默认device_id')
    IOS_WRONG_DEVICE_ID = ('00000000-0000-0000-0000-000000000000', u'IOS默认的device_id')


class FILTER_WORD_TYPE(Enum):
    USER_NAME = ('usename', u'过滤用户名')
    TOPIC_CONTENT = ('topic_content', u'过滤内容')
    TOPIC_REPLY = ('topic_reply', u'过滤回复内容')
    TOPIC_CHAT = ('topic_chat', u'过滤私信内容')


class ZTTH_400_PHONE_ERROR_CODE_STATUS(Enum):
    ERROR_CODE_V1 = (1, 'IVR挂机')
    ERROR_CODE_V2 = (2, '留言')
    ERROR_CODE_V3 = (3, '未接通')
    ERROR_CODE_V4 = (4, '未接通留言')
    ERROR_CODE_V5 = (5, '排队溢出')
    ERROR_CODE_V6 = (9, '非白名单号码')
    ERROR_CODE_V7 = (101, 'ivr超限')
    ERROR_CODE_V8 = (102, '企业未启用')
    ERROR_CODE_V9 = (103, '企业已过期')
    ERROR_CODE_V10 = (104, '余额不足')
    ERROR_CODE_V11 = (105, '不在接通时间内')
    ERROR_CODE_V12 = (106, '未设置日程')
    ERROR_CODE_V13 = (107, '企业不存在')
    ERROR_CODE_V14 = (108, '黑名单')
    ERROR_CODE_V15 = (109, '非白名单号码')


class CHANNEL_TYPE(Enum):
    STORE = (1, u'应用商店')
    TOUFANG = (2, u'投放')


class LIVE_LIST_TYPE(Enum):
    INDEX = (1, '首页')
    INDEX_VIDEO = (2, '首页tab')
    VIDEO_LIST = (3, 'video list')


class TOPIC_IMAGE_TYPE(Enum):
    PRE_OPERATION_IMAGE = ('0', '术前图')
    POST_OPERATION_IMAGE = ('1', '术后图')


class TEAM_TYPE(Enum):
    BUSINESS = ('0', '商务')
    OPERATION = ('1', '运营')


# SEO词类型
class CATEGORY_TYPE(Enum):
    BODY_PART = ('1', '一级分类')
    BODY_PART_SUB_ITEM = ('2', '二级分类')
    ITEM_WIKI = ('3', '三级分类')
    CITY = ('4', '城市')
    FREE = ('5', '自由添加')
    DOCTOR = ('6', '医生')
    HOSPITAL = ('7', '医院')
    CHANNEL = ('8', '频道')
    PROVINCE = ('9', '省份')
    COUNTRY = ('10', '国家')


class ACCOUNT_TYPE(Enum):
    BANK = (0, '银行')
    ALIPAY = (1, '支付宝')


class QUESTION_TYPE(Enum):
    QUESTION = (0, '问题')
    ANSWER = (1, '答案')


class POLYMER_PUB_TYPE(Enum):
    DEFAULT = (0, '日记、帖子、问答')
    TRACTATE = (1, '帖子')


class POLYMER_SOURCE_FROM(Enum):
    AI = ('ai', '扫脸聚合页')
    SKIN = ('skin', '测肤聚合页')


class QUESTION_ORDER_TYPE(Enum):
    DEFAULT = (0, '智能排序')
    DROPDOWN_REFRESH = (1, '下拉刷新排序')
    HOT = (2, '热度排序')
    UPDATE = (3, '时间排序')
    DOCTOR_COVER = (4, u'有图在前')
    DOCTOR_RECOMMEND = (5, u'精华在前')
    DOCTOR_LASTEST = (6, u'最新发布')
    ANSWER_NUM = (7, u'问题的回答数')
    MOUTHGUN_RECOMMEND = (8, u"吐槽小程序，相关推荐问题排序")
    DISCOVERY_UPDATE = (9, u"发现页改版数据获取规则")
    LASTEST_ANSWER = (10, u"问题最新回答在前")
    PC_LASTEST_ANSWER = (11, u'pc站最新回答获取规则')


class TRACTATE_ORDER_TYPE(Enum):
    DEFAULT = (0, '默认排序')


class LIST_TRACTATE_FROM(Enum):
    DEFAULT = ('0', '默认')
    MY_PUBLISH = ('1', '我发布的帖子入口')
    MY_REPLY = ('2', '我回复的帖子入口')
    MY_FAVOR = ('3', '我收藏的帖子入口')
    MY_FOLLOW = ('4', '我关注的帖子入口')
    NOTICE_VOTE = ('5', 'push消息入口 - 赞')
    NOTICE_REPLY = ('6', 'push消息入口 - 回复')
    NOTICE_FAVOR = ('7', 'push消息入口 - 收藏')
    DOCTOR_DETAIL = ('8', '医生主页 - 医生说')
    HOSPITAL_DETAIL = ('9', '机构主页 - 医院说')
    USER_DETAIL = ('10', '用户主页 - 帖子列表')


class TOP_QUESTION_ORDER_TYPE(Enum):
    DEFAULT = (0, "默认排序")


class COUPON_INVALID(Enum):
    NEW_USER = (1, u'新用户')
    DOCTOR = (2, u'医生')
    DOCTOR_NEW = (3, u'医生新用户')
    SECKILL = (4, u'秒杀')
    SPECIAL = (5, u'专场')
    THRESHOLD = (6, u'券额')
    REPAY = (7, u'预付款')
    DISCOUNT = (8, u'抽成')
    SKU = (9, u'sku')
    TIME = (10, u'时间')
    STATUS = (11, u'状态')
    HOSPITAL_PAYMENT = (12, u'尾款')
    GROUPBUY = (13, u'拼团')
    PRICE_RANGE = (14, u'价格范围')
    PRECE_NOT_IN_SPECIAL = (15, u'价格专场')
    PROMOTION = (16, u'活动')


class COUPON_TYPES(Enum):
    PLATFORM = (1, '平台美券')
    DOCTOR = (2, '医生美券')


class COUPON_THRESHOLD_VALIDATION_TYPE(Enum):
    GENGMEI_PRICE = (0, '按照更美价计算门槛金额')
    BY_DEDUCTION_TYPE = (1, '按照抵扣类型计算门槛金额')


class COUPON_STATUS(Enum):
    UNCLAIMED = (0, '未领取')
    CLAIMED = (1, '已领取')
    FROZEN = (2, '被冻结')
    CONSUMED = (9, '已消费')


class COUPON_DISTRIBUTION_STATUS(Enum):
    DRAFT = (1, '待编辑')
    OPEN = (2, '可领取')
    CLOSED = (3, '下线')


class COUPON_GIFT_TYPES(Enum):
    PLATFORM = (1, '平台美券礼包')
    DOCTOR = (2, '医生美券礼包')


class USER_HOME_TYPE(Enum):
    OLD_HOME_PAGE = (0, u'老版本首页')
    NEW_HOME_PAGE = (1, u'新版本首页')


class FACE_ANALYZE_STATUS(Enum):
    SUCCEED = ('0', u'人脸识别成功')
    MULTI_FACE_DETECTED = ('1', u'照片中有多张人脸')
    PITCH_ANGLE_TOO_LARGE = ('2', u'抬头角度过高')
    ROLL_ANGLE_TOO_LARGE = ('3', u'头部旋转(平面旋转)过多')
    YAW_ANGLE_TOO_LARGE = ('4', u'摇头角度过大')
    POOR_PHOTO_QUALITY = ('5', u'照片像素过低')
    FACEPP_TIMEOUT = ('6', u"请求超时,请稍后再试")
    FACEPP_BAD_RESPONSE = ('7', u'照片识别失败，请稍后再试')
    NO_FACE_DETECTED = ('8', u'照片中未发现人脸')
    UNKNOWN_EXCEPTION = ('9', u'照片识别失败，请稍后再试')


class FaceDetectType(Enum):
    OFFICIAL = (1, u"正式版")
    GAME = (2, u'游戏版')


@unique
class FACIAL_FEATUREA(Enum):
    CONTOUR                             = (1, u"脸型")
    CHIN                                = (2, u"下巴")
    EYEBROW                             = (3, u"眉毛")
    EYE                                 = (4, u"眼睛")
    NOSE                                = (5, u"鼻")
    LIP                                 = (6, u"唇")
    TONGJU_BIYI_BIZHI                   = (7, u'瞳距鼻翼宽比')
    SHUANG_C_XIAN_JIAODU                = (8, u'双C线角度')
    RENZHONG_ZUICHUN_KEDI_BIZHI         = (9, u'人中嘴唇颏底比')
    ZHONGXIATING                        = (10, u'中下庭')
    SANYAN_BILI                         = (11, u'三眼比例')
    NIEBU_QUANKUAN_XIAHE_XIABA_BIZHI    = (12, u'颞部颧宽下颌下巴比')
    NIEBU_QUANKUAN_BIZHI                = (13, u'颞部颧宽比')
    SHUANGYANPI_TYPE                    = (14, u'双眼皮类型')
    YANDAI_TYPE                         = (15, u'眼袋类型')
    FALINGWEN_TYPE                      = (16, u'法令纹类型')
    YANDAI_TYPE_COMPLEX                 = (17, u'眼袋类型复')


class CONTOUR_TYPE(Enum):

    YUAN = ('yuanlian', u"娃娃脸")
    TUOYUAN = ('tuoyuanlian', u"鹅蛋脸")
    CHANG = ('changlian', u"长型脸")
    LINGXING = ('lingxinglian', u"钻石脸")
    FANG = ('fanglian', u"方脸")
    DANSANJIAO = ('daosanjiaolian', u"瓜子脸")
    BAIFUMEI = ('baifumeilian', u"白富美脸")
    LIXING = ('lixinglian', u"梨形脸")
    XIAOZHONG = ('xiaozhonglian', u"小众脸")
    UNKNOW = ('unknown', u"未知")


class EYEBROW_TYPE(Enum):

    YIZI = ('yizimei', u"一字眉")
    LIUYE = ('liuyemei', u"柳叶眉")
    YESHENG = ('yeshengmei', u"野生眉")
    CUMEI = ('cumei', u"粗眉")
    TIAOMEI = ('tiaomei', u"挑眉")
    SHANGTIAOMEI = ('shangtiaomei', u"挑眉")
    BIAOZHUNMEI = ('biaozhunmei', u"野生眉")
    XIMEI = ('ximei', u"柳叶眉")
    PINGMEI = ('pingmei', u"一字眉")
    UNKNOW = ('unknown', u"未知")


class EYE_TYPE(Enum):

    XING = ('xingyan', u"杏眼")
    XICHANG = ('xichangyan', u"细凤眼")
    XIACHUI = ('xiachuiyan', u"小鹿眼")
    FENGYAN = ('fengyan', u"桃花眼")
    SANJIAO = ('sanjiaoyan', u"小狗眼")
    XINREN = ('xingrenyan', u"杏眼")
    UNKNOW = ('unknown', u"未知")


class CHIN_TYPE(Enum):

    JIAN = ('jianxiaba', u"尖下巴")
    FANG = ('fangxiaba', u"方下巴")
    YUAN = ('yuanxiaba', u"圆下巴")
    KUAN = ('kuanxiaba', u"方下巴")
    W = ('Wxiaba', u"W下巴")
    UNKNOW = ('unknown', u"未知")


class NOSE_TYPE(Enum):

    ZHAIYIBI = ('zhaibiyi', u"窄鼻翼")
    KUANBIYI = ('kuanbiyi', u"宽鼻翼")
    BIAOZHUNBIYI = ('biaozhunbiyi', u"标准鼻翼")
    UNKNOW = ('unknown', u"未知")


class LIP_TYPE(Enum):

    M = ('Mchun', u"微笑唇")
    BAO = ('baochun', u"薄唇")
    HOU = ('houchun', u"厚唇")
    SHANGQIAO = ('shangqiaochun', u"微笑唇")
    XIACHUI = ('xiachuichun', u"态度唇")
    BIAOZHUNCHUN = ('biaozhunchun', u"薄唇")
    YINGTAOCHUN = ('yingtaochun', u"厚唇")
    UNKNOW = ('unknown', u"未知")


@unique
class SHUANGYANPI_TYPE(Enum):
    """ 双眼皮类型 """
    DANYANPI = ('danyanpi', u"单眼皮")
    SHUANGYANPI = ('shuangyanpi', u"双眼皮")
    NEISHUANG = ('neishuang', u'内双')


@unique
class YANDAI_TYPE(Enum):
    """眼袋类型"""
    YOUYANDAI = ('youyandai', u'有眼袋')
    WUYANDAI = ('wuyandai', u'无眼袋')


@unique
class YANDAI_TYPE_COMPLEX(Enum):
    """眼袋类型 复"""
    ZHONGDUYANDAI = ('zhongduyandai', u'重度眼袋')
    QINGDUYANDAI = ('qingduyandai', u'轻度眼袋')
    WUYANDAI = ('wuyandai', u'无眼袋')


@unique
class FALINGWEN_TYPE(Enum):
    """眼袋类型"""
    QINGDUFALINGWEN = ('qingdufalingwen', u'轻度法令纹')
    ZHONGDUFALINGWEN = ('zhongdufalingwen', u'重度法令纹')
    WUFALINGWEN = ('wufalingwen', u'无法令纹')


@unique
class TONGJU_BIYI_BIZHI(Enum):
    WIDE = ('biyiguokuan', u"鼻翼过宽")
    SLIGHTLY_WIDE = ('biyiluekuan', u"鼻翼略宽")
    MID = ('biyishizhong', u"鼻翼适中")
    NARROW = ('biyiguozhai', u"鼻翼过窄")
    SLIGHTLY_NARROW = ('biyiluezhai', u"鼻翼略窄")


@unique
class SHUANG_C_XIAN_JIAODU(Enum):
    WIDE = ('jiaoduda', u"角度大")
    MID = ('jiaoduzhong', u"角度中")
    NARROW = ('jiaoduxiao', u"角度小")


@unique
class RENZHONG_ZUICHUN_KEDI_BIZHI(Enum):
    UPPER = ('zuichunpianshang', u"嘴唇位置偏上")
    MID = ('zuichunshizhong', u"嘴唇位置适中")
    LOWER = ('zuichunpianxia', u"嘴唇位置偏下")


@unique
class ZHONGXIATING(Enum):
    VERY_LOW = ('shifendi', u"颏部占比十分低-急需垫下巴")
    RELATIVELY_LOW = ('bijiaodi', u"颏部占比较低-需要垫下巴")
    SLIGHTLY_HIGH = ('luegao', u"颏部占比略高-可垫可不垫")
    SLIGHTLY_LOW = ('luedi', u"颏部占比略微低-可垫可不垫")
    MID = ('shizhong', u"颏部占比适中-不用垫下巴")


@unique
class SANYAN_BILI(Enum):
    MID = ('shizhong', u"眼距适中")
    SLIGHTLY_WIDE = ('luekuan', u"眼距略宽")
    SLIGHTLY_NARROW = ('luezhai', u"眼距略窄")
    TOO_NARROW = ('guozhai', u"眼距过窄")
    TOO_WIDE = ('guokuan', u"眼距过宽")


@unique
class NIEBU_QUANKUAN_XIAHE_XIABA_BIZHI(Enum):
    MID = ('shizhong', u'适中')
    QUANGU_AOXIAN = ('quanguaoxian', u'颧骨凹陷')
    QUANGU_TUCHU = ('quangutuchu', u'颧骨突出')
    SMOOTH = ('liuchang', u'流畅')
    XIAHE_AOXIAN = ('xiaheaoxian', u'下颌凹陷')
    XIAHE_TUCHU = ('xiahetuchu', u'下颌突出')


@unique
class NIEBU_QUANKUAN_BIZHI(Enum):
    VERY_AOXIAN = ('shifenaoxian', u'十分凹陷')
    GENERALLY_FULL = ('yibanbaoman', u'一般饱满')
    VERY_TUCHU = ('shifentuchu', u'十分突出')
    FULL = ('baoman', u'饱满')


class SERVICE_ALBUM_TYPE(Enum):
    OFFICIAL = ('0', u'官方')
    USER = ('1', u'用户')


class SERVICE_COMMENT_OPTION(Enum):
    ATTITUDE1 = ('a1', u'服务态度差')
    ATTITUDE2 = ('a2', u'服务态度待改进')
    ATTITUDE3 = ('a3', u'服务态度一般')
    ATTITUDE4 = ('a4', u'服务态度良好')
    ATTITUDE5 = ('a5', u'医生很贴心')
    PROFESSIONAL1 = ('p1', u'咨询问题未能解答')
    PROFESSIONAL2 = ('p2', u'专业技能待改进')
    PROFESSIONAL3 = ('p3', u'专业技能一般')
    PROFESSIONAL4 = ('p4', u'专业技能良好')
    PROFESSIONAL5 = ('p5', u'专业技能高')
    ENVIRONMENT1 = ('e1', u'就医环境差')
    ENVIRONMENT2 = ('e2', u'就医环境待改进')
    ENVIRONMENT3 = ('e3', u'就医环境一般')
    ENVIRONMENT4 = ('e4', u'就医环境良好')
    ENVIRONMENT5 = ('e5', u'就医环境优')
    SANITATION1 = ('s1', u'卫生条件差')
    SANITATION2 = ('s2', u'卫生条件待改进')
    SANITATION3 = ('s3', u'卫生条件一般')
    SANITATION4 = ('s4', u'卫生条件良好')
    SANITATION5 = ('s5', u'卫生条件好')
    PRIVATE1 = ('pr1', u'私密性差')
    PRIVATE2 = ('pr2', u'私密性待改进')
    PRIVATE3 = ('pr3', u'私密性良好')
    PRIVATE4 = ('pr4', u'私密性良好')
    PRIVATE5 = ('pr5', u'私密性好')
    MESSAGE1 = ('m1', u'私信未回复')
    MESSAGE2 = ('m2', u'私信回复慢')
    MESSAGE3 = ('m3', u'私信回复一般')
    MESSAGE4 = ('m4', u'私信回复较快')
    MESSAGE5 = ('m5', u'私信回复快')
    SALES5 = ('sa5', u'没有推销')
    POSITIVE = ('PO', u'好评')
    NEGATIVE = ('NE', u'差评')
    MEDIUM = ('MD', u'中评')
    WITHIMAGE = ('IMG', u'有图')


# 精准推送用户类型
class PUSH_USER_TYPE(Enum):
    ALL = (0, u'全部')
    NEW_USER = (1, '新用户')
    OLD_USER = (2, '老用户')
    APPOINT_USER = (3, '指定用户')


class SERVICE_COMMENT_OPTION_TYPES(Enum):
    POSITIVE = (0, u'好评')
    NEGATIVE = (1, u'差评')
    MEDIUM = (2, u'中评')


class SPECIAL_EXTRA_POSITION(Enum):
    SERVICE_HOMIE = (0, u'美购频道首页')
    SPECIAL = (1, u'专题详情页')
    INDEX = (2, u'首页')


class ACTIVITY_TYPE_SOC(Enum):
    NORMAL = ('normal', '普通')
    DIAGNOSIS = ('diagnosis', '面诊')


# 排行榜类型
class RANK_LIST_TYPE(Enum):
    DOCTOR = ('0', '医生')
    SERVICE = ('1', '美购')


# 榜单类型
class TOP_RANK_TYPE(Enum):
    DOCTOR = ('0', '医生')
    HOSPITAL = ('1', '机构')


# 首页弹窗类型  －－从backend迁移过来的
class PAGE_TYPE(Enum):
    GREETING = ('0', u'开屏页')
    POPUP = ('1', u'首页提醒')


class INDEX_CARD_TYPE(Enum):
    DIARY = ('0', u'日记本')
    LIVE = ('1', u'直播')
    LIVE_V = ('2', u'新直播样式')
    RANKLIST = ('3', u'榜单')
    QUESTION = ('4', u'问题')
    DIARY_TOPIC = ('5', u'日记贴')
    VIDEO = ('6', u'小视频')
    ARTICLE = ('7', u'文章')
    BUTTONS = ('8', u'横滑按钮')
    ANSWER = ('9', u'回答')
    BIG_SLIDER = ('10', u'大图横滑')
    SMALL_SLIDER = ('11', u'小图横滑')
    FACE_SIMULATOR = ('12', u'人脸识别')
    QUESTION_SLIDER = ('13', u'问题横滑')
    OPERATE_BANNER_AB = ('14', u'运营位AB')
    SECKILL_SLIDER = ('15', u'秒杀横滑')
    SERVICE = ("16", "美购")
    DOCTOR = ("17", "医生")
    HOSPITAL = ("18", "医院")
    TRACTATE = ('19', '帖子')
    DOCTOR_TRACTATE = ('20', '医生帖子')
    BRANDWIKI = ('21', u"品牌百科")
    MATERIALSWIKI = ('22', u"药品/仪器/材料百科")
    COLLECTWIKI = ('23', u"聚合百科")
    SPECIAL = ('24', u'专题')
    ITEMWIKI = ('25', u"项目百科")
    QUESTION_ANSWER = ('26', u"问答")
    LIVE_NOTICE = ('27', u"直播预告")
    SUOZHANG_TOPIC = ('28', u"所长发帖")
    OTHER_WATCH = ('29', u"大家都在看")
    GROUP = ('30', u"小组")
    DOCTOR_LIST = ('31', u"医生榜单")
    HOSPITAL_LIST = ('32', u"机构榜单")
    CONTENT_POLY_EXPERTS_ANSWER = ('33', u"内容聚合页-专家解答tab")
    CONTENT_POLY_EVERYBODY_BUY = ('34', u"内容聚合页-大家都在买tab")
    VISUAL_PAGE = ('35', u"自定义专题页面id")
    PGC_TRACTATE = ('36', u"PGC帖子")  # 新人冷启动使用
    SINGLE_GROUP = ('37', u"单小组")
    SINGLE_TOPIC = ('38', u"单话题")
    CUSTOM = ('39', u"自定义跳转")

    DAILY_CHECK = ('98', u'打卡')  # add in v 7.26.0 活动类--> 打卡
    BANNER = ('99', u'首页BANNER')
    WIKI = ('100', u'百科')

# 用户权益等级
class USER_RIGHTS_LEVEL(Enum):
    V1 = ('1', u'用户一级')
    V2 = ('2', u'用户二级')
    V3 = ('3', u'用户三级')
    V4 = ('4', u'用户四级')
    V5 = ('5', u'用户五级')
    V6 = ('6', u'用户六级')
    V7 = ('7', u'用户七级')


# 医生提报活动类型
class DOCTOR_SECKILL_APPLY_TYPE(Enum):
    NORMAL = ('0', u'普通')
    DISCOUNT = ('1', '折扣')


# 问答置顶类型
class TOP_TYPE(Enum):
    TOP = (0, '置顶')
    PROMOTE = (1, '推广')
    MARKETING = (2, '营销')
    ACTIVITY = (3, '活动')
    SLIDE = (4, '问答横滑')


# 搜索词类型
class SEARCH_KEYWORDS_TYPE(Enum):
    DEFAULT = ('0', '综合')
    SERVICE = ('1', '美购')
    CASE = ('2', '案例')
    DOCTOR = ('3', '医生')
    HOSPITAL = ('4', '医院')
    KNOWLEDGE = ('5', '知识')
    NEW_WIKI = ('6', '百科')
    TRACTATE = ('7', '帖子')


# 订单按钮类型
class ORDER_BUTTON_TYPE(Enum):
    VIEW_COMMENT = ('5', '查看评价')
    GOTO_COMMENT = ('6', '去评价')
    RESERVATION = ('7', '预约')
    VIEW_RESERVATION = ('8', '查看预约')
    MESSAGE_CHAT = ('9', '私信咨询')
    VALIDATE = ('10', '去验证')
    CASH_BACK = ('11', '去返现')
    REFUND = ('12', '退款详情')
    VALUIDATE_CODE = ('13', '查看验证码')
    PAY = ('14', '非分期支付')


# 大杂烩类型，复制于轮播图类型，添加问题，专栏帖子
class MULTITOPIC_TYPE(Enum):
    """跳转页类型
    """
    TOPIC = ('0', '话题')
    URL = ('1', '指定网页')
    SERVICE = ('2', '服务详情')
    MY_POINTS = ('3', '我的积分')
    INVITE = ('4', '邀请好友')
    CREATE_TOPIC = ('5', '创建话题')
    SERVICE_LIST = ('6', '美购列表')
    ZONE = ('7', '圈子首页')
    ZONE_SINGLE = ('8', '单个圈子列表页')
    DIARY = ('9', '日记本')
    TAG = ('10', '标签列表页')
    SPECIAL = ('11', '福利专题列表')
    PROMOTION_GROUP = ('12', '大促聚合页')
    ANNIVERSARY_COUPON = ('13', '大促美劵页')
    SPECIAL_LIST_DIARY = ('14', '案例专题')
    ACTIVITY = ('15', '免费活动')
    SECKILL = ('16', '秒杀')
    SUOZHANG_COLUMN = ('17', '所长专栏')
    DOCTOR_DETAIL = ('18', '医生详情页')
    ORGANIZATION_DETAIL = ('19', '医院详情页')
    FREECUSTOM = ('20', '免费医美定制')
    ZHIBO = ('21', '直播')
    WIKI = ('22', '百科详情页')
    QUESTION = ('23', '问题')
    PROBLEM = ('24', '专栏帖子')


class MULTITOPIC_SERVICE_TYPE(Enum):
    """
    业务类型
    """
    DEAL = ('0', '交易')
    COMMUNITY = ('1', '社区')


class MULTITOPIC_REVIEW_TYPE(Enum):
    """
    待审核的类型
    """
    PROBLEM = ('0', '日记贴')
    QUESTION = ('1', '问题')


class MULTITOPIC_REVIEW_STATUS(Enum):
    """
    待审核的类型
    """
    WAITTING = ('0', '未审核')
    PASS = ('1', '已通过')
    REJECT = ('2', '未通过')


@unique
class BUDAN_STATUS(Enum):
    """
    补单对应状态
    """
    CREATED = (0, u'录入')
    APPEAL = (1, u'申诉')
    CANCEL = (2, u'撤销')
    NOT_PAY = (3, u'未支付')
    PAY_SUCCESS = (4, u'支付成功')
    OVERTIME = (5, u'逾期')
    CREATE_SETTLEMENT = (6, u'生成结算单')


@unique
class BUDAN_OPERATOR(Enum):
    """
    补单操作平台类型, hera后台 和 医生后台
    """
    HERA = (0, u'运营')
    DOCTOR = (1, u'医生')


@unique
class BUDAN_OPERATE(Enum):
    """
    补单操作
    """
    CREATE = (0, u'创建')
    APPEAL = (1, u'申诉')
    REJECT = (2, u'驳回')
    CANCEL = (3, u'撤销')
    PAY = (4, u'支付')
    OVERTIME = (5, u'逾期')


@unique
class BUDAN_SETTLEMENT_STATUS(Enum):
    """
    补单结算单对应状态
    """
    NOT_CREATE = (0, u'未生成')
    NOT_PAY = (1, u'未支付')
    PAY_SUCCESS = (2, u'支付成功')
    OVERTIME = (3, u'逾期')


class HODGEPODGE_ORDER_TYPE(Enum):
    LASTEST = (0, '最新')
    POPULAR = (1, '最热')


class SERVICE_SELL_TYPE(Enum):
    """
    美购类型
    """
    NORMAL = (0, '标准商品')
    ONEPURCHASE = (1, '一元购商品')
    FENGXIANGGOU = (2, '分销商品')
    FLAGSHIP_STORE_SERVICE = (3, '旗舰店商品')


class HIGH_COM_SERVICE(Enum):
    """
    是否高佣分销
    """
    TRUE = (1, '是')
    FALSE = (0, '否')


class OPERATION_LOCATION_TYPE(Enum):
    """
    订单手术地点类型
    """
    NORMAL = ('0', '本院')
    OTHER = ('1', '其它医院')
    WHITE_LIST = ('2', '白名单医院')


class RANKBOARD_TYPE(Enum):
    """
    客户端榜单类型
    """
    SERVICE = ('0', '美购')
    DOCTOR = ('1', '医生')
    HOSPITAL = ('2', '医院')


class RANKBOARD_DATA_TYPE(Enum):
    """
    客户端榜单数据
    """
    NORMAL = ('0', '已加入')
    DRAFT = ('1', '待编辑')
    ONLINE = ('2', '已上线')


class ARTICLE_MODEL(Enum):
    """
    文章展示模式
    """
    NORMAL = ('0', '一般模式')
    STAR = ('1', '明星人物模式')


class NotificationType(Enum):
    """
    消息类型
    """
    ABOUT_ME = (0, '关于我')
    PUSH = (1, '推送消息')
    REPLY_ME = (2, '回复我')
    VOTE_ME = (3, '给我点赞')
    ANSWER_ME = (4, "回答")
    VOTE_FAVOR = (5, "赞与收藏")
    REPLY = (6, "回复")


class TaskStatusType(Enum):
    """
    异步任务状态
    """
    PENDING = ('PENDING', '准备中')
    STARTED = ('STARTED', '开始执行')
    PROGRESS = ('PROGRESS', '执行中')
    SUCCESS = ('SUCCESS', '执行成功')
    FAILURE = ('FAILURE', '执行失败')


class LOGIN_STYLE(Enum):
    """
    登录方式
    """
    USERNAME_PSW = (0, '用户名密码登录')
    TEL_CAPTCHA = (1, '手机号码验证码登录')


class USER_GENDER(Enum):
    """
    用户性别
    """
    UNKNOWN = (0, '未知')
    MALE = (1, '男')
    FEMALE = (2, '女')


class CONST_STRINGS(Enum):
    DIARY_VOTE = "diary_vote", "diary_vote"
    TOPIC_VIEW = "TopicView", "TopicView"
    TOPIC_VOTE = "topic_vote", "topic_vote"
    TOPIC_VOTE_V1 = "topic_vote_v1", "topic_vote_v1"
    TOPIC_REPLY_VOTE = "topic_reply_vote", "topic_reply_vote"
    TOPIC_REPLY_FAKE_VOTE = "topic_reply_fake_vote", "topic_reply_fake_vote"
    APPLY_FREE_EVENT = "apply_free_event", "apply_free_event"
    TOPIC_VOTE_RULE1 = 'topic_vote_rule1', "topic_vote_rule1"
    TOPIC_VOTE_RULE2 = 'topic_vote_rule2', "topic_vote_rule2"
    TOPIC_VOTE_RULE3 = 'topic_vote_rule3', "topic_vote_rule3"
    TOPIC_VOTE_RULE4 = 'topic_vote_rule4', "topic_vote_rule4"
    TOPIC_VOTE_RULE5 = 'topic_vote_rule5', "topic_vote_rule5"
    NORMAL_VOTE = 'normal_vote', "normal_vote"
    EXCHANGE_GIFT = "exchange_gift", "exchange_gift"
    GROUPON = "groupon", "groupon"
    SERVICE = "service", "diaservicery_vote"
    POINT_ACTIVITY_EXCHANGE = "point_activity_exchange", "point_activity_exchange"

    ORDER_DEFAULT = 0, 'ORDER_DEFAULT'
    ORDER_SHARE = 1, 'ORDER_SHARE'
    ORDER_ACCEPT_PM = 2, 'ORDER_ACCEPT_PM'
    ORDER_REPLY = 3, 'ORDER_REPLY'

    ORDER_HIGHEST_SALES = 4, 'ORDER_HIGHEST_SALES'
    ORDER_LOWEST_PRICE = 5, 'ORDER_LOWEST_PRICE'
    ORDER_NEWEST_SALES = 6, 'ORDER_NEWEST_SALES'

    ORDER_NEWEST_PUBLISH = 7, 'ORDER_NEWEST_PUBLISH'
    ORDER_JINGHUA = 8, 'ORDER_JINGHUA'

    NATIONWIDE = 'nationwide', "nationwide"
    WORLDWIDE = 'worldwide', "worldwide"
    ALL = 'all', "all"
    ANSWER_VOTE = "answer_vote", "answer_vote"
    TRACTATE_VOTE = "tractate_vote", "tractate_vote"
    CREATE_TRACTATE_VOTE = "create_tractate_vote", "create_tractate_vote"
    CREATE_TOPIC_VOTE = "create_topic_vote", "create_topic_vote"
    CREATE_ANSWER_VOTE = "create_answer_vote", "create_answer_vote"


class POPUPAD_USER_TYPE(Enum):
    ALL = (0, u'全部用户')
    NEW_USER = (1, '新用户')
    OLD_USER = (2, '老用户')


@unique
class PUNISHMENT_REASON(Enum):
    A = '歧视性价格', '歧视性价格'
    B = '飞单', '飞单'
    D = '其他', '其他'
    E = '单PV贡献不达标', '单PV贡献不达标'
    F = '客诉', '客诉'
    G = '违规拉客或违规留联系方式', '违规拉客或违规留联系方式'


@unique
class PUNISHMENT_STATUS(Enum):
    PRE = u'PRE', u'未生效'
    ING = u'ING', u'生效中'
    DONE = u'DONE', u'处罚完成'
    CANCEL = u'CANCEL', u'已撤销'


@unique
class PUNISHMENT_TYPE(Enum):
    LIMIT = (0, '沉底')
    WEIGHT = (1, '调整排序权重')
    PV = (3, '限制每日展现次数')


@unique
class PUNISHMENT_TYPE_FULL(Enum):
    LIMIT = (0, '沉底')
    WEIGHT = (1, '调整排序权重')
    ADVERTISE = (2, '广告罚单')
    PV = (3, '限制每日展现次数')


@unique
class PUNISHMENT_TARGET(Enum):
    ALL = 'all', '全部'
    SERVICE = 'service', '美购'
    DIARY = 'diary', '日记本'
    DOCTOR = 'doctor', '医生医院'
    QA = 'qa', '问答'


@unique
class PUNISHMENT_PV_LIMIT_DEMESION(Enum):
    SERVICE = 'service', '美购'
    DIARY = 'diary', '日记本'


class BIG_HERA_STATUS(Enum):
    """
    big hera 模板代码状态示例
    """
    ZERO = (0, '状态零')
    FIRST = (1, '状态一')
    SECOND = (2, '状态二')
    THIRD = (3, '状态三')


class SEARCH_KEYWORDS_POSITION(Enum):
    """
    搜索词分类
    """
    DEFAULT = (0, '默认')
    HOT = (1, '热门')


class PUSHCOUPON_STATUS(Enum):
    """
    推送美券状态
    """
    DEFAULT = (0, '未审核')
    PASS = (1, '通过')
    SENDING = (2, '发送中')
    SUCCESS = (3, '发送成功')


class PUSHCOUPON_USER_STATUS(Enum):
    """
    推送美券用户领取状态
    """
    DEFAULT = (0, '未领取')
    SUCCESS = (1, '领取成功')
    FAIL = (2, '领取失败')


class RETURN_EXTRA_KEY(Enum):
    """
    通用返回extra key
    """
    # DEFAULT = (0, '默认无')
    TASK_ALERT = ('task_alert', '场景化弹窗')
    PUSH_ACCREDIT = ('push_accredit', 'push授权弹窗')


class SLIDE_USER_TYPE(Enum):
    """
    slide用户标签类型
    """
    ALL_USER = ('0', '全部用户')
    NEW_USER = ('1', '新用户')
    OLD_USER = ('2', '老用户')


class SLIDE_PAYMENT_TYPE(Enum):
    """
    slide用户支付类型
    """
    ALL_PAYMENT = ('0', '全部类型')
    HAVE_PAYMENT = ('1', '有支付')
    NO_PAYMENT = ('2', '无支付')


class SOURCE_POSITION_DEVICE_TYPE(Enum):
    """
    资源定向位设备类型
    """
    ALL_DEVICE_TYPE = ('0', '全部类型')
    IOS_DEVICE = ('1', '苹果设备')
    ANDROID = ('2', '安卓设备')


class RANKBOARD_CATEGORY(Enum):
    """
    榜单类型
    """
    CUSTOM = ('0', '定制榜单')
    AGGREGATION = ('1', '聚合榜单')


class HOMEPAGE_OPERATE_TYPE(Enum):
    GIFT = ('0', '礼包URL')
    URL = ('1', '网页URL')
    SPECIAL = ('2', '交易专题ID')
    SECKILL = ('3', '秒杀URL')
    ACTIVITY = ('4', '免费活动ID')
    ZHIBO = ('5', '直播预告ID')
    COLUMN_ARTICLE = ('6', '专栏ID')
    QUESTION = ('7', '问题帖ID')
    ANSWER = ('8', '回答帖ID')
    DIARY = ('9', '日记本ID')
    SERVICE_LIST = ('10', '美购列表(协议)')
    SERVICE = ('11', '美购详情页ID')
    DOCTOR = ('12', '医生主页ID')
    HOSPITAL = ('13', '医院主页ID')
    # NORMAL = ('14', '正常搜索')
    POLYMER = ('15', '内容聚合页ID')
    CATEGORY = ('16', '品类落地页面')
    ALL_CATEGORY = ('17', '全部页面')
    CUSTOMER_SERVICE=('18','客服界面')
    TOPIC_POLYMER = ('19', '新专题聚合')
    FUNCTION_PAGE = ('20', '功能页面')
    VISUAL_PAGE = ('21', '自定义专场')


class HOMEPAGE_OPERATE_LOCATION(Enum):
    OPERATE_A = ('0', '运营位A')
    OPERATE_B = ('1', '运营位B')
    SMALL_FIRST = ('2', '小图横滑1')
    SMALL_SECOND = ('3', '小图横滑2')
    OPERATE_FIND = ('4', '发现频道feed运营位')
    ADV_DIARY = ('5', '广告位-日记本第2位')
    SECKILL = ('6', '秒杀横滑')
    ADV_DIARY_1 = ('11', '广告-日记轮转1')
    ADV_DIARY_2 = ('12', '广告-日记轮转2')
    ADV_DIARY_3 = ('13', '广告-日记轮转3')
    ADV_DIARY_4 = ('14', '广告-日记轮转4')
    ADV_DIARY_5 = ('20', '广告-日记轮转5')
    ADV_DIARY_6 = ('21', '广告-日记轮转6')
    POLYMER_BANNER = ('15', '内容聚合banner')
    XIAOCHENGXU_TOP = ('16', '小程序顶部轮播图')
    XIAOCHENGXU_BOTTON = ('17', '小程序底部轮播图')
    PERSONAL_CENTER = ('18', '个人中心banner')
    DIARY_DETAIL = ('19', '日记本详情运营位')


class CHANNEL_CALLBACK_TYPE(Enum):
    """
    渠道回调类型
    """
    NO_CALLBACK = ('0', '无回调')
    GET_CALLBACK = ('1', 'GET回调')
    POST_CALLBACK = ('2', 'POST回调')


class PROMOTION_CHANNEL_NAME(Enum):
    """
    渠道名称列表, 规定枚举值为小写, 格式为promotion_xxxx
    """
    MALIOASO = ('promotion_malioaso', 'malioaso')
    MALIOASOSHEQU = ('promotion_malioaso-shequ', 'malioaso-shequ')
    GDT = ('promotion_gdt', '广点通')
    MCAS = ('promotion_mcas', '迈可思')
    QUMI = ('promotion_qumi', '趣米')
    AISI = ('promotion_aisi', '爱思助手')
    SHIKE = ('promotion_shike', '试客')
    ASO100 = ('promotion_aso100', 'aso100')
    QIANKA = ('promotion_qianka', '钱咖')
    DIANRU = ('promotion_dianru', '点入')
    GREENKOO = ('promotion_greenkoo', '青稞万维')
    WYZM = ('promotion_51zm', '51桌面')
    XIAOYU = ('promotion_xiaoyu', '小鱼赚钱')
    BAIDU = ('promotion_baidu', '百度')
    GOOGLE = ('promotion_google', '谷歌')
    MOMO = ('promotion_momo', '陌陌')
    TOUTIAO = ('promotion_toutiao', '今日头条')
    WANGYIYOUDAO = ('promotion_wangyiyoudao', '网易有道')
    QUTOUTIAO = ('promotion_qutoutiao', '趣头条')
    KOOMOBI = ('promotion_koomobi', '青稞万维')
    BAIDUSHOUZHU = ('promotion_bdshouzhu', '百度手助')
    DIANJING = ('promotion_dianjing', '360点睛实效平台')
    RUIYING = ('promotion_ruiying', '瑞盈aso')
    JULANG = ('promotion_julang', '聚浪aso')
    MEIYOU = ('promotion_meiyou', '美柚')
    MEITU = ('promotion_meitu', '美图')
    KXXXL = ('promotion_kxxxl', '消消乐')
    SHOUJIBAIDU = ('promotion_baiduxxl', '手机百度')
    ZUIMEI = ('promotion_zuimei', '最美')
    WANGYIYOUDAO_V2 = ('promotion_wyyd', '网易有道')
    XINYOUXINGKONG = ('promotion_xinyouxingkong', '信游星空')
    IN_MOBI = ('promotion_inmobi', 'InMobi')
    WEIBO = ('promotion_weibo', 'weibo')
    THREE_WATER = ('promotion_three_water', 'ThreeWater')
    IQIYI = ('promotion_iqiyi', '爱奇艺')
    YEAHMOBI = ('promotion_yeahmobi', 'YEAHMOBI')
    YULONG = ('promotion_yulong', '龙域之星')


class CHANNEL_STATUS(Enum):
    """
    渠道记录和激活返回的状态信息
    ACT_前缀: 激活状态, ADD_前缀: 点击记录状态
    """
    ACT_INVALID_PARAMS = '激活失败, 参数不合法'
    ACT_FAIL_GENERAL = '激活失败'
    ACT_ALREADY_ACTIVATED = '激活失败, 设备已激活'
    ACT_NO_PROMOTION = '激活失败, 设备不是指定渠道推广'
    ACT_OK = '激活成功'

    ADD_INVALID_PARAMS = '记录失败, 参数不合法'
    ADD_ALREADY_ACTIVATED = '记录失败, 设备已激活'
    ADD_OK = '记录成功'
    ADD_FAIL_GENERAL = '记录失败'


class HOT_SEARCH_JUMP_TYPE(Enum):
    """
    热门搜索词支持跳转类型
    """
    GIFT = ('0', '礼包URL')
    URL = ('1', '网页URL')
    SPECIAL = ('2', '交易专题ID')
    SECKILL = ('3', '秒杀URL')
    ACTIVITY = ('4', '免费活动ID')
    ZHIBO = ('5', '直播预告ID')
    COLUMN_ARTICLE = ('6', '专栏ID')
    QUESTION = ('7', '问题帖ID')
    ANSWER = ('8', '回答帖ID')
    DIARY = ('9', '日记本ID')
    SERVICE_LIST = ('10', '美购列表(协议)')
    SERVICE = ('11', '美购详情页ID')
    DOCTOR = ('12', '医生主页ID')
    HOSPITAL = ('13', '医院主页ID')
    NORMAL = ('14', '正常搜索')
    # 新版秒杀
    NEW_SECKILL = ('15', '秒杀专场')
    SECKILL_POLYMER = ('16', '秒杀聚合')
    TOPIC_POLYMER = ('17', '新专题聚合')
    VISUAL_PAGE = ('18', '自定义专题页面')


class APPLY_STATUS(Enum):
    PASS = ('3', '报名成功')
    REJECT = ('1', '驳回')
    DEFAULT = ('0', '未处理')
    RE_APPLY = ('2', '重新提报')


class PROMOTION_REASON(Enum):
    REASON_A = ('报价项目与规则不符合','报价项目与规则不符合')
    REASON_B = ('活动价不得高于更美价','活动价不得高于更美价')
    REASON_C = ('商务要求驳回','商务要求驳回')
    REASON_D = ('其他','其他')


class HOSPITAL_ALBUM_TYPE(Enum):
    """
    医院详情页，图片类型
    """
    ENVIRONMENT = (0, "环境图片")
    DEVICE = (1, "设备图片")


class SECKILL_TYPE(Enum):
    """
    秒杀专场类型
    """
    GENGMEI = ('0', '更美秒杀')
    CATEGORY = ('1', '品类秒杀')
    BRAND = ('2', '品牌秒杀')

class SECKILL_RESOURCE_TYPE(Enum):
    """
    秒杀资源位类型
    """
    CATEGORY = ('0', '品类聚合')
    BRAND = ('1', '品牌聚合')
    CATEGORY_SPECIAL = ('2', '品类专场')
    BRAND_SPECIAL = ('3', '品牌专场')


class POLYMER_DETAIL_TAB_TYPE(Enum):
    """
    聚合页 (新圈子) tab 类型
    """
    DIARY = (0, "日记")
    SERVICE = (1, u'美购')
    KNOWLAGE = (2, u'知识')  # 回答 + 专栏
    DOCTOR = (3, u'医生')
    HOSPITAL = (4, u'医院')
    DISSCUSS = (5, u'讨论')
    VIDEO = (6, u'视频')
    TRACTATE = (7, u'帖子')


class POLYMER_CONTENT_TYPE(Enum):
    """
    聚合页 (新圈子) 内容 类型
    """
    DIARY = ('diary', u"日记")
    SERVICE = ('service', u'美购')
    ANSWER = ('answer', u'回答')
    ARTICLE = ('article', u'文章')
    DOCTOR = ('doctor', u'医生')
    HOSPITAL = ('hospital', u'医院')
    QUESTION = ('question', u'问题')
    VIDEO_QUESTION = ('video_question', u'视频问题')
    TRACTATE = ('tractate', u'帖子')


class KNOWLEDGE_ORDER_TYPE(Enum):
    """
    v 7.6.65  内容聚合页 知识 排序规则
    """
    LASTEST = (0, u'最新发布')  # 创建时间倒序排序
    BEST = (1, u'精华')


class WORDREL_CATEGORY(Enum):
    """
    同义词关键字类型
    """
    EMPTY = ('0', u'-----')
    ITEM = ('1', u'项目')
    ORG = ('2', u'机构')
    OTHER = ('9', u'其他')
    PART = ('10', u'部位')
    SYMPTOM = ('11', u'症状')
    NEED = ('12', u'需求')
    CURE = ('13', u'治疗方式')
    STUFF = ('14', u'材料')
    BRAND = ('15', u'品牌')
    DOCTOR = ('16', u'医生')
    CITY = ('17', u'城市')
    OPERATION = ('18', u'运营标签')



class CITY_LEVEL(Enum):
    """
    城市级别  超一线 一线 二线。。。
    """
    SUPER = 0, '超一线'
    ONE = 1, '一线'
    TWO = 2, '二线'
    THREE = 3, '三线'
    FOUR = 4, '四线'

class LOADING_POSITION(Enum):
    FIRST = (0, 'loading1')
    SECOND = (1, 'loading2')

class CARD_TYPE(Enum):
    SELECTDIARY = ('A', '精选日记本')
    SPECISLDIARY = ('B', '个性化日记本')
    ZHIBO = ('C', '直播')
    BANGDAN = ('D', '榜单')
    ANSWERRECOMMEND = ('E', '问答推荐')
    BUTTON = ('F', '按钮横滑')
    SPECIALPROBLEN = ('G', '个性化问题')
    BIGPHOTOFIRST = ('H', '大图横滑一')
    SPECIALANSWER = ('I', '个性化回答')
    SMALLPHOTOFIRST = ('J', '小图横滑一')
    SMALLPHOTOSECOND = ('K', '小图横滑二')
    FEED = ('L', '运营位')
    SPECIALCLOUM = ('M', '个性化专栏')
    FACEANLY = ('N', '人脸分析')
    BIGPHOTOSECOND = ('O', '大图横滑二')
    FEEDAB = ('P', '运营位AB')
    RSKHENGHUA = ('R', 'R秒杀横滑')
    DIARYONE = ('S', '日记广告一')
    DIARYTWO = ('T', '日记广告二')
    DIARYTHREE = ('U', '日记广告三')
    DIARYFOUR = ('V', '日记广告四')


class COLLEGE_LEVEL(Enum):
    JUNIOR = (0, '专科')
    UNDERGRADUATE = (1, '本科')


class RED_PACKET(Enum):
    """
    拉新红包类型
    """
    INVITE = ('0', '邀请红包')
    CASH = ('1', '现金红包')


class TRANS_ACTION(Enum):
    """
    流水记录收支类型
    """
    DEPOSIT = (0, '收入')
    WITHDRAW = (1, '提现')


class TRANS_STATUS(Enum):
    """
    红包提现审核状态
    """
    PASS = (0, '已通过')
    WAIT = (1, '审核中')
    REJECT = (2, '已驳回')

class TRANS_EVENT(Enum):
    """
    流水记录事件类型
    """
    CASH_PACKET = (0, '现金红包')
    INVITE_PACKET = (1, '邀请红包')
    WITHDRAW = (2, '用户提现')


class REJECT_REASON(Enum):
    """红包提现驳回原因"""
    ZERO = ('0', '邀请的多个用户在同一设备登录')
    FIRST = ('1', '邀请的多个用户在十分钟内登录')
    SECOND = ('2', '短时间内邀请了大量用户')
    THIRD = ('3', '其他')


class SATISFACTION_DEGREE(Enum):
    BAD = ('0', '不满意')
    GOOD = ('1', '一般')
    SATISFIED = ('2', '满意')
    EXCELLENT = ('3', '非常满意')


class DisplayTag(Enum):
    """搜索展示的TAG标签类型"""
    HOSPITAL_SCALE = (1, '医院规模')
    BADGE = (2, '名医大赏')
    OPERATE_TAG = (3, '个性化标签')


class XCX_LANDING_PAGE(Enum):
    """吐槽小程序，下载落地页"""
    A = ("A", u"下载落地页A")
    B = ("B", u"下载落地页B")
    C = ("C", u"下载落地页C")


class TRANSFER_SOURCE(Enum):
    """商务转诊人员来源"""
    OTHERS = (0, '其它')
    # SHARE_CARD = (1, '分享名片')
    # SEARCH_WEIXIN = (2, '搜索微信')
    # WEIXIN_SCAN = (3, '微信扫一扫')
    # NEW_MEDIA = (4, '新媒体')
    # INITIATIVE_ADD = (5, '主动添加')
    GENGMEI_BACKEND = (6, '更美后台')
    # SZ_RECOMMEND = (7, '所长推荐')
    # CUSTOMER_SELF = (8, '自己顾客')
    # CUSTOMER_INTRODUCE = (9, '顾客介绍')
    # # 应产品要求，加 20个渠道，让运营的人自己去对应
    # CHANNEL_1 = (18, '渠道1')
    # CHANNEL_2 = (19, '渠道2')
    # GENGMEI_APP = (38, '更美APP')
    # MOMO_FEED = (40, '陌陌Feed流')
    NEITOU_PC = (40, '内投-PC首页')
    NEITOU_M = (41, '内投-M站首页')
    NEITOU_APP = (42, '内投-APP首页(更美咨询)')
    NEITOU_APP_OLD = (43, '内投-APP首页(老客)')
    NEITOU_APP_NEW = (44, '内投-APP首页(新人)')
    NEITOU_APP_SERVICE = (45, '内投-APP美购页')
    NEITOU_APP_KEFU = (46, '内投-APP客服中心')
    NEITOU_APP_BLOCK = (47, '内投-APP豆腐块')
    NEITOU_GONGZHONG = (48, '内投-公众号')
    NEITOU_WEIBO = (49, '内投-微博')
    NEITOU_DOCTOR = (50, '内投-医生待咨询')
    NEITOU_ZHIHU = (51, '内投-知乎')
    NEITOU_XIAOHONGSHU = (52, '内投-小红书')
    WAITOU_BAZ = (53, '外投-市场提供数据')
    OTHER_CUSTOMER = (54, '其他-客户转介绍')
    OTHER_SLEEP = (55, '其他-沉睡客户激活')

    MOMO_SECKILL = (10, '陌陌秒杀')
    BAIDU_SPECIAL_GOODS = (11, '百度品专')
    BAIDU_SEARCH = (12, '百度搜索')
    TOUTIAO = (13, '今日头条')
    MOMO_IOS = (14, '陌陌IOS')
    BAIDUYS1 = (15, '百度原生')
    IQIYIXXL1 = (16, '爱奇艺信息流')
    MOMO_IOS1 = (17, '陌陌微信号')
    OLD_GENGMEI_APP = (39, '旧版更美APP(7740版本以前)')

    FRIEND_RECOMMEND = (56, '朋友推荐')
    INTERNAL_STAFF = (57, '内部员工')
    OLD_WITH_NEW = (58, '老带新')
    WX_OFFICIAL_ACCOUNT_MESSAGE = (59, '公众号客服消息')
    WX_OFFICAL_ACCOUNT_COMMENT = (60, '公众号文章评论')
    PHONE_LIST_CUSTOMER = (61, '电话名单顾客')


class USER_NTENTION(Enum):
    """商务转诊人员倾向"""
    UNDEFINED = (0, '未明确喜好')
    PUBLIC = (1, '公立医院喜好')
    PRIVATE = (2, '私营机构喜好')


class USER_POTENTIAL(Enum):
    """商务转诊人员潜力评估"""
    GENERAL_CUSTOMER = (0, '一般客户')
    POTENTIAL_CUSTOMER = (1, '潜力客户')
    IMPORTANT_CUSTOMER = (2, '重点客户')


class BUDAN_TYPE(Enum):
    """补单类型"""
    GENERAL_BUDAN = (0, '一般补单')
    TRANSFER_BUDAN = (1, '转诊补单')


class OPERATION_ACTION(Enum):
    """操作类型"""
    CREATE = (0, '创建')
    ASSIGN = (1, '分配')
    RETURN = (2, '回抛至回抛池')
    RETURN_TO_PUBLIC = (3, '回抛至公池')
    ADD_ASSISTOR = (4, '添加协助顾问')
    DEL_ASSISTOR = (5, '删除协助顾问')
    REASSIGN = (6, '顾问调整')
    PASS = (7, '同意协助顾问申请')
    REJECT = (8, '驳回协助顾问申请')


class REPEAT_TYPE(Enum):
    """转诊线索重复类型"""
    CREATE = (1, '直接成为协助顾问')
    APPLY = (2, '申请成为协助顾问')


class AssistStatus(Enum):
    """协助顾问状态"""
    PENDING = (0, '待审批')
    PASSED = (1, '已通过')
    REJECT = (2, '已驳回')


class NO_REPLY(Enum):
    ONE_WEEK = (0, '一周以内')
    ONE_MONTH = (1, '一个月以内')
    THREE_MONTH = (2, '三个月以内')
    THREE_MONTH_ABOVE = (3, '三个月以上')


class CONSUME_PONTENTIAL(Enum):
    ZERO_THOUSAND = (0, '0-1000')
    THOUSAND_THREE_THOUSAND = (1, '1001-3000')
    THREE_THOUSAND_EIGHT_THOUSAND = (2, '3001-8000')
    EIGHT_THOUSAND_FIFTH_THOUSAND = (3, '8000-15000')
    FIFTH_THOUSAND_THRITY_THOUSAND = (4, '15001-30000')
    THRITY_THOUSAND_PLUS = (5, '30000+')


class SINGLE_TYPE(Enum):
    NO_ORDER_FORM = (0, '已派单')
    HAS_ORDER_FORM = (1, '已成单')
    HAS_CANCEL = (2, '已撤销')
    HAS_APPOINTMENT = (3, '已预约')
    HAS_CONSULTATION = (4, '已面诊')
    HAS_TERMINATE = (5, '已终止')
    HAS_ACCEPT = (6, '已接单')
    DUPICATE_DISPATCH = (7, '已重单')


class MOMO_STAT_LOG_TYPE(Enum):
    """
    陌陌钱包, 数据埋点类型
    """
    SEVICE_DETAIL = ("detail_access", u"商品详情页请求打点")
    CONVERSATION_CLICK = ("detail_msg_ask_click", u"商品详情页私信咨询点击")
    CONVERSATION_MOBILE_BIND_SUCCESS = ("detail_mobile_validate_success", u"私信咨询手机号验证成功")
    CONVERSATION_FIRST_REPLY = ("detail_dialog_first_reply", u"咨询会话，用户第一次回复打点")
    SERVICE_PAY_CLICK = ("detail_pay_click", u"商品详情页立即支付点击")
    PRE_PAY_SUCCESS = ("pay_success", u"预支付成功打点")
    ORDER_VERIFIED_SUCCESS = ("pay_verified_success", u"线下验证成功打点")
    ORDER_REFUND_SUCCESS = ("pay_refund_success", u"退款成功打点")
    ADVISORY_CLICK_SUCCESS = ("advisory_click_success", u"免费咨询页面，信息提交成功打点")


class MOMO_STAT_LOG_MESSAGE_TYPE(Enum):
    """陌陌打点信息类型"""
    ORDER_VERIFIED_SUCCESS = (1, u"线下验证成功打点")
    CONVERSATION_FIRST_REPLY = (2, u"咨询会话，用户第一次回复打点")


class ANSWER_ORDER_TYPE(Enum):
    """
    问答详情页回复排序策略
    """
    NOT_ORDER_BY_TIME = (0, '不按时间排序')
    TIME_RISE = (1, '时间升序')
    TIME_REDUCE = (2, '时间降序')
    HOTEST = (3, '最热')


class GROUP_TOPIC_TAB_TYPES(Enum):
    """小组、话题tab"""

    CHOICE = ('choice', u'社区')
    SERVICE = ('service', u'美购')
    RANK_LIST = ('rank_list', u'榜单')
    VIDEO = ('video', u'视频')


class TAB_TYPES_NEW(Enum):
    """首页tab"""

    CHOICE = ('choice', u'精选')
    NEWEST = ('newest', u'新鲜')
    SERVICE = ('service', u'美购')
    FOLLOW = ('follow', u'关注')
    VIDEO = ('video', u'视频')
    LIVE = ('live', u'直播')
    HOME_VIDEO = ('home_video', u'视频')
    GOSSIP = ('gossip', u'八卦')
    STAR_DIARY = ('star_diary', u'日记')
    BIG_SHOT = ('big_shot', u'经验')
    TAB_OPERATE = ('tab_operate', '运营配置tab')
    TAB_IBEAUTY = ('ibeauty', 'iBeauty tab')
    TAB_DOCTOR = ('hospital_rank', '医生')
    TAB_AI_PLASTIC = ('ai_plastic_feed', 'AI-模拟整形feed')
    TAB_AI = ('ai_feed', 'AI频道页')


class TAB_INDEX_CLASSIFY(Enum):
    """首页TAB分类"""

    NORMAL = ('normal', u'普通类型')
    IBEAUTY = ('ibeauty', u'iBeauty类型')


class GROUPBUY_TYPE(Enum):
    """拼团模式"""
    OLD_TO_OLD = (1, '老带老')
    OLD_TO_NEW = (2, '老带新')

class ACTIVE_TYPE(Enum):
    '''
        活动类型
    '''
    COMMON=(1,'普通活动')
    WECHAT_ONE_YUAN=(2,'小程序1元拼团')


class GROUPBUY_STATUS(Enum):
    """拼团状态"""
    NOT_GROUPBUY = (0, '不是拼团')
    GROUPBUY_NOT_STARTED = (1, '拼团未开始')
    GROUPBUY_STARTED = (2, '拼团进行中')
    GROUPBUY_SUCCESSED = (3, '拼团成功')
    GROUPBUY_FAIL = (4, '拼团失败')


class TONGDUN_EVENT(Enum):
    """同盾事件"""
    COLLAGE = (0, '拼团')
    REGISTER = (1, '注册')
    LOGIN = (2, '登录')
    ACTIVE = (3, '激活')
    CLICK = (4, '点击')
    DETAIL = (5, '详情')


class TONGDUN_RESULT(Enum):
    """同盾检验结果"""
    ACCEPT = ('Accept', '无风险')
    REVIEW = ('Review', '低风险')
    REJECT = ('Reject', '高风险')


class TONGDUN_DBSTORE(Enum):
    """同盾对应DB保存结果"""

    FAIL = (0, '未校验')
    ACCEPT = (1, '无风险')
    REVIEW = (2, '低风险')
    REJECT = (3, '高风险')


class VOTE_CHANGE_TYPE(Enum):
    """票数变化原因"""

    LOGIN = (1, '登录')
    INVITE = (2, '邀请')
    VOTE = (3, '投票')


class VOTE_STATUS(Enum):
    """领取登录票数状态"""

    HAS_GET = (1, '今日已经领取')
    NOW_GET = (2, '此次领取')


class SPECIAL_RULE_SET(Enum):
    NONE = (-1, "由美购具体设置决定")
    NO = (0, "不能")
    YES = (1, "能")


class LIPSTICK_ITEM_TYPE(Enum):
    """
    口红转盘奖品类型
    """
    LIPSTICK = (0, '口红')
    SCORE = (1, '美分')
    COUPON = (2, '美券')
    THANKS = (3, '谢谢惠顾')


class OPERTOR_REVIEW_TYPE(Enum):
    """运营审核"""
    NO_REVIEW = ('0', '无需运营审核')
    WATI_REVIEW = ('1', '待运营审核')
    REVIEW_PASS = ('2', '审核通过')


class CHECK_TYPE(Enum):
    """审核状态"""
    NOT_REVIEW = ('0', "不审核")
    HAS_REVIEW = ('1', "审核")


class IDOL_GENDER(Enum):
    """口红王子嘉宾性别"""
    MALE = ('0', '王子')
    FEMALE = ('1', '公主')


class RECEVEIVINGEND(Enum):
    """转盘活动领取来源"""
    CLIENT = (0, '客户端')
    WECHAT = (1, '小程序')
    H5 = (2, 'h5')

class USER_CLASSIFY(Enum):
    """用户分类"""
    NORMAL = ('0', '普通用户')
    MODEL = ('1', '模特用户')


class SIGN_TYPE(Enum):
    """7730连续签到签到状态"""
    NO_SIGN = ('0', '未签到')
    HAVE_SIGN = ('1', '已签到')
    HAVE_EXCHANGE = ('2', '已兑换')
    BREAK_SIGN = ('3', '断签')


class SIGN_SWITCH_STATUS(Enum):
    """7730连续签到"""
    ENTER_SWITCH = ('0', '入口开关')
    FLOAT_WINDOW_SWITCH = ('1', '悬浮窗开关')
    SWITCH_STATUS = ('2', '开关状态')


class BDTRANSFER_OBJECT_STATE(Enum):
    """商务转诊 对象状态"""
    NOT_THROUGH_INFOMATION = (1, '未通过消息')
    HAS_PASSED_INFOMATION = (2, '已通过消息')
    HAS_SENT_SINGLE = (3, '已派单')
    HAS_MADE_APPOINTMENT = (4, '已预约')
    HAS_CONSULTATION = (5, '已面诊')
    SINGLE_FINISHED = (6, '已成单')
    HAS_TERMINATE = (7, '已终止')


class SIGN_USER_ACTION(Enum):
    """用户签到的动作"""
    TO_SIGN = ('1', '签到')
    RESET_SIGN = ('2', '重新签到')
    ADD_SIGN = ('3', '补签')


class NEW_SPRING_ACTIVITY_IMA_LEVEL(Enum):
    """新春活动图片等级"""
    ACTIVITY_LEVEL_ONE = (1, '盛世美颜')
    ACTIVITY_LEVEL_TWO = (2, 'c位出道')
    ACTIVITY_LEVEL_THREE = (3, '靠脸吃饭')
    ACTIVITY_LEVEL_FOUR = (4, '颜值担当')
    ACTIVITY_LEVEL_FIVE = (5, '中学班花')
    ACTIVITY_LEVEL_SIX = (6, '颜考第一')
    ACTIVITY_LEVEL_SEVEN = (7, '素颜超神')
    ACTIVITY_LEVEL_EIGHT = (8, '天生丽质')
    ACTIVITY_LEVEL_NINE = (9, '死亡视角')


class SERVICE_PLATFORM_TYPE(Enum):
    """美购平台信息"""
    DIANPING = (1, '点评')
    HELIJIA= (2, '河狸家')
    YUEMEI= (3, '悦美')
    TMALL = (4, '天猫')


class REQUEST_SOURCE(Enum):
    """请求来源"""
    GEMGMEI = ('gengmei', '更美')
    SHEQU = ('shequ', '更美社区版')


class NEW_SPECIAL_TYPE(Enum):
    """专题配置类型"""
    DEFAULT = ('default', '无')
    VIDEO = ('video', '视频')
    COUPONS = ('coupons', '美券')
    TURNTABLE = ('turntable', '转盘')
    STOREY = ('storey', '楼层')
    SERVICE = ('service', '专题美购列表')
    STATIC_TEMPLATE_SLIDE = ('static_template_slide', '图片(横滑)')
    STATIC_TEMPLATE_BIG = ('static_template_big', '图片(中间放大)')
    STATIC_TEMPLATERE = ('static_template_re', '图片(展开收起)')
    STATIC_TEMPLATERE_SINGLE = ('static_template_single', '图片(单图)')
    STATIC_TEMPLATERE_DOUBLE = ('static_template_double', '图片(双图)')
    STATIC_TEMPLATERE_LR = ('static_template_lr', '图片(背景图+左两图)')


class GADGET_TYPE(Enum):
    """豆腐块类型"""
    SINGLE = (1, '单图')
    DOUBLE = (2, '双图')
    NEW_DOUBLE = (3, '背景图+左右图')
    BIG = (4, '中间放大')
    SLIDE = (5, '横滑')
    OPEN_RETRACT = (6, '展开收起')


class SERVICE_HOME_OPERATION(Enum):
    """美购首页运营位类型"""
    ARRANGE = ('0', '横排')
    SLIDE = ('1', '横滑')


class SERVICE_DISPLAY_PORT(Enum):
    """美购首页展示端口"""
    APP = ('1', '客户端')
    XCX = ('2', '小程序')
    M = ('3', 'M站')
    # PC = ('4', 'PC站')


class FONT_COLOR(Enum):
    """字体颜色"""
    WHITE = ('0', '白色')
    BLACK = ('1', '黑色')


class SERVICE_HOME_GARY(Enum):
    """美购首页灰度"""
    GRAY_A = ('0', '灰度组A')
    GRAY_B = ('1', '灰度组B')
    NOT_GRAY_A = ('2', '对照组A')
    NOT_GRAY_B = ('3', '对照组B')
    NOTHING = ('4', '无关组')
    OLD = ('5', '老版本')


class TRACTATE_DETAIL_GARY(Enum):
    """帖子详情页灰度"""
    GRAY_A = ('0', '灰度组A')
    NOTHING_B = ('1', '对照组B')
    GRAY_C = ('2', '灰度组C')
    NOTHING_D = ('3', '对照组D')
    NOTHING_E = ('4', '对照组E')
    GRAY_OLD = ('5', '老版本')


class VIDEO_LIBRARY_VIDEO_TYPE(Enum):
    """
    视频库，视频类型。目前仅支持百科 (2019.03.20)
    """
    BRAND = (1, u"品牌百科")
    DRUG = (2, u'药品百科')
    INSTRUMENT = (3, u'仪器百科')
    MATERIALS = (4, u'材料百科')
    ITEM = (5, u"项目百科")


class QINIU_VIDEO_HANDLE_STATUS_CODE(Enum):
    """
    七牛视频处理状态码
    """
    SUCCESS = (0, "成功")
    WAITING_PROCESS = (1, "等待处理")
    PROCESSING = (2, "正在处理")
    PROCESSING_FAIL = (3, "处理失败")
    NOTIFICATION_FAIL_SUBMIT = (4, "通知提交失败")


class CATEGORY_TEMPLATE_TYPE(Enum):
    """
    品类聚合模版配置类型
    """
    TYPE_ONE_WITH_THREE = (1, '样式一(3个)')
    TYPE_ONE_WITH_FOUR = (2, '样式一(4个)')
    TYPE_TWO_WITH_FOUR = (3, '样式二(4个)')
    TYPE_TWO_WITH_FIVE = (4, '样式二(5个)')
    TYPE_THREE_WITH_FOUR = (5, '样式三(4个)')
    TYPE_THREE_WITH_SIX = (6, '样式三(6个)')


# 2019-04-12地推活动
class TEMP_ACTIVITY_TYPE(Enum):
    '''
    用于临时活动类型定义, 如地推啥的
    '''
    GROUND_PUSH1904 = (1001, '2019-04-12地推用户拉新')
    NORMAL_ASSIST = (1002, '助力拿好礼')


class EXCHANGE_TYPE(Enum):
    '''
    用户活动的兑换状态, 可酌情添加状态, 能复用尽量复用
    '''
    APPLY = (10, '申请中')
    PAID = (20, '已发放')


class BENEFIT_TYPE(Enum):
    """
    美券类型
    """
    ZHIJIAN = (0, '直减')
    MANJIAN = (1, '满减')
    DISCOUNT = (2, '折扣')


class USER_CHANGE_LOG_TYPE(Enum):
    """
    用户表变更来源
    """
    SYSTEM = (0, "系统操作")
    USER = (1, "用户操作")


class USER_CHANGE_LOG_OPERATE_TYPE(Enum):
    """
        用户表变更操作类型
    """
    LOGIN = (0, "用户登录")
    REGISTER = (1, "用户注册")
    USER_UPDATE = (2, "用户更新信息")
    SYSTEM_UPDATE = (3, "系统更新信息")


class SIGN_TYPE_V2(Enum):
    """
    签到活动2019/05改版
    """
    NOMALR_SIGN = (1, "用户正常签到")
    ADD_SIGN = (2, "用户补签")
    GET_POINTS = (3, "用户当天正常签到，且自动领取美分")
    GET_COUPON = (4, "用户当天正常签到，且自动领取美券")
    GET_LOTTERY = (5, "用户当天正常签到，且得到抽奖机会")   #方便下次迭代扩展


class SIGN_CALENDAR_TYPE_V2(Enum):
    """
    签到日历展示的类型
    """
    NO_START = (-1, "新签到还未开始")
    CAN_NOT_SIGN = (0, "大于当前时间， 无法签到")
    NOMALR_SIGN = (1, "正常签到")
    NO_SIGN = (2, "断签")
    GET_POINTS = (3, "展示当天领取过美分")
    GET_COUPON = (4, "展示当天领取过优惠券")
    GET_LOTTERY = (5, "展示当天抽过奖")    #方便下次迭代扩展


class VIRTUAL_PRIZE_TYPE_V2(Enum):
    """
    虚拟奖品类型
    """
    POINTS_TYPE = (1, "奖品是美分")
    COUPON_TYPE = (2, "奖品是优惠券")
    LOTTERY_TYPE = (3, "奖品是抽奖机会")    #方便下次迭代扩展


class SERVICEHOME_OPERATION_POSITION(Enum):
    """
    首页运营位图片位置
    """
    FIRST = (1, "位置一")
    SECOND = (2, "位置二")
    THREE = (3, "位置三")


class SUB_ARTICLE_PLATFORM(Enum):
    """公众号文章来源"""

    GRASP = (1, "抓取")
    HERA = (2, "hera添加")


class FEED_OPERATION_POSITION(Enum):
    """
    FEED 卡片展示位置
    """

    NO2 = (2, "位置  2")
    NO3 = (3, "位置  3")
    NO4 = (4, "位置  4")
    NO6 = (6, "位置  6")
    NO8 = (8, "位置  8")
    NO9 = (9, "位置  9")
    NO12 = (12, "位置  12")
    NO15 = (15, "位置  15")
    NO16 = (16, "位置  16")
    NO18 = (18, "位置  18")
    NO20 = (20, "位置  20")
    NO21 = (21, "位置  21")
    NO24 = (24, "位置  24")
    NO28 = (28, "位置  28")
    NO32 = (32, "位置  32")
    NO36 = (36, "位置  36")


class SUBSCRIPT_ARTICLE_SORT(Enum):

    ORDERING = (1, "根据ordering排序")
    CREATE_TIME = (2, "根据创建时间排序")


class FEED_SHOW_TYPE(Enum):
    """
    FEED 坑位轮播位类型
    """
    A = (1, "A位")
    B = (2, "B位")
    C = (3, "C位")
    D = (4, "补位")


class FREE_PLASTIC_EXERCISE_STATUS(Enum):
    """
    免费整活动状态
    """
    NOT_REVIEW = ('0', '待审核')
    HERALD = ('1', "活动预告中")
    NOT_OK = ('2', "审核未通过")
    ENROLL = ('3', "活动报名中")
    AUDITIONS = ('4', "机构海选中")
    MOOD = ('5', "攒人气PK中")
    CLOSED = ('6', "活动结束")


class FREE_PLASTIC_AUDIT_STATUS(Enum):
    """
    免费整审核状态
    """
    NOT_REVIEW = ('0', '待审核')
    PASS = ('1', "通过")
    NOT_OK = ('2', "未通过")


class FREE_PLASTIC_USER_IMG(Enum):
    """
    免费整用户照片类型
    """
    FACE_PREOPERATION = ('0', u'脸部术前照片')
    BODY_PREOPERATION = ('1', u'身体术前照片')
    LIFE_PHOTO = ('2', u'生活照')


class AGILE_TAG_TYPE(Enum):
    """
    新标签类型
    """
    UNDEFINED = ('0', '未定义')
    PROJECT = ('1', '项目')
    POSITION = ('2', '部位')
    BRAND = ('3', '品牌')
    INSTRUMENT = ('4', '仪器')
    HOSPITAL = ('5', '医院')
    DOCTOR = ('6', '医生')
    SYMPTOM = ('7', '症状')
    MATERIAL = ('8', '材料')
    CITY = ('9', '城市')
    PROVINCE = ('10', '省份')
    COUNTRY = ('11', '国家')


class AGILE_TAG_CREATE_TYPE(Enum):
    """
    标签创建类型
    """
    CUSTOM = ('1', '用户自定义')
    SYSTEM = ('2', '系统创建')
    OPERATOR = ('3', '运营创建')


class AGILE_TAG_STYLE(Enum):
    """
    新标签样式
    """
    UNDEFINED = ('0', '无样式')
    ACTIVITY = ('1', '活动')
    COMMEND = ('2', '推荐')
    OFFICIAL = ('3', '官方')


class AGILE_TAG_ATTRIBUTE(Enum):
    """
    新标签属性
    """
    NULL = ("0", u"未分类")
    ITEM = ("1", u"项目标签")
    YUNYING = ("2", u"运营标签")


class TAG_ATTRIBUTE(Enum):
    """标签属性"""

    ITEM = (1, u"项目标签")
    NO_ITEM = (2, u"非项目标签")


class AGILE_TAG_RECOMMEND_TYPE(Enum):
    """
    新标签推荐类型
    """
    TRACTATE = ("1", "用户帖")


class DOCTOR_USE_COUPON_TYPE(Enum):
    """
    医生美券类型
    """
    NONE_FOR_DOCTOR = (0, "非医生券")
    PART_GENERAL = (1, "限制美购使用")
    DOCTOR_GENERAL = (2, "医生通用")
    FULL_PLATFORM_GENERAL = (3, "全平台通用")


class NOTIFICATION_TYPE(Enum):
    """
    通知内容类型
    """
    ORDER = (1, "订单相关")
    DIARY = (2, "日记本相关")
    TRACTATE = (3, "帖子相关")
    QUESTION_ANSWER = (4, "问答相关")
    SYSTEM = (5, "更美系统相关")


class BURY_EVENT_TYPE(Enum):
    """
    埋点消息事件
    """
    VALIDATE_ORDER = (1, '验证订单')


class AGILE_TAG_HERA_RECOMMEND_TAB_TYPE(Enum):
    """
    新标签 hera后台推荐 tab区域类型
    """
    PROJECT = ('1', '项目')
    POSITION = ('2', '部位')
    BRAND = ('3', '品牌')
    INSTRUMENT = ('4', '仪器')
    HOSPITAL = ('5', '医院')
    DOCTOR = ('6', '医生')
    SYMPTOM = ('7', '症状')
    MATERIAL = ('8', '材料')
    CITY = ('9', '城市')
    PROVINCE = ('10', '省份')
    COUNTRY = ('11', '国家')
    ALL = ("9999", '全部')

class MERCHANT_LEVEL(Enum):
    """
    商户等级
    """
    S=(0,'S级')
    A=(1,'A级')
    B=(2,'B级')
    C=(3,'C级')
    D=(4,'D级')
    E=(5,'E级')


class MERCHANT_LEVEL_NEW(Enum):
    """
    商户等级新规则
    """
    V0=(0,'V0')
    V1=(1,'V1')
    V2=(2,'V2')
    V3=(3,'V3')
    V4=(4,'V4')
    V5=(5,'V5')
    V6=(6,'V6')
    V7=(7,'V7')


class PULL_BLACK_TYPE(Enum):
    HAND = (0, u'手工添加')
    STRATEGY = (1, u'策略添加')
    DATA = (2, u'数据添加')


class MARKET_TAG_TYPE(Enum):
    """
    营销标签类型
    """
    SHEQU = (1, '社区类型')
    JIAOYI = (2, "交易类型")


class MARKEY_TAG_PAY_TYPE(Enum):
    """
    支付类型
    """
    NOT_PAID = (1, "未支付")
    HAS_PAID = (2, '已支付')
    HAS_USED = (3, "已验证")

class RANGE_TYPE(Enum):
    WHOLE_CITY = (0, u'全国展示')
    PARTIAL_CITY = (1, u'部分城市展示')
    PARTIAL_MERCHANT = (2, u'部分商户展示')


class USERCALL_STATUS(Enum):
    """
    用户呼叫状态
    """
    NOT_HANDLE = (1, "未处理")
    CONNECTED = (2, "已接通")
    NOT_CONNECTED = (3, "未接通")
    NO_ANSWER = (4, "无人接听")
    PHONE_INVALID = (5, "号码无效")
    HANG_UP = (6, "已挂断")


class USERACTIVE_STATUS(Enum):
    """
    用户呼叫有效状态
    """
    TODO_THAT_MONTH = (1, "当月要做")
    HAVE_REQUESTS = (2, "有需求")
    NO_DEMAND = (3, "暂无需求")
    EFFECT_OR_SERVICE_NOT_SATISFIED = (4, "(效果/服务)不满意")
    HANG_UP_OR_REJECT_BE_HARASSED = (5, "挂断/拒绝/被骚扰")
    MISSED = (6, "未接")
    EMPTY_NUMBER_ERROR = (7, "空号错误")


class MERCHANT_FREEZE_ACTION(Enum):
    UNFREEZE = (0, u'解冻')
    FREEZE = (1, u'冻结')


class USERCALL_EVENT_TYPE(Enum):
    """
    用户呼叫绑定事件类型
    """
    ORDER_CHECK = (1, "订单稽查")
    COMMUNICATE_RECORT = (2, "通话记录及录音")
    USER_DETAIL = (3, "用户详情")
    CALL_BACK = (4, "回拨")


class DOCTOR_BULLETIN_SHOW_AREA(Enum):
    """
    医生公告展示范围
    """
    COUNTRY = ('1', "全国展示")
    PART_CITY = ('2', "部分城市展示")
    PART_MERCHANT = ('3', "部分商户展示")


@unique
class SKIN_CONF_T_ZONE_TYPE(Enum):
    """测肤，油脂类型T区枚举"""
    LEVLE_1 = (1, '0-0.33')
    LEVLE_2 = (2, '0.34-0.66')
    LEVLE_3 = (3, '0.67-1')


@unique
class SKIN_CONF_CHIN_TYPE(Enum):
    """测肤，油脂类型下巴枚举"""
    LEVLE_1 = (1, '0-0.33')
    LEVLE_2 = (2, '0.34-0.66')
    LEVLE_3 = (3, '0.67-1')


@unique
class SKIN_CONF_CHEEK_TYPE(Enum):
    """测肤，油脂类型脸颊枚举"""
    LEVLE_1 = (1, '0-0.33')
    LEVLE_2 = (2, '0.34-0.66')
    LEVLE_3 = (3, '0.67-1')


@unique
class SKIN_CONF_HEITOU_TYPE(Enum):
    """测肤，黑头枚举"""
    NONE = (1, '无')
    LIGHT = (2, '轻度')
    MID = (3, '中度')
    HEAVY = (4, '重度')


@unique
class SKIN_CONF_MAOKONG_TYPE(Enum):
    """测肤，毛孔枚举"""
    LIGHT = (1, '细致')
    MID = (2, '较粗大')
    HEAVY = (3, '粗大')


@unique
class SKIN_CONF_ACNE_TYPE(Enum):
    """测肤，痘痘严重程度"""
    NONE = (1, '无')
    LIGHT = (2, '轻度')
    MID = (3, '中度')
    HEAVY = (4, '重度')


@unique
class SKIN_CONF_SMOOTH_TYPE(Enum):
    """测肤，光滑度"""
    LEVLE_1 = (1, '拨壳鸡蛋')
    LEVLE_2 = (2, '蛋壳')
    LEVLE_3 = (3, '蛋黄')
    LEVLE_4 = (4, '煎蛋')


@unique
class SKIN_CONF_PIGMENTAL_TYPE(Enum):
    """测肤，色素"""
    LEVLE_1 = (1, '0-0.33')
    LEVLE_2 = (2, '0.34-0.66')
    LEVLE_3 = (3, '0.67-1')


@unique
class SKIN_CONF_VASCULAR_TYPE(Enum):
    """测肤，血管"""
    LEVLE_1 = (1, '0-0.33')
    LEVLE_2 = (2, '0.34-0.66')
    LEVLE_3 = (3, '0.67-1')


@unique
class SKIN_CONF_STRUCT_TYPE(Enum):
    """测肤，结构"""
    LEVLE_1 = (1, '0-0.33')
    LEVLE_2 = (2, '0.34-0.66')
    LEVLE_3 = (3, '0.67-1')


@unique
class SKIN_CONF_COLOR_TEMP_TYPE(Enum):
    """测肤，色温"""
    LIGHT = (1, '偏冷')
    MID = (2, '中性')
    HEAVY = (3, '偏暖')


class SKIN_CONF_ACT_WRINKLE_TYPE(Enum):
    """
    测肤 法令纹状态
    """
    NONE = (1, '无')
    LIGHT = (2, '轻度')
    # MID = (3, '中度')
    HEAVY = (4, '重度')


class SKIN_CONF_EYE_BAG_TYPE(Enum):
    """
    测肤 眼袋状态
    """
    NONE = (1, '无')
    LIGHT = (2, '轻度')
    # MID = (3, '中度')
    HEAVY = (4, '重度')


@unique
class HEIDONG_DIMENSION(Enum):
    """黑洞扫脸维度配置"""
    ATTRACTION = (0, u'吸引力')
    SOLID = (1, u'立体感')
    COORDINATION = (2, u'协调性')
    VIGOUS = (3, u'元气感')


class SKIN_CONF_TYPE(Enum):
    """
    测肤配置类型
    """
    SKIN_COLOR = ('1', "肤色")
    DARK_CIRCLE = ('2', "黑眼圈")
    SMOOTH = ('3', "光滑度")
    ACNE = ('4', "痘痘")
    BLACK_HEAD_PORE = ('5', "黑头毛孔")
    OIL = ('6', "油脂")


class KS_SKIN_ALL_TYPE(Enum):
    """
    旷视测肤，部位类型
    """
    SKIN_COLOR = (1, '肤色')
    SKIN_TYPE = (2, '出油情况')
    DARK_CIRCLE = (3, "黑眼圈")
    ACNE = (4, '痘痘')
    SKIN_SPOT = (5, '斑')
    MOLE = (6, '痣')
    EYE_POUCH = (7, '眼袋')
    EYE_FINELINES = (8, '眼部细纹')
    CROWS_FEET = (9, '鱼尾纹')
    NASOLABIAL_FOLD = (10, '法令纹')
    GLABELLA_WRINKLE = (11, '眉间纹')
    FOREHEAD_WRINKLE = (12, '抬头纹')


class KS_DARK_CIRCLE_TYPE(Enum):
    """
    旷视测肤，黑眼圈
    """
    NONE = (0, '无黑眼圈')
    PIGMENT = (1, '色素型黑眼圈')
    BLOOD_VESSEL = (2, '血管型黑眼圈')
    SHADE = (3, '阴影型黑眼圈')


class KS_SKIN_TYPE(Enum):
    """
    旷视测肤，出油情况（肤质）
    """
    OILY = (0, '油性皮肤')
    DRY = (1, '干性皮肤')
    NEUTRAL = (2, '中性皮肤')
    MIXED = (3, '混合型皮肤')


class KS_BLACKHEAD_TYPE(Enum):
    """
    旷视测肤，黑头
    """
    NONE = (1, '无黑头')
    LIGHT = (2, '轻度')
    MID = (3, '中度')
    HEAVY = (4, '重度')


class KS_PORES_FOREHEAD_TYPE(Enum):
    """
    旷视测肤，前额毛孔
    """
    NOT = (0, '前额无毛孔粗大')
    HAVE = (1, '前额有毛孔粗大')


class KS_PORES_LEFT_CHEEK_TYPE(Enum):
    """
    旷视测肤，左脸颊毛孔
    """
    NOT = (0, '左脸颊无毛孔粗大')
    HAVE = (1, '左脸颊有毛孔粗大')


class KS_PORES_RIGHT_CHEEK_TYPE(Enum):
    """
    旷视测肤，右脸颊毛孔
    """
    NOT = (0, '右脸颊无毛孔粗大')
    HAVE = (1, '右脸颊有毛孔粗大')


class KS_PORES_JAW_TYPE(Enum):
    """
    旷视测肤，下巴毛孔
    """
    NOT = (0, '下巴无毛孔粗大')
    HAVE = (1, '下巴有毛孔粗大')


class KS_PORE_TYPE(Enum):
    """
    旷视测肤，毛孔
    """
    NONE = (1, '无')
    LIGHT = (2, '轻度')
    MID = (3, '中度')
    HEAVY = (4, '重度')


class KS_ACNE_TYPE(Enum):
    """
    旷视测肤，痘痘
    """
    NONE = (1, '无痘痘')
    LIGHT = (2, '轻度')
    MID = (3, '中度')
    HEAVY = (4, '重度')


class KS_EYE_POUCH_TYPE(Enum):
    """
    旷视测肤，眼袋
    """
    NOT = (0, '无眼袋')
    HAVE = (1, '有眼袋')


class KS_NASOLABIAL_FOLD_TYPE(Enum):
    """
    旷视测肤，法令纹
    """
    NOT = (0, '无法令纹')
    HAVE = (1, '有法令纹')


class KS_SKIN_COLOR(Enum):
    """
    旷视测肤，肤色
    """
    CLEAR = (0, '透白')
    FAIR = (1, '白皙')
    NATURE = (2, '自然')
    WHEAT = (3, '小麦')
    DARK = (4, '黝黑')


class KS_SKIN_SPOT_TYPE(Enum):
    """
    旷视测肤，斑
    """
    NONE = (1, '无斑')
    LIGHT = (2, '轻度')
    MID = (3, '中度')
    HEAVY = (4, '重度')


class KS_MOLE_TYPE(Enum):
    """
    旷视测肤，痣
    """
    NONE = (1, '无痣')
    LIGHT = (2, '轻度')
    MID = (3, '中度')
    HEAVY = (4, '重度')


class KS_FOREHEAD_WRINKLE_YPE(Enum):
    """
    旷视测肤，抬头纹
    """
    NOT = (0, '无抬头纹')
    HAVE = (1, '有抬头纹')


class KS_GLABELLA_WRINKLE_YPE(Enum):
    """
    旷视测肤，眉间纹
    """
    NOT = (0, '无眉间纹')
    HAVE = (1, '有眉间纹')


class KS_CROWS_FEET_YPE(Enum):
    """
    旷视测肤，鱼尾纹
    """
    NOT = (0, '无鱼尾纹')
    HAVE = (1, '有鱼尾纹')


class KS_EYE_FINELINES_YPE(Enum):
    """
    旷视测肤，眼部细纹
    """
    NOT = (0, '无眼部细纹')
    HAVE = (1, '有眼部细纹')


class SKIN_DATA_SOURCE(Enum):
    """
    测肤数据来源
    """
    YIXI = ("yixi", u"以息")
    KUANGSHI = ("kuangshi", u"旷视")
    ORDINARY = ("ordinary", u"站内普通打卡流程")


class MARK_ACTIVITY_TYPE(Enum):
    """打卡类型"""
    COMMON = ('0', '普通打卡')
    AI = ('1', 'AI打卡')


class PUSHCOUPON_USER_TYPE(Enum):
    """
    推送美券用户类型
    """
    DEFAULT = (0, '默认用户')
    MARKET = (1, '营销用户')

class SUSPENSION_WINDOW_TYPE(Enum):
    '''
    小程序悬浮窗跳转类型
    '''
    DEFAULT = (0, '微信客服')

class SECKILL_POLYMER_MODULES(Enum):
    TOOLBAR = (1, "toolbar配置")
    BUTTON = (2, "按钮区配置")


class SKU_SHOW_PRICE_TYPE(Enum):
    GENGMEI_PRICE = ('gengmei_price', '0')
    SECKILL_PRICE = ('seckill_price', '1')
    GROUPBUY_PRICE = ('groupbuy_price', '2')
    MULTIBUY_PRICE = ('multibuy_price', '3')



class SIGN_TASK_TYPE(Enum):
    BROWSE = (1, '逛商品')
    PAY_ORDER = (2, '下单')
    FRIEND_ASSIST = (3, '好友助力')
    SCAN_FACE = (4, '扫脸')
    SCAN_SKIN = (5, '测肤')
    DOWNLOAD = (6, '下载APP')
    OLD_FRIEND_ASSIST = (7, '老版本好友助力')
    SPECIAL_ITEM = (9, '逛专题 任务')
    FRIEND_ASSIST_726 = (10, '726好友助力')


class FAMOUS_DOCTOR_JOIN_TYPE(Enum):
    DOCTOR = ('0', '医生')
    HOSPITAL = ('1', '机构')

class FREER_RECRUITMENT_PUSH_TYPE(Enum):
    VOTED = (1, '好友助力')
    ACTIVITY_STARTED = (2, '活动开始')
    ACTIVITY_ENDED = (3, '活动结束')


class CONVERSATION_SOURCE(Enum):
    GENGMEI_APP = (0, '更美app')
    DOCTOR_WEB = (1, '医生后台')
    DOCTOR_APP = (2, '医生app')


class SETTLEMENT_TYPE(Enum):
    NORMAL_ORDER = (0, '正常单')
    ZERO_ORDER = (1, '零元单')

@unique
class SCAN_TYPE(Enum):
    SCAN_FACE = (1, '黑洞扫脸')
    SCAN_SKIN = (2, '测肤')
    SCAN_FACE_OLD = (3, '初版扫脸')
    FACE_RESEARCH = (4, '颜究所')
    PLASTIC = (5, '模拟整形')


class SEARCH_ACTIVITY_TYPE(Enum):
    SINGLE = (1, '单一活动')
    POLYMER = (2, '活动聚合')


class BASE_BAR_CONFIG(Enum):
    INDEX = (1, "首页")
    SERVICE = (2, "美购")
    # NEWS = (3, "消息")
    # MY = (4, "我")


class DIRECTPAYTYPE(Enum):
    WECHAT = (1, '微信')
    ALIPAY = (2, '支付宝')
    PERSON_ONLINE_PAY = (3, '个人网银')
    BUSINESS_ONLINE_PAY = (4, '企业网银')


class YIBAOPAY_STATUS(Enum):
    NOT_PAY = (0, '未支付')
    HAS_PAY = (1, '已支付')


class COUPON_USE_TYPE(Enum):
    VALID_COUPON = (0, '有效券')
    INVALID_COUPON = (1, '无效券')


class AI_TARGET_PART(Enum):
    SKIN_COLOR = ('肤色', '肤色')
    DARK_CIRCLE = ('黑眼圈', '黑眼圈')
    ACNE = ('痘痘', '痘痘')
    BLACK_HEAD = ('黑头毛孔', '黑头毛孔')
    SKIN_OIL = ('出油情况', '出油情况')
    SMOOTH = ('光滑度', '光滑度')
    EYE_BAGS = ('眼袋', '眼袋')
    WRINKLES = ('法令纹', '法令纹')


class DOCTOR_BADGES(Enum):
    """
    医生勋章
    """
    NULL = (0, "无")
    DOCTOR = (1, "金牌医生")
    HOSPITAL = (2, "金牌机构")


class BUTTON_SELECTION(Enum):
    GEOGRAPHICAL = ('0', '默认按照地理位置匹配专场地域选中按钮')
    FIRST = ('1', '默认选中第一位按钮')

class ROLE_TYPE(Enum):
    BDM = ('0', 'BDM')
    CM = ('1', 'CM')


class POLYMER_TYPE(Enum):
    SECKILL_POLYMER = (1, '秒杀聚合')
    SPECIAL_POLYMER = (2, '新专题聚合')
    RELATED_TOPIC = (3, '专题')
    VISUAL_PAGE = (4, '自定义专题页面')


class PROBLEM_TYPE(Enum):
    MULTIPLE_PLANS = (1, '有图多选')
    SELECTED_MAPS = (2, '有图单选')
    SINGLE_SELECTION = (3, '无图单选')
    MULTIPLE_SELECTION = (4, '无图多选')


class PORTRAIT_TYPE(Enum):
    INTERESTED = (1, '感兴趣')
    EXPERIENCED = (2, '有经验')


class TAG_TYPE_ATTR(Enum):

    # 一级属性
    SYMPTOM = ('1', '二级症状')
    MODE = ('2', '一级药品仪器耗材')                # 原：微观方式
    POSITION = ('3', '二级部位')
    BRAND = ('4', '二级药品仪器耗材')
    # MATERIAL = ('5', '材料')
    MACROSCOPIC_MODE = ('6', '一级方式')    # 原：宏观方式
    FIRST_APPEAL = ('7', '一级诉求')
    SECOND_APPEAL = ('8', '二级诉求')
    FIRST_SYMPTOM = ('9', '一级症状')
    FIRST_POSITION = ('10', '一级部位')
    FIRST_BRAND = ('11', '一级药品仪器耗材')

    # 子属性
    DRUG = ('50', '药品')
    INSTRUMENT = ('51', '仪器')
    CONSUMABLES = ('52', '耗材')


class SERVICE_SCREEN_LABEL(Enum):
    DEFAULT = (0, '智能筛选')  # 1:与用户同城的福利在前; 2:按展示顺序(小的在前); 3:按最后修改时间
    ORDER_HIGHEST_SALES = (4, '销量最高')  # 1:按显示销量; 2:按展示顺序; 3:按最后修改时间 # 大家都在买
    ORDER_LOWEST_PRICE = (5, '价格最低')
    ORDER_HIGHEST_PRICE = (21, '价格最高')
    CASE_COUNT = (7, '案例最多')
    DISTANCE = (12, '离我最近')
    ORDER_EVALUATE = (13, '评价最高')


class TAG_V3_TYPE(Enum):
    """
    标签3.0分类
    """
    NORMAL = (1, '普通标签')
    FIRST_CLASSIFY = (2, '一级分类')
    SECOND_CLASSIFY = (3, '二级分类')
    DOCTOR = (4, '医生')
    HOSPITAL = (5, '医院')
    EXCHANGE = (6, '交易运营')
    COMMUNITY = (7, '社区运营')
    FREE = (8, '自由添加')
    BRAND = (9, '品牌')
    TIME = (10, '时间')
    CITY = (11, '城市')
    PROVINCE = (12, '省份')
    COUNTRY = (13, '国家')

    # 一级属性
    FIRST_SYMPTOM = (14, '一级症状')
    SECOND_SYMPTOM = (15, '二级症状')

    FIRST_BRAND = (16, '一级药品仪器耗材')                # 原：微观方式
    SECOND_BRAND = (17, '二级药品仪器耗材')

    MACROSCOPIC_MODE = (18, '一级方式')    # 原：宏观方式

    FIRST_APPEAL = (19, '一级诉求')
    SECOND_APPEAL = (20, '二级诉求')

    FIRST_POSITION = (21, '一级部位')
    SECOND_POSITION = (22, '二级部位')

    # 子属性
    DRUG = (23, '药品')
    INSTRUMENT = (24, '仪器')
    CONSUMABLES = (25, '耗材')
    MATERIAL = (26, '材料')

    SUPERSTAR = (27, '明星')
    ACTIVITY= (28, '活动')



class TAG_V3_TYPE_NEW(Enum):
    """标签3.0分类。

    和属性标签类型合并
    """

    NORMAL = (1, '普通标签')
    FIRST_CLASSIFY = (2, '一级分类')
    SECOND_CLASSIFY = (3, '二级分类')
    DOCTOR = (4, '医生')
    HOSPITAL = (5, '医院')
    EXCHANGE = (6, '交易运营')
    COMMUNITY = (7, '社区运营')
    FREE = (8, '自由添加')
    BRAND = (9, '品牌')
    TIME = (10, '时间')
    CITY = (11, '城市')
    PROVINCE = (12, '省份')
    COUNTRY = (13, '国家')

    # 一级属性
    SYMPTOM = (21, '二级症状')
    MODE = (22, '一级药品仪器耗材')                # 原：微观方式
    POSITION = (23, '二级部位')
    SECOND_BRAND = (24, '二级药品仪器耗材')
    # MATERIAL = ('5', '材料')
    MACROSCOPIC_MODE = (26, '一级方式')    # 原：宏观方式
    FIRST_APPEAL = (27, '一级诉求')
    SECOND_APPEAL = (28, '二级诉求')
    FIRST_SYMPTOM = (29, '一级症状')
    FIRST_POSITION = (30, '一级部位')
    FIRST_BRAND = (31, '一级药品仪器耗材')

    # 子属性
    DRUG = (50, '药品')
    INSTRUMENT = (51, '仪器')
    CONSUMABLES = (52, '耗材')


class TAG_VERSION(Enum):
    """
    标签版本
    """
    V1 = ('0', '1.0')
    V2 = ('1', '2.0')
    V3 = ('2', '3.0')


class SERVICE_EVENT_TYPE(Enum):
    """
    美购配置相关事件类型
    """
    NEW_OLD_USER = (1, "新老用户")
    FLASH_SALE = (2, "限时抢购")

class HOME_PAGE_ICON_VERSION(Enum):
    """
    首页icon  版本
    """
    V1 = ('1', '7.23之前')
    V2 = ('2', '7.23至当前')


class TAB_OPERATE_VERSION(Enum):
    """
    首页横滑tab版本号
    """
    V1 = ('1', '7.23之前')
    V2 = ('2', '7.23至当前')


class FEED_OPERATE_VERSION(Enum):
    """
    首页feeds插入版本号
    """
    V1 = ('1', '7.23之前')
    V2 = ('2', '7.23至当前')


class GADGET_VERSION(Enum):
    """
    首页固定模块  版本
    """
    V1 = ('1', '7.23之前')
    V2 = ('2', '7.23至当前')


class FUNCTION_VERSION(Enum):
    """首页入口功能区版本。"""

    V1 = ('1', '7.28之前')
    V2 = ('2', '7.28及之后')


class SLIDE_VERSION(Enum):
    """
    首页轮播图  版本
    """
    V1 = ('1', '7.23之前')
    V2 = ('2', '7.23至当前')


class FESTIVAL_HOMEPAGE_ICON_VERSION(Enum):
    """
    首页节日特殊展示  版本
    """
    V1 = ('1', '7.23之前')
    V2 = ('2', '7.23至当前')

class TRANSACTION_TYPE(Enum):
    '''
    埋点要使用到的枚举
    '''
    community = ('community', '社区')
    operating = ('operating', ' 运营（交易）')
    advertise = ('advertise', ' 广告')
    supply = ('supply', ' 补位')
    doris = (' -1', '自然排序（策略）')


class TAG_RELATED_WIKI_TYPE(Enum):
    """
    标签关联 百科类型
    """
    ITEM = ('1', '项目百科')
    BRAND = ('2', '品牌百科')
    PRODUCT = ('3', '物品百科(药品、仪器、材料)')

class TOPRANK_TYPE(Enum):
    '''
    榜单类型
    '''
    doctor = ('doctor', '医生')
    hospital = ('hospital', '医院')


@unique
class PUNISHMENT_RANGE(Enum):
    PART = (0, '部分')
    ALL = (1, '全部')


@unique
class PUNISHMENT_FACTOR_TARGET(Enum):
    SERVICE = 'service', '美购'
    DIARY = 'diary', '日记本'


class QUESTIONNAIRE_ANSWER_TRYE(Enum):
    """
    kyc 答案类型
    """
    ANSWER = (1, '答案')
    SUB_ANSWER = (2, '子答案')


class FEED_TAB_TYPE(Enum):
    """
    feed tab类型
    """
    APPEAL = (1, '诉求tab')
    FACESTYLE = (2, '风格脸tab')


class PLASTICFACESTYLE(Enum):
    """
    模拟整形风格脸
    """
    CHULIAN = (1, '初恋脸')
    GUDIAN = (2, '古典脸')
    HUANXI = (3, '韩系脸')
    RIXI = (4, '日系脸')
    WUMEI = (5, '妩媚脸')
    XIAOLU = (6, '小鹿脸')
    YOUCHI = (7, '幼齿脸')
    ZHIXING = (8, '知性脸')
    STANDARD = (9, '标致脸')


class PLASTICFACEDIM(Enum):
    """
    模拟整形面部维度
    """
    ZHONGXIATINGBI = ('zhongxiatingbi', '中下庭比')
    YOUYANLIUBAIBI = ('youyanliubaibi', '右外眼角颧弓留白宽度/ 右眼睛')
    NEIYANJIANJUBI = ('neiyanjianjubi', '内眼角间距长度/右眼睛宽度')
    NIEBUQUANKUAN = ('niebuquankuan', '颞部颧宽比')
    QUANGONGXIAHEJIAO = ('quangongxiahejiao', '颧弓下颌角比')
    RENZHONGXIABA = ('renzhongxiaba', '人中下巴比')
    XIABAJIAODU = ('xiabajiaodu', '下巴角度')
    YANJINGCHANGKUAN = ('yanjingchangkuan', '眼睛长宽比')
    NEIYANJIAODU = ('neiyanjiaodu', '内眼角度数')
    MEITOUMEIFENG = ('meitoumeifeng', '眉头与眉峰角度')
    MEIMAOCHANGKUNAG = ('meimaochangkunag', '眉毛长宽比')
    TONGJUBIYIKUANGBI = ('tongjubiyikuangbi', '瞳距鼻翼宽比')
    RENZHONGZUICHUNBI = ('renzhongzuichunbi', '人中嘴唇比')
    ZUICHUNXIABABI = ('zuichunxiababi', '嘴唇下巴比')
    ZUICHUNCHANGKUANBI = ('zuichunchangkuanbi', '嘴唇长宽比')
    SHUANGCXIAN = ('shuangcxian', '双C线角度')
    YANJINGTIAODU = ('yanjingtiaodu', '眼睛挑度')
    HAIOUXIAN = ('haiouxian', '海鸥线')
    ZUIJIAOSHANGYANG = ('zuijiaoshangyang', '嘴角上扬')
    GOLDENTRIANGLE = ('goldentriangle', '黄金三角')
    HEIYANQUAN = ('heiyanquan', '黑眼圈')
    FALINGWEN = ('falingwen', '法令纹')
    LIANXING = ('lianxing', '脸型')
    MEIYANJIANJUYANGAOBI = ('meiyanjianjuyangaobi', '眉眼间距与眼高比')
    BIYIYANJUBI = ('biyiyanjubi', '鼻翼眼距比')
    TONGNEIJUZUIKUANBI = ('tongneijuzuikuanbi', '瞳内距与嘴宽比')
    ZUIJIAOXIAHEJIAOCHA = ('zuijiaoxiahejiaocha', '嘴角与下颌角的高低差值')
    NEIWAIYANJIAOXIEDU = ('neiwaiyanjiaoxiedu', '内外眼角倾斜度')
    TONGJUSHANGENBI = ('tongjushangenbi', '瞳距山根宽比')
    SHANGXIACHUNHOUBI = ('shangxiachunhoubi', '上下唇厚度比')


class PLASTICFACEDIMMETA(Enum):
    """
    模拟整形面部维度元数据
    """
    ZHONGTINGCHANG = ('zhongtingchang', '中庭长度')
    XIATINGCHANG = ('xiatingchang', '下庭长度')
    YOUWAIYANLIIUBAI = ('youwaiyanliiubai', '右外眼角颧弓留白宽度')
    YOUYANKUAN = ('youyankuan', '右眼宽度')
    NEIYANJIAOJIANJU = ('neiyanjiaojianju', '内眼角间距长度')
    NEIGUKUAN = ('neigukuan', '颞骨宽度')
    QUANGUKUAN = ('quangukuan', '颧骨宽度')
    XIAHEJIAOKUAN = ('xiahejiaokuan', '下颌角宽度')
    RENZHONGCHANG = ('renzhongchang', '人中长度')
    XIABACHANG = ('xiabachang', '下巴长度')
    YANJINGGAO = ('yanjinggao', '眼睛高度')
    YANJINGKUAN = ('yanjingkuan', '眼睛宽度')
    MEIMAOGAO = ('meimaogao', '眉毛高度')
    MEIMAOKUAN = ('meimaokuan', '眉毛宽度')
    TONGJUKUAN = ('tongjukuan', '瞳距宽度')
    BIYIKUAN = ('biyikuan', '鼻翼宽')
    ZUICHUNGAO = ('zuichungao', '嘴唇高度')
    ZUICHUNKUAN = ('zuichunkuan', '嘴唇宽度')
    MEIYANJIANJU = ('meiyanjianju', '眉眼间距')
    YANZONGXIANGGAO = ('yanzongxianggao', '眼纵向高')
    TONGRENJULI = ('tongrenjuli', '瞳仁距离')
    ZUIJIAOXIAHEJIAOCHA = ('zuijiaoxiahejiaocha', '嘴角与下颌角的高低差值')
    SHANGEN = ('shangen', '山根')
    SHANGCHUNHOU = ('shangchunhou', '上唇厚')
    XIACHUNHOU = ('shangchunhou', '下唇厚')


class PLASTICFACESWORD(Enum):
    """
    模拟整形面部风格词
    """
    BAIFUMEi = (1, '白富美脸')
    QIANGYAGUDIAN = (2, '清雅古典脸')
    ZHUYUSHAONV = (3, '治愈少女脸')
    WENYAZHIHUI = (4, '文雅智慧脸')
    WENROUHANXI = (5, '温柔韩系脸')
    YOUYAZHIXING = (6, '优雅知性脸')
    LENGYANGUIQI = (7, '冷艳贵气脸')
    YINGYAHANFENG = (8, '清雅韩风脸')
    JILINGYOUYA = (9, '机灵优雅脸')
    LENGYANGUDIAN = (10, '冷艳古典脸')
    QINGTIANSHAONV = (11, '轻甜少女脸')
    GUOZHISHAONV = (12, '果汁少女脸')
    NIUYOUGUOSHAONV = (13, '牛油果少女')
    TAIDUSHAONV = (14, '态度少女脸')
    TIANJIUSHAONV = (15, '甜酒少女脸')
    WENYIYOUYA = (16, '文艺优雅脸')
    GAOLENGQICHANG = (17, '高冷气场脸')
    WENYIJIAOROU = (18, '文艺娇柔脸')
    GUGANLINGDONG = (19, '骨感灵动脸')
    YANXIYINGQI = (20, '盐系英气脸')
    MINGYANJIAOMEI = (21, '明艳娇媚脸')
    XIANTIAN = (22, '仙甜脸')
    LINGQIQINGTIAN = (23, '灵气清甜脸')
    LINGQICONGHUI = (24, '灵气聪慧脸')
    TIANXIANQICHANG = (25, '天仙气场脸')
    YINGQIMEIGUI = (26, '英气玫瑰脸')
    FENWEIMEIREN = (27, '氛围美人脸')
    QINGLENGTAIDU = (28, '清冷态度脸')
    QINGYANQICHANG = (29, '轻盐气场脸')
    YANXICHAOMUO = (30, '盐系超模脸')



class POPUP_CATEGORY(Enum):
    """
    弹窗分类
    """
    CONSULT = (1, '视频面诊')


class QUESTIONNAIRE_ANSWER_TAG_TYPE(Enum):
    """
    kyc 答案关联标签类型
    """
    NORMAL = (1, '普通标签')
    KYC = (2, 'KYC用户标签')


class AppConfigValueType(Enum):
    """
    应用配置 内容类型
    """
    TYPE_STRING = (1, '字符串')
    TYPE_INTER = (2, '整形')
    TYPE_FLOAT = (3, '浮点型')
    TYPE_DICT = (4, '字典')
    TYPE_LIST = (5, '列表')
    TYPE_JSON = (6, 'JSON')


class SEARCH_GUIDE_PAGE(Enum):
    """
    搜索关键词落地页功能
    """
    AI = (1, 'AI功能')


class GM_PROTOCOL_JUMP_SOURCE(Enum):
    """
    用于区分更美协议跳转来源
    """
    NORMAL = ("normal", "普通，正常跳转")
    KYC_PUSH = ("kyc_push", "kyc流程相关推送")


class FRIEND_ASSIST_STATUS(Enum):
    """
    好友助力状态
    """
    CAN_ASSIST = (1, "能助力")
    CAN_NOT_ASSIST = (2, "不能助力")


class BLOOD_TYPE(Enum):
    """血型"""

    NONE = ('0', "未知")
    A = ('1', "A型")
    B = ('2', "B型")
    AB = ('3', "AB型")
    O = ('4', "O型")


class GMHOME_JUMP_TUPE(Enum):
    """
    功能入口配置跳转类型
    """
    URL = (1, '网页链接')
    VISUAL_PAGE = (2, '自定义专题页面')


class CommodityCategoryProperty(Enum):
    """
    商品类目属性
    """
    POSITON = (1, '部位')
    INSTRUMENT = (2, '仪器')
    MATERIALS = (3, '材料')
    MEASURE = (4, '计量')
    CUSTOM = (5, '自定义')


class Event_Type(Enum):
    """
    专题类型
    """
    Special = ('ZhuanTi', '专题')
    Promotion = ('CuXiaoHuoDong', '促销活动')
    Other = ('QiTa', '其他')


class AddValueOrderStatus(Enum):
    """
    增值广告订单状态
    """
    HAS_PAID = (0, u'已支付')
    DOWN = (1, u'已完成')


class Blind_Box_Prize_Type(Enum):
    """
    盲盒奖品类型
    """
    Physical = (1, '实物')
    Coupon = (2, '美券')


class TOP_CONTENT_RELATED_TYPE(Enum):
    """
    置顶内容关联类型
    """
    GROUP = (1, u'小组')
    TOPIC = (2, u'话题')


class GROUP_TOPIC_TYPE(Enum):
    """
    小组话题类型
    """
    COMMON = (1, u'普通')
    VARIETY_SHOW_YOUNG = (2, u'打榜活动(少年之名)')


class TASK_CATEGORY(Enum):
    """
    任务类型
    """
    YOUNG_HIT = ("young_hit", u'少年之名打榜')


class YOUNG_HIT_TASK_TYPE(Enum):
    """
    少年之名打榜任务类型
    """
    NEW_SPECIAL = (1, u'新人专场')
    INVITE_USER_REGISTER = (2, u'邀请新用户注册')
    DAILY_LOGIN = (3, '每日初次开启App')
    GROUP_BY = (4, '拼团')


class VISIT_METHOD(Enum):
    """
    转诊线索回访形式
    """
    WECHAT = (0, '微信')
    PHONE = (1, '电话')


class VISIT_TYPE(Enum):
    """
    转诊线索回访类型
    """
    INTENTIONAL_NEED = (0, '意向需求')
    SATISFACTION_SURVEY = (1, '满意度调查')
    VERIFY_CONSUMPTION = (2, '核实消费')


class BD_SERVICE_TYPE(Enum):
    '''
    回访列表任务状态
    '''
    TOBEDONE = (1, "未执行")
    FINISHED = (2, "已执行")
    OVERDUE = (3, "已逾期")
    INVALID = (4, "已失效")


class SEAL_ITEM_TYPE(Enum):
    '''
    对用户的一个或多个功能进行封禁，

    以下为封禁功能类型，

    目前根据需求确定的有面诊和私信，

    后续可能还会添加新类型

    全部功能 0

    面诊 1

    私信 2
    '''
    SEAL_ITEM_ALL = (0, "全部功能")
    SEAL_ITEM_FACE_CONSULTATION = (1, "面诊")
    SEAL_ITEM_PRIVATE_MSG = (2, "私信")


class SEAL_TIME_TYPE(Enum):
    '''
    针对某个用户封禁某项功能的时长类型，永久和临时

    永久封禁 0

    临时封禁 1
    '''
    SEAL_TIME_FOREVER = (0, "永久封禁")
    SEAL_TIME_TEMPORARY = (1, "临时封禁")


class SEAL_OPEARTION_TYPE(Enum):
    '''
    封禁操作的类型

    全部封禁类型 0

    人工手动封禁 1

    系统自动封禁 2
    '''
    SEAL_ALL = (0, "全部封禁类型")
    SEAL_MANUAL = (1, "人工封禁")
    SEAL_SYSTEM_AUTO = (2, "系统封禁")


class SEAL_STATUS(Enum):
    '''
    用户的某项功能当前的封禁状态

    全部封禁状态 0

    封禁中 1

    已解封 2
    '''
    SEAL_STATUS_ALL = (0, "全部封禁状态")
    SEAL_STATUS_BAN = (1, "封禁中")
    SEAL_STATUS_UNBAN = (2, "已解封")


class CANCEL_SEAL_TYPE(Enum):
    '''
    解除封禁操作的类型

    全部解除封禁类型 0

    人工手动提前解除 1

    系统到期自动解除 2
    '''

    CANCEL_SEAL_ALL = (0, "全部解封类型")
    CANCEL_SEAL_MANUAL = (1, "人工解封")
    CANCEL_SEAL_SYSTEM_AUTO = (2, "系统解封")


class AI_QA_QUESTION_TYPE(Enum):

    BUTTON = (0, "按钮类型")
    LIST = (1, "列表类型")


class AI_QA_NEXT_TYPE(Enum):

    AI_QUESTION = (0, "AI问题")
    RECOMMEND_CARD = (1, "推荐卡片")


class AI_QA_MESSAGE_TYPE(Enum):
    """消息来源类型"""

    BUTTON = (0, "按钮类型")
    LIST = (1, "列表类型")
    QUESTION_GROUP = (3, "问题组")
    RECOMMEND_CARD = (4, "推荐卡片")
    FIRST_WEICOME = (5, '首次开始欢迎语')
    REDO_WEICOME = (6, '重新开始欢迎语')
    QUESTION_GROUP_WELCOME = (7, '问题组引导语')
    RECO_CARD_WELCOME = (8, '推荐卡片引导语')
    CONCLUSION = (9, '意外退出结束语')

class BWC_ORDER_NOTIFY_METHOD(Enum):
    """霸王餐订单推送策略"""
    PAID_AFTER_THREE_DAY = (1, "策略1支付后第三天")
    FRIDAY = (2, "策略2周五")