# -*- coding: utf-8 -*-
"""
Created on Wed May  9 11:31:40 2018

@author: hanye
"""

import logging
from func_build_maintainance_index import build_maintainance_index
import datetime

def update_maintenance_data(days_from_running=2):
    today=datetime.datetime.now()
    previous_day=today-datetime.timedelta(days=days_from_running)
    fetch_year=previous_day.year
    fetch_month=previous_day.month
    fetch_day=previous_day.day
    # define logger
    logger=logging.getLogger('maintainance_build_manual')
    logger.setLevel(logging.DEBUG)
    # create handler
    path='/home/hanye/project_data/Python/Projects/proj-short-videos/write-data-into-es/log/'
    log_fn='build_maintainance_for_%s_single_day_log' % (previous_day.isoformat()[:10])
    fh=logging.FileHandler(path+log_fn)
    fh.setLevel(logging.INFO)
    # create formatter and add it to the handler
    formatter=logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
    fh.setFormatter(formatter)
    # add handler to logger
    logger.addHandler(fh)
    logger.info('log starts')
    
    build_maintainance_index(fetch_year, fetch_month, fetch_day)
    logger.info('All done.')
    
    