# -*- coding: utf-8 -*-
"""
Created on Thu Feb 21 09:39:17 2019

@author: zhouyujiang

查找 关键词 并发送邮件
"""
import datetime
import argparse
from func_search_keyword_write_into_csv import select_key_word_data
from func_send_email_with_file import send_file_email
import task_stats

parser = argparse.ArgumentParser(description=('''func select key_word list write 
                                                  into csv, and send email'''))

parser.add_argument('-d', '--data_str',help=('like 2019-02-21'),
                    default=None)
args = parser.parse_args()

def send_email_shiyebu(time_start_str, data_str):
    task_start_ts = int(datetime.datetime.now().timestamp()*1e3)
    task_stats.record_task_stats(
    task_name='send_email_about_key-word_to_shiyebu',
    program_file_name='send_key_word_data_to_shiyebu_daily_task.py',
    task_freq='daily',
    start_time=task_start_ts,
    time_of_processed_data=task_start_ts,
    with_task_description=False
    )
    

    #查找关键词数据存入csv

    file_path = select_key_word_data(date_str=data_str, time_start_str=time_start_str)
    print(file_path)
    #发送邮件
    email_group = ['zhouyujiang@csm.com.cn']
    cc_group = ['zhouyujiang@csm.com.cn']
    send_file_email(file_path=file_path, data_str=data_str,
                    email_group=email_group,
                    cc_group=cc_group
                    )
    
    task_end_ts = int(datetime.datetime.now().timestamp()*1e3)
    task_stats.record_task_stats(
    task_name='send_email_about_key-word_to_shiyebu',
    program_file_name='send_key_word_data_to_shiyebu_daily_task.py',
    task_freq='daily',
    start_time=task_start_ts,
    time_of_processed_data=task_start_ts,
    end_time=task_end_ts,
    is_done=True,
    task_stats='Done',
    with_task_description=False
    )
    

if __name__ == '__main__':
    if args.data_str is None:
        data_str = str(datetime.datetime.now()-datetime.timedelta(1))[0:10]
    else:
        data_str = args.data_str
    time_start_str = '2019-2-19'
    send_email_shiyebu(time_start_str=time_start_str , data_str=data_str)

    