# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


class RM_EDUCATION(Enum):
    JUNIOR_OR_UNDER = (3, '初中及以下')
    SENIOR = (4, '高中')
    SECONDARY = (5, '中专')
    SPECIALTY = (6, '专科')
    BECHELOR = (7, '本科')
    MASTER = (8, '硕士研究生')
    DOCTOR = (10, '博士研究生')


class RM_MARRIAGE(Enum):
    UNMARRIED = (0, '未婚')
    MARRIED = (1, '已婚')
    DIVORCED = (2, '离异')
    WIDOWED = (3, '丧偶')


class RM_CHILDRED(Enum):
    NONE = (0, '无子女')
    ONE = (1, '一个子女')
    TWO = (2, '2个子女及以上')


class RM_HOUSE(Enum):
    NONE = (0, '无房')
    MORTGAGE = (1, '有房有按揭')
    NO_MORTGAGE = (2, '有房无按揭')


class RM_IDENTITY_TYPE(Enum):
    WORKER = (0, '上班族')
    STUDENT = (1, '学生')


class IDENTITY_TYPE(Enum):
    WORKER = (0, '上班族')
    STUDENT = (1, '学生')
    INDIVADUAL = (3, '个体经营者')
    FREELANCE = (4, '自由职业者')
    OTHER = (5, '其他')


class RM_RELATIONSHIP(Enum):
    COLLEAGUE = (0, '同事')
    FATHER = (1, '父亲')
    MOTHER = (2, '母亲')
    CHILDREN = (3, '子女')
    SPOUSE = (4, '配偶')
    SIBLING = (5, '亲兄弟姐妹')


class RM_STUDENT_FIRST(Enum):
    FATHER = (1, '父亲')
    MOTHER = (2, '母亲')


class RM_STUDENT_SECOND(Enum):
    FATHER = (1, '父亲')
    MOTHER = (2, '母亲')
    CHILDREN = (3, '子女')
    SPOUSE = (4, '配偶')
    SIBLING = (5, '亲兄弟姐妹')


class RM_STUDENT_THIRD(Enum):
    COLLEAGUE = (0, '同学')


class RM_WORKER_FIRST(Enum):
    FATHER = (1, '父亲')
    MOTHER = (2, '母亲')
    CHILDREN = (3, '子女')
    SPOUSE = (4, '配偶')
    SIBLING = (5, '亲兄弟姐妹')


class RM_WORKER_SECOND(Enum):
    FATHER = (1, '父亲')
    MOTHER = (2, '母亲')
    CHILDREN = (3, '子女')
    SPOUSE = (4, '配偶')
    SIBLING = (5, '亲兄弟姐妹')


class RM_WORKER_THIRD(Enum):
    COLLEAGUE = (0, '同事')


class RM_CREDIT_FIRST_SECOND(Enum):
    FATHER = (1, '父亲')
    MOTHER = (2, '母亲')
    CHILDREN = (3, '子女')
    SPOUSE = (4, '配偶')
    SIBLING = (5, '亲兄弟姐妹')


class RM_CREDIT_THIRD(Enum):
    FATHER = (0, '同事')
    MOTHER = (7, '同学')
    CHILDREN = (8, '朋友')
    SPOUSE = (9, '非直系亲属')


class RM_IMAGE_TYPE(Enum):
    FRONT = (0, '身份证正面照')
    BACK = (1, '身份证背面照')
    HAND = (2, '手持身份证照片')


class RM_STATUS(Enum):
    NONE = (0, '无用，默认')
    AUDITING = (1, '审核中')
    GRANT = (2, '审核通过')
    REJECT = (3, '分期失败')
    REPAY = (4, '还款')
    REFUND = (5, '用户放弃')
    CANCEL = (6, '已取消')      # 任买单方面取消
    LOANING = (7, '放款中')
    FINISH = (13, '完结')
    OUT = (14, '超时')


class PARSE_STATUS(Enum):
    SUCCESS = (1, '解析成功')
    PARSING = (2, '解析中')
    FAIL = (3, '解析失败')


class RM_GRAB(Enum):
    PHONE = (1, '手机运营商')
    BANK_BILL = (2, '银行流水')
    CREDIT_EMAIL = (3, '信用卡邮箱')
    CREDIT_REPORT = (4, '征信报告')


class RM_CERT_STATUS(Enum):
    NOT = (1, '未认证')
    ING = (2, '认证中')
    DONE = (3, '已认证')
