# -*- coding: utf-8 -*-
"""
Created on Mon Nov 27 12:53:53 2017

@author: hanye
"""

import datetime
import task_stats
from func_monthly_aggregated_daily_url_for_one_fetch_day import monthly_aggregated_daily_url_for_one_fetch_day
import argparse

parser = argparse.ArgumentParser(description=('You can specify a date to calculate.'))
parser.add_argument('-f', '--target_fetch_day',
                    help=('Must in isoformat, similar to "2018-06-07". Other '
                          'format will just be ignored.'))
args = parser.parse_args()

if args.target_fetch_day!=None:
    try:
        target_fetch_day_T = datetime.datetime.strptime(args.target_fetch_day,
                                                        '%Y-%m-%d')
    except:
        print('Ill format for parameter -t: %s, should be in isoformat, '
              'similar to "2018-06-07". The input parameter is ignored, '
              'will continue to run with default parameters. Ctrl-C to '
              'interrupt or just kill -9 pid.' % args.target_fetch_day)
        target_fetch_day_T = None
else:
    target_fetch_day_T = None

if target_fetch_day_T!=None:
    dayT_of_proc_data = target_fetch_day_T
else:
    dayT_of_proc_data = datetime.datetime.now()-datetime.timedelta(days=2)

year=dayT_of_proc_data.year
month=dayT_of_proc_data.month
day=dayT_of_proc_data.day

day_str = dayT_of_proc_data.isoformat()[:10]

log_path='/home/hanye/project_data/Python/Projects/proj-short-videos/write-data-into-es/log/'
log_fn='update_monthly_daily-url_for_%s_at_%s' % (day_str, datetime.datetime.now().isoformat()[:19].replace(':','-'))
f_log = open(log_path+log_fn, 'a', encoding='gb18030')
pre_task_names = {
    'write_qingbo_TK_ATU_data_from_ftp_daily_task':
        {'days_str_of_proc_data': day_str},
    'write_fh_data_from_ftp_call_func_daily_task00':
        {'days_str_of_proc_data': day_str},
    }
print(pre_task_names)
time_of_processed_data_T = dayT_of_proc_data
task_stats.wait_for_pre_task_to_cal(
        pre_task_names,
        loggerName=None, f_log=f_log,
        cal_func=monthly_aggregated_daily_url_for_one_fetch_day,
        cal_func_params=(year, month, day, 5),
        task_name='monthly_aggs_daily_url_daily_task_call_func',
        program_file_name='monthly_aggs_daily_url_daily_task_call_func.py',
        task_freq='daily',
        time_of_processed_data_T=time_of_processed_data_T
        )

print('All done', datetime.datetime.now(), file=f_log)

f_log.close()

#ts=datetime.datetime.now()
#monthly_aggregated_daily_url_for_one_fetch_day(year, month, day, threads_num=5)
#te=datetime.datetime.now()
#t_delta=te-ts
#
#log_path='/home/hanye/project_data/Python/Projects/proj-short-videos/write-data-into-es/log/'
#log_fn='update_monthly_daily-url_'+'_'+datetime.datetime.now().isoformat().replace(':','-')
#with open(log_path+log_fn, 'a', encoding='gb18030') as f_log:
#    print('short_video_monthly_aggregated_daily_url_for',dayT_of_proc_data,
#          'done, time spent', t_delta, file=f_log)

