# -*- coding: utf-8 -*-
"""
Created on Tue Jul  3 15:12:09 2018

@author: hanye
"""

import hashlib

def calculate_kwai_video_id_by_data(kwai_video_dict):
    try:
        title = kwai_video_dict['title']
        title_c = title.replace(' ', '').replace('\r', '').replace('\n', '').replace('\t', '')
        releaser = kwai_video_dict['releaser']
        release_time_ts = kwai_video_dict['release_time']
        kwai_key = title_c + '_' + releaser + '_' + str(release_time_ts)
        key_hash = hashlib.md5(kwai_key.encode('utf-8')).hexdigest()
        vid = key_hash
    except:
        try:
            kwai_key = kwai_video_dict['url']
            vid = kwai_key
        except:
            vid = None

    return vid
