# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum, unique


class STRATEGY_TYPE(Enum):
    SERVICE_SEARCH = ('service_search', '搜索智能排序')
    DOCTOR_ORDER = ('doctor_order', '医生机构智能排序')


class INTERPOSE_TYPE(Enum):
    SERVICE_SEARCH = ('service_search', '美购搜索')
    SERVICE_FILTER = ('service_filter', '美购过滤')
    DOCTOR_SEARCH = ('doctor_search', '专家搜索')
    OFFICER_SEARCH = ('officer_search', '机构管理者(医院)搜索')
    DIARY_FILTER = ('diary_filter', '日记本过滤')
    DIARY_SEARCH = ('diary_search', '日记本搜索')
    DOCTOR_FILTER = ('doctor_filter', '专家过滤')
    OFFICER_FILTER = ('officer_filter', '机构过滤')


class Verb(Enum):
    USER_CREATE = ('user_craete', '创建用户')
    DIARY_CREATE = ('diary_create', '添加日记')
    DIARY_REPLY = ('diary_reply', '评论日记')
    QUESTION_ASK = ('question_ask', '提问')
    QUESTION_ANSWER = ('quetion_answer', '回答问题')


class PUSH_EVENT_TYPE(Enum):
    SEARCH = ('search', "搜索")
    EXPLORE_TOPIC = ("explore_topic", "看贴")
    EXPLORE_SERVICE = ("explore_service", "看美购")
    CONVERSATION = ("send_message", "私信")


class CARD_TYPE(Enum):
    DIARY = ('diary', '日记本')
    QUESTION = ('question', '问答贴')
    ANSWER = ("answer", '回答贴')
    ARTICLE = ("article", "专栏贴")
    USERTOPIC = ("usertopic", '用户帖子')
    DOCTORTOPIC = ('doctortopic', '医生帖子')
    ENCYCLOPEDIA = ('encyclopedia', '百科')
    ICON = ('icon', '首页图标')
    QA = ('qa', '问答')
    GROUP = ("group", "小组")
    GUESS = ("guess", "猜你喜欢")
    GROUPTOPIC = ("grouptopic", "小组话题")
    SINGLE_GROUP = ("single_group", "单个小组")
    SINGLE_TOPIC = ("group_topic", "单个话题")


class ARTICLE_SORT_TYPE(Enum):
    DEFAULT = ("0", "默认排序")
    RECOMMEND = ('1', "推荐")


class ANSWER_SORT_TYPE(Enum):
    DEFAULT = ("0", "默认排序")
    RECOMMEND = ('1', "推荐")
    LASTEST_CREATE = ('2', "回答最新创建在前")


class RANK_MODE(Enum):
    DEFAULT = ("0", "默认")
    CPC = ("1", "CPC模式")


class MIND_TYPE(Enum):
    UNKNOWN = ("unknown", "未知")
    USER = ("user", "用户")
    AREA = ("area", "地区")
    DOCTOR = ("doctor", "医生")
    HOSPITAL = ("hospital", "医院")
    BRAND = ("brand", "品牌")
    PROJECT = ("project", "项目")
    FACE = ("face", "魔镜")
    FREE_FACE = ("free_face", "免费整形")


class CONTENT_AGGRE_SORT(Enum):
    DEFAULT = ("0", "默认排序")
    LASTEST_CREATE = ('1', "最新")
    HOT = ('2', "热度")
    AI_LOOK_FACE = ("3", "AI看脸")


class CONTENT_AGGRE_CARD_TYPE(Enum):
    DIARY = (1, "日记")
    TRACTATE = (2, "帖子")
    QA = (3, "问答")
    ANSWER = (4, "回答")
    ARTICLE = (5, "专栏")


class SEARCH_CONTENT_CARD_TYPE(Enum):
    HOSPITAL = (1, "医院")
    DOCTOR = (2, "医生")
    TAG = (3, "标签")


class KYC_USER_PORTRAIT_TAG_ATTR(Enum):
    INTEREST_TAG = (1, '兴趣标签')
    EXPERIENCE_TAG = (2, '经验标签')


class FEED_MERFE_DATA_TYPE(Enum):
    SAMECITY_CTR = ("samecity_ctr", "同城优先CTR预估")
    SAMECITY_CVR = ("samecity_cvr", "同城优先CVR预估")
    CTR = ("ctr", "CTR预估")
    CVR = ("cvr", "CVR预估")
    CTCVR = ("ctcvr", "CTRCVR预估")
    CPC = ("cpc", "CPC推荐")
    SMR = ("smr", "smart_rank排序")
    NEWDATA = ("newdata", "保量内容")
    PGC = ("pgc", "新人冷启动")
    HOTSPOT_FEED = ("hotspot_feed", "首页feed全推热点数据")
    HOTSPOT = ("hotspot", "热点数据")


class QUERY_COMPRE_CONTENT_TYPE(Enum):
    ANSWER = (1, "回答")
    DIARY = (2, "日记")
    TRACTATE = (3, "帖子")
    QA = (4, "问题")
    ARTICLE = (5, "专栏")
