# -*- coding: utf-8 -*-
""" 商家-线索通相关枚举 """
from gm_types.utils.enum import Enum


class SALES_LEAD_NOTI_TYPE(Enum):
    """ 线索通站内授权通知类型 """

    HOSPITAL_PHONE_AUTHORIZE = (1, '机构电话授权')


class VP_AVAILABLE_STATUS(Enum):
    """ 可用状态 """
    AVAILABLE = (1, "可用")
    UNAVAILABLE = (2, "不可用")


class VP_UNBIND_REASON(Enum):
    """ 解绑原因. """

    EXPIRE = (1, "过期解绑")
    BAD = (2, "号码异常解绑")


class VP_TALK_MODE(Enum):
    """ 通话模式. """

    AXB = (1, "AXB")
    XB = (2, "XB")
    AXN = (3, "AXN")


class VP_PLATFORM(Enum):

    TENCENT = ("TENCENT", "腾讯云")
    HUAWEI = ("HUAWEI", "华为云")
    ALIYUN = ("ALIYUN", '阿里云')


class VP_UNAVAILABLE_REASON(Enum):
    """ 虚拟号码不可用原因. """

    REF_NUM_FULLED = (1, "绑定已满")


class VP_NPP_CALL_END_STATUS(Enum):
    """ 腾讯云 呼叫最后状态 """

    SUCCESS = (1, "通话成功")
    BUSSY = (2, "被叫忙")
    NO_ANSWER = (3, "被叫无应答")
    REFUSED = (4, "被叫拒接")
    HANG_UP = (5, "主叫提前挂机")
    SPACE_NUMBER = (6, "空号")
    CLOSED = (7, "关机")
    TEMPORY_CANT_ANSWER = (8, "暂时无法接听")
    SUSPEND = (9, "停机")
    NO_BOUND = (12, "无绑定关系")
    NETWORK_LIMIT = (15, "网络限制")
    OTHER_FAILED = (16, "其他失败情形")
    NO_RIGHT = (17, "无权呼叫")


class SALES_LEAD_TRIGGLE_TYPE(Enum):
    """ 线索触发类型. """

    PRIVATE_DOMAIN_MESSAGE = (1, '私域私信线索触发')
    PUBLIC_DOMAIN_MESSAGE = (2, '公域私信线索触发')
    PRIVATE_DOMAIN_PHONE_AUTHORIZE = (3, '私域电话线索触发')
    PUBLIC_DOMAIN_PHONE_AUTHORIZE = (4, '公域电话线索触发')


class USER_ACTION_TYPE(Enum):
    """ 用户触发行为 """
    USER_FIRST_MESSAGE = (1, '用户首次私信商家')
    MESSAGE_QUESTION = (2, '用户私信提问')
    CORE_PAGE_STAY_LONG = (3, '核心页面停留超过时长')
    CORE_PAGE_SKIP = (4, '核心页面间跳转浏览')
    PLAN_DOCTOR_NEGOTIATED_PRICE = (5, '方案库医生商议议价')
    PLAN_HOSPITAL_NEGOTIATED_PRICE = (6, '方案库医院商议议价')
    PLAN_PLAN_NEGOTIATED_PRICE = (7, '方案库方案商议议价')
    CONSULT_APPOINTMENT = (8, '面诊预约卡')


class USER_ACTION_TRIGGLE_STATUS(Enum):
    """ 用户行为触发返回结果状态 """

    PENDING = (0, '触发线索任务处理中')
    FAILED = (1, '触发线索任务失败')
    SUCCESS = (2, '触发线索任务成功')


class LEAD_TASK_SOURCE(Enum):
    """ 线索任务来源 """

    MESSAGE = (1, '私信用户')
    PHONE = (2, '用户行为电话授权')
    PROACTIVE = (3, '主动私信')


class LEAD_PHONE_AUTHORIZE_TYPE(Enum):
    """ 电话授权来源页面 """

    SERVICE_HOME_PAGE = (1, '商品详情页停留/跳转')
    HOSPITAL_HOME_PAGE = (2, '机构主页停留/跳转')
    DOCTOR_HOME_PAGE = (3, '医生主页停留/跳转')
    DIARY_HOME_PAGE = (4, '日记详情页停留/跳转')
    PLAN_DOCTOR_NEGOTIATED_PRICE = (5, '方案库医生商议议价')
    PLAN_HOSPITAL_NEGOTIATED_PRICE = (6, '方案库医院商议议价')
    PLAN_PLAN_NEGOTIATED_PRICE = (7, '方案库方案商议议价')
    CONSULT_APPOINTMENT = (8, '面诊预约卡')


class STATION_NOTICE_NOTI_TYPE(Enum):

    """ 站内通知 通知类型 """

    SALES_LEAD_PHONE_AUTHORIZE = (1, '线索通电话授权')
