#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/06/13 19:27:08
#   Desc    :   线下分期枚举
#

from ..utils.enum import Enum, unique


@unique
class IMAGE_TYPE(Enum):
    FRONT = 'front', '身份证正面'
    BACK = 'back', '身份证背面'
    HAND = 'hand', '手持身份证'
    PLAN = 'plan', '方案确认书'
    OPERATOR = 'operator', '运营商认证图片'


@unique
class RELATION(Enum):
    FATHER = (1, '父亲')
    MOTHER = (2, '母亲')
    SPOUSE = (4, '配偶')
    BROTHER = (8, '兄弟')
    SISTER = (9, '姐妹')
    CHILD = (10, '子女')
    CLASSMATE = (12, '同学')
    COLLEAGUE = (13, '同事')
    FRIEND = (14, '朋友')
    OTHER = (15, '其他亲属')


@unique
class MARRIAGE(Enum):
    UNMARRIED = (0, '未婚')
    MARRIED = (1, '已婚')
    DIVORCED = (2, '离异')
    WIDOWED = (3, '丧偶')
    REMARRIAGE = (5, '再婚')


@unique
class EDUCATION(Enum):
    JUNIOR_OR_UNDER = (3, '初中及以下')
    SENIOR = (4, '高中')
    SECONDARY = (5, '中专')
    SPECIALTY = (6, '大专')
    BECHELOR = (7, '本科')
    MASTER_OR_HIGHER = (8, '研究生及以上') # XXX 不再使用
    MASTER = (9, '硕士研究生')
    DOCTOR = (10, '博士研究生')
    POST_DOCTOR = (11, '博士后')


@unique
class OCCUPATION(Enum):
    SER = 13, '服务行业'
    SEL = 19, '批发零售/商业贸易/租赁'
    PRO = 18, '生产/加工/制造业'
    ITE = 22, 'IT网络/计算机/通信'
    FIN = 1, '金融/银行/保险'
    CON = 20, '工程建筑/装修/园林绿化'
    EDU = 21, '文化科教'
    FOO = 14, '旅游/饭店/娱乐'
    ORG = 17, '政府机关/事业单位/国企'
    ADV = 15, '广告'
    TRA = 12, '运输业'
    OTH = 11, '其他'


@unique
class POSITION(Enum):
    L18 = 18, '一般员工'
    L3 = 3, '一般管理人员'
    L2 = 2, '中级管理人员'
    L1 = 1, '高级管理人员'
    L4 = 4, '企业法人/股东'
    L5 = 5, '个体业主'
    L17 = 17, '科员'
    L16 = 16, '一般干部'
    L15 = 15, '科级'
    L14 = 14, '处级'
    L13 = 13, '厅局级以上'
    L19 = 19, '其他'


@unique
class BANK(Enum):
    L1 = '0103', '中国农业银行'
    L2 = '0102', '中国工商银行'
    L3 = '0104', '中国银行'
    L4 = '0105', '中国建设银行'
    L5 = '0301', '交通银行'
    L6 = '0403', '中国邮政储蓄银行'
    L7 = '0309', '兴业银行'
    L8 = '0302', '中信银行'
    L9 = '0305', '中国民生银行'
    La = '0308', '招商银行'
    Lb = '0303', '中国光大银行'
    Lc = '0307', '平安银行'
    Ld = '0310', '浦发银行'
    Le = '0306', '广发银行'
    Lf = '0304', '华夏银行'
    Lg = '0201', '北京银行'
    Lh = '0202', '上海银行'


# XXX 不再使用
class INSTALLMENT_STATUS(Enum):
    AUDITING = ('auditing', '审核中')
    GRANT = ('grant', '审核通过')
    REJECT = ('reject', '分期失败')
    REPAY = ('repay', '还款')
    REFUND = ('refund', '分期取消')
    SUPPLY = ('supply', '需补充')


@unique
class CONTRACT(Enum):
    L0 = '0', '委托代扣协议'
    L1 = '1', '借款协议(通用版)'
    L2 = '2', '富友-玖富专用账户协议(通用版)'
    L3 = '3', '小微金融信息咨询及信用管理服务合同(通用版)'
    L4 = '73', 'CA 个人数字证书申请表及授权委托书'
    L5 = '74', '征信及信息披露授权书'
    L6 = '104', '约定争议管辖变更确认函'
    L7 = '93', '太平-保险说明(9F)'


@unique
class BILL_STATUS(Enum):
    UNPAY = 1, '未还款'
    PAYED = 2, '已还款'
    PAYING = 3, '支付中'
    OVERDUE = 4, '逾期'


@unique
class ORDER(Enum):
    PRE = 'prepare', '待提交'
    AUDIT = 'audit', '审核中'
    REPOST = 'repost', '审核未通过重新申请'
    REAUTH = 'reauth', '审核未通过重新验证授权'
    REJECT = 'reject', '审核未通过'
    PASS = 'pass', '审核通过待确认'
    CANCEL = 'cancel', '已取消'
    TIMEOUT = 'timeout', '已过期'  # 用户超过30天未确认
    OVERDUE = 'overdue', '已超时'  # BD 超过30天未确认
    CONFIRM = 'user_confirm', '待核实'
    REPAY = 'repay', '还款中'
    PAYOFF = 'payoff', '已还清'
    REAPPLY = 'reapply', '审核未通过重新申请'


@unique
class AUTHENTICATION(Enum):
    ZHIMA = 1001, '芝麻信用'
    YUNYING = 1002, '运营商'
    JD = 1004, '京东'
    CARD = 1005, '信用卡'


@unique
class STATEMENT_STATUS(Enum):
    UNCOLLECTION = 1, '未收款'
    COLLECTION = 2, '已收款'
    SETTLE = 3, '已结算'
    FAULT = 4, '已收款打款失败'


@unique
class SERVICE_TYPE(Enum):
    BJD = 'bjd', '博金贷'
    SY = 'sy', '闪银'


@unique
class ROLE_TYPE(Enum):
    USER = 1, '用户'
    SERVICE = 2, '合作方'
    OPUSER = 3, '运营'
    SYSTEM = 4, '系统操作'


@unique
class AUTHOR_STATUS(Enum):
    UNAUT = 0, '未认证'
    AUT = 1, '已认证'
    FAIL = 5, '认证失败'
    AUTING = 3, '认证中'


@unique
class CAREER_TYPE(Enum):
    NO_WORK = 0, '无业'
    WORKING = 1, '在职'
    STUDENT = 2, '学生'
    SELF_EMPLOYED = 3, '自雇人士'
    FREE = 4, '自由职业'
    HOUSEWIFE = 5, '家庭主妇'
