# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import
from ..utils.enum import Enum, unique


class FASHION_TYPE(Enum):
    NOPE = (0, '非达人')
    MEDICAL = (1, '医美达人')
    MAKEUP = (2, '美妆达人')
    DRESS = (3, '穿搭达人')
    FASHION = (4, '时尚达人')
    BODYBUILDING = (5, '健身达人')
    ARTISTIC = (6, '美学达人')


class STAT_LOG_USER_ACTION(Enum):
    """
    用户行为埋点，行为枚举
    """
    FOLLOW = ("follow", "关注")
    LIKE = ("like", "点赞")
    COLLECT = ("collect", "收藏")
    COMMENT = ("comment", "评论")
    CREATE = ("create", "创建")
    UPDATE = ("update", "更新")
    ANSWER = ("answer", "回答")
    KYC_720 = ("kyc720", "问卷调查,用户勾选的回答")
    KYC_720_RECTIFY = ("kyc720_rectify", "问卷调查,用户勾选的回答")
    AI_QA = ('ai_answer_portrait', "ai问答")


class STAT_LOG_ACTION_CONTENT_TYPE(Enum):
    """
    用户行为埋点，内容类型
    """
    DIARY = ("diary", "日记本")
    GROUP = ("group", "小组")
    GROUP_TOPIC = ("group_topic", "话题")
    TOPIC = ("topic", "日记帖")
    QUESTION = ("question", "问题")
    DOCTOR_POST = ("doctor_post", "医生帖")
    USER_POST = ("user_post", "用户帖")
    ARTICLE = ("article", "专栏")
