from django.conf import settings
from helios.rpc import create_default_invoker
import traceback
import logging

_rpc_invoker = create_default_invoker(debug=settings.DEBUG)


def get_rpc_invoker():
    return _rpc_invoker


rpc_invoker = create_default_invoker(debug=False)


def device_is_gray(device_id, cache_key):
    try:
        grey_codes = [cache_key]
        rpc_client = rpc_invoker['platform/grey_control/info_by_names'](grey_codes=grey_codes, device_id=device_id)
        ret = rpc_client.unwrap()
        return ret["codes"][cache_key]
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
