#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/12/08 14:46:36
#   Desc    :   hera 配置项
#

from .utils.enum import Enum, unique


@unique
class CONFIG(Enum):
    POINT_1 = 'point_1', u'美分商城第1位置'
    POINT_2 = 'point_2', u'美分商城第2位置'
    POINT_3 = 'point_3', u'美分商城第3位置'
    POINT_4 = 'point_4', u'美分商城第4位置'


@unique
class ORDER_STATUS(Enum):
    CLOSED = '0', u'即将开始'
    ON = '1', u'正在进行'
    NOT_START = '2', u'已经结束'


@unique
class ADVERTISE_MANAGEMENT_POSITIONS(Enum):
    SERVICE_HOME_RECOMMEND = '0', u'美购首页推荐'
    SERVICE_LIST = '1', u'美购列表页'
    SERVICE_HOME_BANNER = '2', u'美购品类模块'
    SREACH_RESULT = '3', u'搜索结果页'


@unique
class BUSINESS_TYPE(Enum):
    """ 业务类型 社区，广告，运营等 """
    COMMUNITY = 'community', '社区'
    ADVERTISE = 'advertise', '广告'
    OPERATING = 'operating', '运营'


@unique
class ONLINE(Enum):
    FALSE = False, '下线'
    TRUE = True, '上线'


@unique
class MONTH_RANGE(Enum):
    CURRENT = 'current', '当月'
    MONTH3 = 'month3', '近3个月'
    MONTH6 = 'month6', '近6个月'
