# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum, unique


@unique
class NOTIFY_APP_STATUS(Enum):
    NOT_START = (0, u'支付没有成功, 不通知')
    START = (1, u'支付成功, 通知中')
    SUCCESS = (2, u'APP成功返回')
    CLOSED = (3, u'失败,不再发送通知')


@unique
class REFUND_STATUS(Enum):
    NOT_START = (0, u'未开始')
    PENDING = (1, u'退款处理中')
    SUCCESS = (2, u'退款成功')
    FAIL = (3, u'退款失败')
    # FAIL 现在包含未知失败原因和已知失败原因，之后部分失败可能会直接转入 ”人工退款处理中“


@unique
class REFUND_FAIL_REASON(Enum):
    NONE = (0, u'无')  # 退款处理中等等没有明确结论时候的默认状态
    UNKNOWN = (1, u'未知错误')  # 预留，此时需要人工介入
    TRADE_OVERDUE = (2, u'超过退款期限')  # 支付宝、微信都有的常见情况，连连呢？
    NOT_ENOUGH = (3, u'账户余额不足')  # 卖家账户余额不足，支付宝和微信都有，连连也有


@unique
class CHANNEL(Enum):
    WECHAT = (u'wechat', u'微信')
    ALIPAY = (u'alipay', u'支付宝')
    LIANLIAN = (u'lianlian', u'连连支付')


@unique
class METHOD(Enum):
    APP = (u'app', u'客户端')
    MWEB = (u'm', u'手机网站')
    WEB = (u'web', u'电脑网站')
    ALI_OLD_WEB = (u'old_web', u'阿里旧网页支付')
    ALI_OLD_APP = (u'old_app', u'阿里旧客户端支付')
    ALI_NEW_APP = (u'new_app', u'阿里新客户端支付')
    ALI_USING_APP = (u'ali_using', u'阿里当前支付')
    WECHAT_JSAPI = (u'wechat_jsapi', u'公众号支付')
    WECHAT_USING = (u'wechat_using', u'微信当前支付')
    WECHAT_JSAPI_USING = (u'wechat_jsapi_using', u'公众号当前支付')
    QRCODE = (u'qrcode', u'扫码支付')


@unique
class PAYMENT_ORDER_STATUS(Enum):
    NOT_PAID = (u'0', u'未付款')
    PAID = (u'1', u'已付款')
    CANCEL = (u'2', u'已取消')


@unique
class APP_TYPE(Enum):
    SPECIAL = (u'0', u'美购')
    MAIDAN = (u'1', u'买单')
    HOSPITAL_PAYMENT = (u'2', u'到院支付')
    HOSPITAL_PAYMENT_REFUND = (u'3', u'到院支付退款')
    CONSULTATION = (u'4', u'面诊订单支付')
    CONSULTATION_REFUND = (u'5', u'面诊订单退款')

@unique
class PREPAY_STATUS(Enum):
    NOT_PAY = (u'0', u'未支付')
    PAID = (u'1', u'已支付')
    CLOSED = (u'2', u'已完结')


@unique
class SUFPAY_STATUS(Enum):
    """
    尾款支付状态
    """
    UNCREATED = (u'-1', u'未创建尾款单')
    PAYING = (u'0', u'尾款支付中')
    PAID = (u'1', u'已支付尾款')
    REFUNDING = (u'2', u'尾款退款中')
    REFUNDED = (u'3', u'退款成功')
    FAILURE = (u'4', u'退款失败')


@unique
class SUFPAY_CHANNEL(Enum):
    HUABEI = (u'1', u'蚂蚁花呗')


@unique
class INSTALLMENT_PERIOD(Enum):
    """
    分期付款 付款周期
    """
    QUARTER = (u'0', u'3个月')
    HALF = (u'1', u'6个月')
    YEAR = (u'2', u'12个月')


@unique
class REFUND_CODE(Enum):
    PENDING = ('-1', u'网络请求出错')
    SUCCESS = ('0', u'退款成功')
    FAIL = ('1', u'退款失败')
    CLOSED = ('2', u'该交易已完结，不允许进行退款')