# -*- coding: utf-8 -*-
from __future__ import print_function, absolute_import, unicode_literals

from ..utils.enum import Enum, unique


@unique
class ERROR(int, Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt
    """

    ENTRY_DOSE_NOT_EXIST = (200000, '客服分组不存在')
    ENTRY_EXIST = (200001, '客服分组已存在')
    ENTRY_NAME_COLLISION = (200002, '客服分组名字已存在')
    ENTRY_NAME_INVALID = (200003, '客服分组名字不合法')
    OBJECT_NOT_EXIST = (210001, '对象不存在')
    LOGIN_REQUIRED = (210002, '需要登陆')
    PERM_REQUIRED = (210003, '没有权限')
    OBJECT_EXIST = (210004, '对象已存在')
    STAFF_DELETED = (210005, '该员工被禁止登陆')
    ARG_MISS = (210006, '参数缺少')
    ARG_ERROR = (210007, '参数错误')
    TICKET_EXISTS = (210008, '存在活跃会话')
    ENTRY_CAN_NOT_DELETE = (210009, '该分组不允许删除')
