# coding=utf-8
import unittest

from gm_upload.utils.image_utils import (
    get_domain,
    get_full_path,
    get_short_path,
    get_w_path,
    get_thumb_path,
    ImageUrlBase,
    Picture,
)

class TestImageUtils(unittest.TestCase):
    def setUp(self):
        self.base_domain = 'heras.igengmei.com'
        self.path_name = '2019/02/20/86df21ab88'
        # domin 与 get_domain应得到的正确结果的映射
        self.domain_res_map = {
            'http://heras.igengmei.com/' : 'http://heras.igengmei.com/',
            'http://heras.igengmei.com' : 'http://heras.igengmei.com/',
            'https://heras.igengmei.com/' : 'https://heras.igengmei.com/',
            'https://heras.igengmei.com' : 'https://heras.igengmei.com/',
            'heras.igengmei.com': 'http://heras.igengmei.com/',
            'heras.igengmei.com/': 'http://heras.igengmei.com/',
        }

    def test_get_domain(self):
        for domain, result in self.domain_res_map.items():
            self.assertEqual(get_domain(domain), result)

    def test_get_full_path(self):
        self.assertEqual(get_full_path(self.path_name, self.base_domain), 'http://heras.igengmei.com/2019/02/20/86df21ab88')
        self.assertEqual(get_full_path(self.path_name, 'https://heras.igengmei.com'), 'https://heras.igengmei.com/2019/02/20/86df21ab88')

    def test_get_short_path(self):
        pass

    def test_get_w_path(self):
        pass

    def test_get_thumb_path(self):
        pass

class TestPicture(unittest.TestCase):
    def setUp(self):
        pass

    def test_get_full_path_with_default_https_host(self):
        url = Picture.get_full_path('aasfs/sdas/dsafdk')
        self.assertTrue(url.startswith('https://'))
