# -*- coding: utf-8 -*-
"""
Created on Wed Jul 25 12:39:56 2018

@author: hanye
"""

# 改用 cal_weekly_net_inc_auto_task_by_zhouyujiang.py 程序

import datetime
import argparse
import sys
from func_cal_weekly_net_inc import cal_weekly_net_inc_with_doc_type_name_multi_thread
from func_cal_weekly_net_inc import parse_week_param
from func_find_week_num import find_week_belongs_to
from func_update_weekly_datapool import define_doc_type

def get_weekly_doc_type_name_by_week_str(week_str):
    weekly_doc_type = 'daily-url-%s' % week_str
    parse_week = parse_week_param(weekly_doc_type)
    if parse_week is None:
        print('Illegal input week_str: %s' % week_str)
        return None
    else:
        return weekly_doc_type

week_day_start = 1
todayT = datetime.datetime.today()

parser = argparse.ArgumentParser()
parser.add_argument('-w', '--week_str', type=str, default=None)
parser.add_argument('-m', '--cal_for_missed', default='0')
parser.add_argument('-t', '--threads_num', default=None)
args = parser.parse_args()

if args.cal_for_missed == '1':
    print('Will calculate for missed data, whose field of "weekly_cal_base" '
          'is absent.')
    query_term = {
        "must_not": [
            {"exists": {"field": "weekly_cal_base"}}
        ]
    }
else:
    query_term = None

if args.week_str is None:
    seven_days_ago_T = todayT - datetime.timedelta(days=7)
    week_year, week_no, week_day = find_week_belongs_to(seven_days_ago_T,
                                                        week_day_start)
    weekly_doc_type_name = define_doc_type(week_year, week_no,
                                           week_day_start=week_day_start)
else:
    weekly_doc_type_name = get_weekly_doc_type_name_by_week_str(args.week_str)
    if weekly_doc_type_name is None:
        print('Failed to parse week info from input argument: %s, '
              'program exits.' % args.week_str)
        sys.exit('cal_weekly_net_inc_auto_task - '
                 'Program exits dure to illegal input week_str')
    else:
        pass

index = 'short-video-weekly'
if args.threads_num is not None:
    try:
        threads_num = int(args.threads_num)
    except ValueError:
        print('Illegal value for argument threads_num: %s' % args.threads_num)
else:
    threads_num = 10

cal_weekly_net_inc_with_doc_type_name_multi_thread(weekly_doc_type_name,
                                                   threads_num=threads_num,
                                                   index_weekly=index,
                                                   query_term=query_term)
