#!/usr/bin/env python
# -*- coding: utf-8 -*-

import hashlib
import datetime
import time

import gm_upload
from crawler.gm_upload.gm_upload.consts import IMG_TYPE



def gen_rnd_filename(ext=None):
    prefix = datetime.datetime.today().strftime("%Y/%m/%d")
    md5 = hashlib.md5(str(time.time()).encode("utf8")).hexdigest()[:10]
    md5 = prefix + '/' + md5
    if ext is not None:
        md5 = md5 + '.' + ext
    return md5


def store_picture_and_get_key(picture):
    etx = None
    save_name = gen_rnd_filename(etx)
    key = gm_upload.upload(picture, IMG_TYPE.NOWATERMARK, save_name)
    return key