# coding=utf-8
from __future__ import unicode_literals, absolute_import
from ..utils.enum import Enum, unique


@unique
class INSTALLMENT_SOURCE(Enum):
    ORDER = (1, '美购订单')
    MAIDAN = (2, '买单订单')


@unique
class CREDIT_STATUS(Enum):
    # 个人额度状态
    DEFAULT = (0, '默认，无用')
    PASS = (1, '通过授信')
    DENY = (2, '审核拒绝')
    NO_APPLY = (3, '未申请')
    OUT = (4, '额度超时')
    AUDIT = (5, '审核中')
    INFO_MISS = (6, '信息不符')
    CANCEL = (7, '信审取消')  # 任买信审取消
    REJECT_OUT = (8, '据贷状态失效')  # 据贷后一段时间又能申请


@unique
class INSTALLMENT_STATUS(Enum):
    # 分期单状态
    NONE = (0, '无用，默认')
    AUDITING = (1, '审核中')
    GRANT = (2, '审核通过')
    REJECT = (3, '分期失败')
    REPAY = (4, '还款')
    REFUND = (5, '用户放弃')
    CANCEL = (6, '已取消')      # 任买单方面取消
    LOANING = (7, '放款中')
    FINISH = (13, '完结')
    OUT = (14, '超时') # 分期单超时未使用


@unique
class INSTALLMENT_EDUCATION(Enum):
    JUNIOR_OR_UNDER = (3, '初中及以下')
    SENIOR = (4, '高中')
    SECONDARY = (5, '中专')
    SPECIALTY = (6, '专科')
    BECHELOR = (7, '本科')
    MASTER = (8, '硕士研究生')
    DOCTOR = (10, '博士研究生')


@unique
class USER_IDENTITY(Enum):
    WORKER = (0, '上班族')
    STUDENT = (1, '学生')
    INDIVADUAL = (3, '个体经营者')
    FREELANCE = (4, '自由职业者')
    OTHER = (5, '其他')
