#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/08/09 12:04:05
#   Desc    :   医生后台错误码
#


from ..utils.enum import Enum, unique


@unique
class ERROR(int, Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt

        !!! 字符前面一定要记得加 u  !!!!!
    """
    LIST_NO_MORE_DATA = (1, u'没有更多数据了')
    ASCLE_ERROR = (300000, u'服务器错误，请稍后再试')
    ARG_MISS = (300001, u'缺少参数')
    ARG_ERROR = (300002, u'参数错误')
    CONTENT_OVERRUN = (300003, u'文字过长')
    NOT_FOUND_PHONE = (300004, u'找不到电话号码')
    HTTP_METHOD_NOT_ALLOW = (300005, u'该方法未经授权，无法访问')
    EMPTY_ITEMS = (300006, u'价格表不能未空')
    QUERY_DATE_OUT = (300007, u'查询日期过长')
    VALID_SHORT_DESCRIPTION = (300010, u'美购描述中含有非法字符')
    PROJECT_NAME_DESCRIPTION = (300011, u'美购项目名中含有非法字符')

    # 账号相关
    ACCOUNT_OFF_LINE = (310000, u'您的医生账号已下线，无法操作')  # 医生下线
    ACCOUNT_BLOCK = (310001, u'您的医生账号被拉黑，无法操作')  # User入了黑名单

    # 美购相关
    SECKILL_EXPIRE = (320001, u'秒杀已过期')

    # 订单相关
    REFUND_REJECT_FAIL = (330001, u'验证码有误，请重新输入或同意退款')

    # 商户主动私信
    OVER_MESSAGE_COUNT = (340001, u'今日可主动私信用户已达上限')

    # 以下是重写gaia.error中的，重定义文案
    # 以下是重写gaia.error中的，重定义文案
    DIARY_HAS_VOTED = (12902, u'该案例已经赞过')
    DIARY_NOT_FOUND = (20009, u'该案例不存在')
    MESSAGE_INVALID_TARGET_USER = (21004, u'请确定收信人')
    MESSAGE_CONTENT_FILTERED_OUT = (21005, u'对不起，您的回复没有发送成功，为维护社区纯洁性，\
            我们建议您在文中避免加入个人联系信息，并建议用户直接拨打APP内医生预留电话与您联系。')
    PHONE_PASSWORD_INVALID = (22002, u'用户名或密码错误')
    BIND_EXIST_PHONE = (23104, u'该手机号已经注册更美，无法绑定')
    STATS_NOT_FOUND = (31001, u'数据统计中，敬请期待！')
    LOGIN_FAIL = (70002, u'用户名或者密码错误')
    DOCTOR_NOT_FOUND = (30001, u'该医生不存在')
    DOCTOR_HAS_APPLIED = (30002, u'医生已经申请审核加入')
    DOCTOR_HAS_NOT_APPLIED = (30003, u'医生未申请审核加入')

    PERMISSION_NOT_ALLOW = (300009, u'没有权限！')
    CONVERSATION_NOT_FOUND = (300012, u'当前商户不存在对应的会话关系')

    PROMOTION_PRICE_NOT_ALLOW = (300020, u'价格设置有误')
    PROMOTION_INVENTORY_NOT_ALLOW = (300021, u'库存设置有误')
    PROMOTION_TAG_NOT_ALLOW = (300022, u'活动标签不匹配')
    PROMOTION_NOT_ALLOW = (300023, u'已参与活动')
    PROMOTION_TIME_NOT_ALLOW = (300024, u'活动提报时间不匹配')
    PROMOTION_RECALL_NOT_ALLOW = (300025, u'该提报不是待审核状态，不支持撤回')
    PROMOTION_PRICE_LT_ORIGINAL = (300026, u'活动价格必须小于更美价格')
    PROMOTION_PRICE_NOT_ZRO = (300027, u'活动价不可为零')
    PROMOTION_COMMODITY_NOT_OFFLINE = (300028, u'不能提报下线商品')