# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


@unique
class DIRECTORY_TYPE(Enum):
    """ 目录页大类类型
    """
    ITEM = 'item', u'项目库'
    DRUG = 'drug', u'药品库'
    MACHINE = 'machine', u'仪器库'
    MATERIAL = 'material', u'材料库'


@unique
class DIRECTORY_CELL_TYPE(Enum):
    """ 目录页数据类型
    """
    COLLECT = 'collect', u'聚合页'
    BRAND = 'brand', u'品牌页'
    PRODUCT = 'product', u'产品页'


@unique
class ITEM_H1(Enum):
    LI1 = 1010, '玻尿酸'
    LI2 = 1020, '肉毒素'
    LI3 = 1030, '皮肤美容'
    LI4 = 1040, '眼部整形'
    LI5 = 1050, '鼻部整形'
    LI6 = 1060, '面部轮廓'
    LI7 = 1070, '自体脂肪'
    LI8 = 1080, '胸部整形'
    LI9 = 1090, '美体塑形'
    LI10 = 1100, '抗衰抗初老'
    LI11 = 1110, '牙齿美容'
    LI12 = 1120, '半永久妆'
    LI13 = 1130, '激光脱毛'
    LI14 = 1140, '毛发种植'
    LI15 = 1150, '私密整形'
    LI16 = 1160, '唇部整形'
    LI17 = 1170, '耳部整形'
    LI19 = 1190, '修复手术'
    LI18 = 1180, '其他'


@unique
class DRUG_H1(Enum):
    LD1 = 2010, '玻尿酸'
    LD2 = 2020, '肉毒素'
    LD3 = 2030, '水光针'
    LD4 = 2040, '美白针'
    LD5 = 2050, '鼻部整形'
    LD6 = 2060, '注射抗衰'
    LD7 = 2070, '长效填充剂'
    LD8 = 2080, '胶原蛋白'
    LD9 = 2090, '果酸'
    LD10 = 2100, '溶脂针'
    LD11 = 2110, '胎盘素'


@unique
class MACHINE_H1(Enum):
    LM1 = 3010, '皮秒激光'
    LM2 = 3020, '紧致提升仪器'
    LM3 = 3030, '彩光嫩肤仪器'
    LM4 = 3040, '水光注射仪'
    LM5 = 3050, '清洁祛痘仪器'
    LM6 = 3060, '祛斑色素仪器'
    LM7 = 3070, '祛疤痘印仪器'
    LM8 = 3080, '溶脂瘦身仪器'
    LM9 = 3090, '激光脱毛仪器'
    LM10 = 3100, '吸脂仪器'
    LM11 = 3110, '女性私密仪器'
    LM12 = 3120, '植发仪器'
    LM13 = 3130, '皮肤检测'


@unique
class MATERIAL_H1(Enum):
    LA1 = 4010, '隆胸假体'
    LA2 = 4020, '鼻假体'
    LA3 = 4030, '面部假体'
    LA4 = 4040, '线材'
    LA5 = 4050, '齿科种植体'
    LA6 = 4060, '齿科隐形牙套'


@unique
class DIRECTORY_ALL_MODEL_TYPE(Enum):
    """
    百科目录所有类别聚合
    """

    LI1 = 1010, '玻尿酸'
    LI2 = 1020, '肉毒素'
    LI3 = 1030, '皮肤美容'
    LI4 = 1040, '眼部整形'
    LI5 = 1050, '鼻部整形'
    LI6 = 1060, '面部轮廓'
    LI7 = 1070, '自体脂肪'
    LI8 = 1080, '胸部整形'
    LI9 = 1090, '美体塑形'
    LI10 = 1100, '抗衰抗初老'
    LI11 = 1110, '牙齿美容'
    LI12 = 1120, '半永久妆'
    LI13 = 1130, '激光脱毛'
    LI14 = 1140, '毛发种植'
    LI15 = 1150, '私密整形'
    LI16 = 1160, '唇部整形'
    LI17 = 1170, '耳部整形'
    LI19 = 1190, '修复手术'
    LI18 = 1180, '其他'

    LD1 = 2010, '玻尿酸'
    LD2 = 2020, '肉毒素'
    LD3 = 2030, '水光针'
    LD4 = 2040, '美白针'
    LD5 = 2050, '鼻部整形'
    LD6 = 2060, '注射抗衰'
    LD7 = 2070, '长效填充剂'
    LD8 = 2080, '胶原蛋白'
    LD9 = 2090, '果酸'
    LD10 = 2100, '溶脂针'
    LD11 = 2110, '胎盘素'

    LM1 = 3010, '皮秒激光'
    LM2 = 3020, '紧致提升仪器'
    LM3 = 3030, '彩光嫩肤仪器'
    LM4 = 3040, '水光注射仪'
    LM5 = 3050, '清洁祛痘仪器'
    LM6 = 3060, '祛斑色素仪器'
    LM7 = 3070, '祛疤痘印仪器'
    LM8 = 3080, '溶脂瘦身仪器'
    LM9 = 3090, '激光脱毛仪器'
    LM10 = 3100, '吸脂仪器'
    LM11 = 3110, '女性私密仪器'
    LM12 = 3120, '植发仪器'
    LM13 = 3130, '皮肤检测'

    LA1 = 4010, '隆胸假体'
    LA2 = 4020, '鼻假体'
    LA3 = 4030, '面部假体'
    LA4 = 4040, '线材'
    LA5 = 4050, '齿科种植体'
    LA6 = 4060, '齿科隐形牙套'


@unique
class TREATMENT_TYPE(Enum):
    """
    治疗方式
    """
    NULL = ('0', u'空')
    OPERATE = ('1', u"手术")
    INJECT = ('2', u"注射")
    LIGHT = ('3', u'光电')
    TEETH = ('4', u'牙齿美容')
    LIFE = ('5', u'生活美容')
    ULTRASONIC = ('6', u'超声波')
    LHURT = ('7', u'微创')
    RADIO = ('8', u'射频')
    OTHER = ('9', u'其他')
    MUNSU = ('10', u'纹绣')


@unique
class ANESTHESIA_TYPE(Enum):
    """
    麻醉方法
    """
    NONE = ('0', u'无需麻醉')
    NONE_SURFACE = ('1', u'无需麻醉/表麻')
    SURFACE = ('2', u'表麻')
    PART = ('3', u'局醉')
    SURFACE_PART = ('4', '局部麻醉/全麻')
    PART_SLEEP = ('5', '局部麻醉/睡眠麻醉')
    ALL = ('6', u'全麻')
    ALL_SLEEP = ('7', u'全麻/睡眠')


@unique
class ACHE_LEVEL_NEW(Enum):
    """
    疼痛感等级
    """
    ZERO = ('0', u'无疼痛感：0星')
    ONE = ('1', u'轻度疼痛：1星')
    TWO = ('2', u'中度疼痛：2星')
    THREE = ('3', u'重度疼痛：3星')
    FOUR = ('4', u'严重疼痛：4星')
    FIVE = ('5', u'剧烈疼痛：5星')


@unique
class PRODUCT_TYPE(Enum):
    DRUG = ('0', '药品')
    INSTRUMENT = ('1', '仪器')
    MATERIALS = ('2', '材料')


@unique
class ATTESTATION_TYPE(Enum):
    """
    认证类型
    """

    CE = ('CE', 'CE')
    FDA = ('FDA', 'FDA')
    CFDA = ('CFDA', 'CFDA')
    TFDA = ('TFDA', 'TFDA')
    KFDA = ('KFDA', 'KFDA')


@unique
class PRODUCT_IMAGE_TYPE(Enum):
    """
    物品图片类型
    """

    PRODUCT = ('1', '物品图片')
    VERRIFY = ('2', '辨别图片')


@unique
class PRODUCT_PARAMS(Enum):
    """
    物品参数类型
    """

    # 药品
    TYPE = ('0', '型号')
    CONCENTRATION = ('1', '浓度')
    MOLECULAR = ('2', '分子量')
    PART = ('3', '成分')
    PROPERTY = ('4', '性质类型')
    DISPERSITY = ('5', '弥散度')
    SIZE = ('6', '规格')
    # 仪器
    WAVE_LENGTH = ('7', '波长')
    ENERGY = ('8', '能量源')
    PULSE_WIDTH = ('9', '脉冲宽度')
    MAX_ENERGY = ('10', '最大输出能量')
    SPOT_SIZE = ('11', '光斑大小')
    PHOTO_SYS = ('12', '影像系统')
    FOCUS_DEPTH = ('13', '聚焦深度')
    # 材料
    PURITY = ('14', '材料纯度')
    ANTI_AGING = ('15', '抗老化')
    DUCTILITY = ('16', '材料延展性')
    RESIST_PRESSURE = ('17', '抗压性')
    COHESION = ('18', '凝胶凝聚度')
    ABRASION = ('19', '材料耐磨性')
    SURFACE = ('20', '表面工艺')
    SHAPE = ('21', '形状')
    TRANSPARENCE = ('22', '透光度')
    FLEXIBILITY = ('23', '柔韧性')


@unique
class WIKI_DETAIL_BUTTONS(Enum):
    """
    百科 详情页 按钮
    """
    PREVIEW = (0, u"项目速览")
    ARCHIVE = (1, u"项目档案")
    OP_ARCHIVE_PARAMS = (2, u"治疗说明")
    SIMILAR_DRUG = (3, u"相关药品")
    PRE_KONW = (4, u"术前锦囊")
    POST_KNOW = (5, u"术后锦囊")


class NEW_WIKI_WORDREL_CATEGORY(Enum):
    """
    新百科：项目、材料、药品、仪器、品牌百科关联关键字类型
    """
    ITEM = ('1', u'项目')
    PART = ('2', u'部位')
    SYMPTOM = ('3', u'症状')
    NEED = ('4', u'需求')
    CURE = ('5', u'治疗方式')
    STUFF = ('6', u'材料')
    BRAND = ('7', u'品牌')
    OTHER = ('8', u'其他')


class NEW_WIKI_CARD_TYPE(Enum):
    """
    新百科卡片类型
    """
    BRAND = (1, u"品牌")
    DRUG = (2, u'药品')
    INSTRUMENT = (3, u'仪器')
    MATERIALS = (4, u'材料')
    ITEM = (5, u"项目")
    ITEM_POLYMER = (6, '项目聚合')
