# -*- coding:UTF-8 -*-
# @Time  : 2020/12/11 16:12
# @File  : es_locust.py
# @email : litao@igengmei.com
# @author : litao
# 运行方式 nohup locust -f locust_test/es_locust.py -H http://172.16.52.25:9200 -u 5000  --headless &
import json
import time
from locust import HttpUser, task
from locust.contrib.fasthttp import FastHttpUser

ip = '172.16.52.25@elastic:gengmei!@#'
ip,auth = ip.split("@",1)

query_list = {"鼻综合":22,
"激光脱面部其他毛发":36,
"切开双眼皮":85,
"埋线双眼皮":86,
"定点双眼皮":87,
"开内眼角":88,
"开外眼角":89,
"内切祛眼袋":90,
"外切祛眼袋":91,
"激光祛眼袋":92,
"吸脂祛眼袋":93,
"上眼睑下垂矫正":95,
"玻尿酸填充卧蚕":97,
"自体脂肪填充泪沟":98,
"玻尿酸填充泪沟":99,
"切眉":100,
"激光祛黑眼圈":101,
"自体脂肪填充黑眼圈":102,
"鼻部膨体假体取出":106,
"驼峰鼻矫正":107,
"鹰钩鼻矫正":108,
"歪鼻矫正":109,
"朝天鼻矫正":110,
"缩鼻背":111,
"手术缩鼻头":112,
"自体脂肪隆鼻":114,
"玻尿酸隆鼻":115,
"自体软骨垫鼻尖":116,
"注射瘦脸":117,
"吸脂瘦脸":118,
"自体脂肪丰苹果肌":120,
"玻尿酸填充丰苹果肌":121,
"颧骨内推":122,
"玻尿酸丰下巴":123,
"下巴前推":124,
"自体脂肪丰下巴":125,
"硅胶垫下巴":126,
"膨体垫下巴":127,
"缩下巴":129,
"宽下巴矫正":130,
"激光溶脂祛双下巴":131,
"酒窝成形术":134,
"自体脂肪丰面颊":135,
"自体脂肪丰太阳穴":136,
"玻尿酸丰太阳穴":137,
"硅胶丰太阳穴":138,
"膨体丰太阳穴":139,
"自体脂肪丰额头":140,
"玻尿酸丰额头":141,
"硅胶丰额头":142,
"膨体丰额头":143,
"招风耳矫正":144,
"大耳缩小术":145,
"杯状耳矫正":146,
"唇腭裂修复":150,
"厚唇改薄术":151,
"玻尿酸丰唇":152,
"自体脂肪丰唇":153,
"处女膜修复":161,
"包皮手术":164,
"填充阴唇":165,
"阴唇整形":167,
"注射祛腋臭":168,
"激光祛腋臭":169,
"激光脱发际线":171,
"植眉":172,
"种鬓角":174,
"植睫毛":175,
"黑脸娃娃":180,
"激光脱唇毛":181,
"激光祛红血丝":186,
"光子嫩肤":187,
"激光祛纹身":192,
"玻尿酸除颈纹":197,
"自体脂肪除颈纹":198,
"玻尿酸除法令纹":200,
"自体脂肪除法令纹":201,
"玻尿酸除眉间纹":203,
"胸部失败修复":210,
"乳房再造":211,
"假体隆胸":212,
"吸脂祛副乳":213,
"手术祛副乳":214,
"乳头内陷矫正":215,
"乳头缩小":216,
"乳晕缩小":217,
"乳晕漂染":218,
"乳房缩小":219,
"胸部下垂矫正":220,
"中医减肥其他项目":222,
"吸脂瘦背部":224,
"自体脂肪丰臀":225,
"产后塑形":226,
"腹壁成形术":228,
"膨体隆鼻":232,
"硅胶隆鼻":233,
"自体肋软骨隆鼻":234,
"激光溶脂瘦脸":236,
"注射瘦腿":237,
"吸脂瘦大腿":238,
"吸脂瘦小腿":239,
"吸脂瘦手臂":240,
"自体脂肪隆胸":241,
"玻尿酸除面部细纹":243,
"自体脂肪除面部细纹":244,
"植发际线":251,
"吸脂祛双下巴":252,
"鼻翼缩小":253,
"全瓷牙":255,
"手术祛腋臭":257,
"像素激光":258,
"植胡须":770,
"吸脂塑臀":774,
"点阵激光":775,
"玻尿酸丰面颊":776,
"玻尿酸祛黑眼圈":777,
"胶原蛋白填充丰唇":778,
"胶原蛋白填充祛黑眼圈":780,
"胶原蛋白注射隆鼻":782,
"胶原蛋白丰太阳穴":783,
"胶原蛋白填充丰下巴":784,
"胶原蛋白填充隆胸":785,
"胶原蛋白填充丰臀":786,
"胶原蛋白填充除法令纹":787,
"胶原蛋白填充丰面颊":788,
"胶原蛋白填充泪沟":789,
"下眼睑下至":790,
"泪腺脱垂整形":792,
"自体脂肪填充卧蚕":793,
"真皮填充卧蚕":795,
"埋线隆鼻":796,
"鼻中隔软骨垫鼻头":797,
"注射缩鼻头":798,
"假体垫鼻基底":803,
"玻尿酸垫鼻基底":804,
"自体脂肪垫鼻基底":805,
"鼻中隔软骨隆鼻":806,
"鼻孔矫正":810,
"溶脂针瘦脸":811,
"颧骨提高":813,
"凸嘴矫正":816,
"面部不对称改善":817,
"人工骨垫下巴":819,
"胶原蛋白填充苹果肌":820,
"白瓷娃娃":821,
"热玛吉":822,
"PRP自体血清美肤":824,
"美白针":825,
"手术祛疤":828,
"综合祛疤":832,
"注射祛疤":834,
"激光点痣":835,
"射频溶脂瘦手臂":836,
"小腿神经阻断术":838,
"假体丰臀":839,
"吸脂瘦肩":841,
"注射瘦肩":842,
"点穴减肥":843,
"针灸减肥":844,
"埋线减肥":845,
"错颌锁颌":850,
"隐形矫正":851,
"根管治疗":853,
"M唇成形术":864,
"阴茎延长":866,
"阴茎增粗":867,
"玻尿酸丰耳垂":868,
"轮廓修复术":869,
"胸部假体取出":870,
"超声提升":872,
"线雕":873,
"双眼皮修复":878,
"眶隔脂肪释放":881,
"玻尿酸垫眉弓":885,
"自体脂肪垫眉弓":886,
"硅胶垫眉弓":887,
"膨体垫眉弓":888,
"上眼睑祛脂":890,
"鼻小柱延长":897,
"额头缩小":899,
"人中缩短":901,
"射频溶脂塑臀":909,
"漂唇":910,
"红蓝光祛痘":912,
"化学剥脱祛斑":915,
"冷光美白":917,
"激光祛疤":919,
"拉皮":926,
"黄金微针":928,
"激光除皱":930,
"埋线除皱":931,
"放射状角膜切开术":942,
"准分子激光切削术":943,
"准分子激光原位角膜磨镶术":944,
"透明晶体摘除术":945,
"远视镜片矫正":946,
"激光屈光性角膜切削术":947,
"圆柱镜矫正":948,
"角膜接触镜矫正":949,
"角膜屈光手术":950,
"斜视镜片矫正":951,
"斜视矫正手术":952,
"眼科检查":953,
"玻尿酸填充隆胸":954,
"激光紧缩阴道":960,
"眼袋修复":964,
"鼻形态修复":965,
"鼻部硅胶假体取出":966,
"激光除妊娠纹":973,
"黄金微针除妊娠纹":974,
"冷冻祛腋臭":980,
"半永久纹眉":1370,
"水氧活肤":1703,
"自体脂肪全面部填充":1890,
"镭射净肤":1966,
"半永久纹眼线":2057,
"水光针":2059,
"无针水光":2060,
"射频提升":2063,
"激光脱腋毛":2065,
"激光脱比基尼部位":2066,
"激光脱臂毛":2067,
"激光脱大腿/小腿毛":2068,
"彩光嫩肤":2072,
"耳软骨隆鼻":2073,
"果酸焕肤":2108,
"身体检查":2213,
"玻尿酸溶解酶":2412,
"眼综合":2417,
"开眼角修复":2429,
"合金烤瓷牙":2453,
"二氧化锆烤瓷牙":2454,
"超声波洗牙":2455,
"树脂补牙":2456,
"拔龋齿":2459,
"拔智齿":2460,
"嘴角上扬术":2466,
"口腔检查":2467,
"孕睫术":2723,
"玻尿酸精华导入":2778,
"双颚手术":2818,
"热拉提":2866,
"人工骨隆鼻":2924,
"自体真皮隆鼻":2925,
"鼻小柱缩短":2926,
"长鼻矫正":2929,
"颧弓降低":2932,
"微针祛痘坑":2935,
"激光祛斑":2936,
"皮秒激光":2938,
"小气泡美肤":2939,
"微针水光":2941,
"玻尿酸丰乳头":2944,
"乳头再造":2945,
"胶原蛋白注射丰乳晕":2946,
"提眉修复":2950,
"卧蚕手术修复":2951,
"半永久纹发际线":2954,
"颧骨填充术":3001,
"微晶瓷隆鼻":3038,
"激光祛脂肪粒":3041,
"少女针注射":3043,
"童颜针注射":3045,
"假体填充苹果肌":3048,
"抗敏修复":3049,
"洗眼线":3050,
"肤质检测":3052,
"阴蒂整形":4282,
"菲洛嘉":4437,
"HPV检查":4870,
"全脸整形套餐":5058,
"V脸套餐":5059,
"祛斑套餐":5064,
"美白套餐":5065,
"补水套餐":5066,
"皮肤综合管理套餐":5067,
"洗牙套餐":5070,
"唇部综合":5071,
"除皱套餐":5073,
"玻尿酸注射套餐":5074,
"乳腺检查":5510,
"全飞秒":5871,
"半飞秒":5872,
"ICL晶体植入":5873,
"异物取出":5874,
"美胸套餐":6145,
"激光脱全身毛发":6160,
"射频祛眼袋":6163,
"O型腿矫正":6455,
"X型腿矫正":6456,
"G点注射":7091,
"牙齿瓷贴面":7129,
"自体软骨垫鼻基底":7151,
"女性私密检查":7175,
"阴唇漂红":7176,
"手术紧缩阴道":7177,
"性腺激活":7179,
"种植牙齿":7809,
"下颌角切除术":7823,
"玻尿酸丰眼窝":14198,
"注射去鼻背纹":14209,
"注射去口周纹":14210,
"注射去动态纹":14211,
"注射治疗多汗":14215,
"注射颏肌放松":14220,
"美白导入":14225,
"埋线祛眼袋":14590,
"光纤溶脂祛眼袋":14591,
"微针祛黑眼圈":14593,
"射频祛黑眼圈":14594,
"眼综合修复":14595,
"宽鼻矫正":14596,
"颧骨颧弓整形术":14597,
"下巴截骨":14598,
"下巴硅胶假体取出":14599,
"下巴膨体假体取出":14600,
"下颚前突/地包天":14601,
"上颚前突/天包地":14602,
"下颌角整形":14603,
"取颊脂垫瘦脸":14605,
"射频溶脂瘦脸":14606,
"光纤溶脂瘦脸":14607,
"冷冻溶脂瘦腹部":14608,
"冷冻溶脂瘦腰部":14609,
"冷冻溶脂瘦手臂":14610,
"冷冻溶脂瘦大腿":14611,
"冷冻溶脂瘦小腿":14612,
"冷冻溶脂瘦肩膀":14613,
"冷冻溶脂瘦背部":14614,
"冷冻溶脂瘦臀部":14615,
"射频溶脂瘦大腿":14616,
"射频溶脂瘦小腿":14617,
"射频溶脂瘦肩膀":14618,
"射频溶脂瘦背部":14619,
"射频溶脂瘦腰部":14620,
"射频溶脂瘦腹部":14621,
"超声溶脂瘦手臂":14622,
"超声溶脂瘦腰部":14623,
"超声溶脂瘦腹部":14624,
"超声溶脂瘦大腿":14625,
"超声溶脂瘦小腿":14626,
"超声溶脂瘦臀部":14627,
"超声溶脂瘦背部":14628,
"超声溶脂瘦肩部":14629,
"光纤溶脂瘦手臂":14630,
"光纤溶脂瘦腰部":14631,
"光纤溶脂瘦腹部":14632,
"光纤溶脂瘦大腿":14633,
"光纤溶脂瘦小腿":14634,
"光纤溶脂瘦背部":14635,
"光纤溶脂瘦臀部":14636,
"光纤溶脂瘦肩部":14637,
"吸脂瘦腰部":14639,
"吸脂瘦腹部":14640,
"吸脂瘦全身":14641,
"吸脂失败修复术":14643,
"杏仁酸焕肤":14644,
"水杨酸焕肤":14645,
"清痘针":14646,
"冷冻祛痣":14647,
"手术祛胎记":14648,
"激光祛胎记":14649,
"洗眉":14650,
"小棕瓶美白":14651,
"水光娃娃":14652,
"种植面膜":14653,
"SMAS除皱手术":14654,
"内窥镜手术提升":14655,
"小切口手术提升":14656,
"干细胞疗法":14657,
"复合隆胸":14658,
"男性乳房肥大矫正":14659,
"头顶加密种植":14660,
"美人尖种植":14661,
"种植胸毛":14662,
"种植私密毛发":14663,
"疤痕种植毛发":14665,
"防脱理疗":14667,
"乌发理疗":14668,
"深层清洁":14669,
"养发护理":14670,
}
query_Str_list = list(query_list.keys())
import random
print(random.choice(query_Str_list))

class QuickstartUser(FastHttpUser):
    @task
    def hello_world(self):
        query = random.choice(query_Str_list)
        data = {
  "track_scores": True,
  "query": {
    "function_score": {
      "query": {
        "bool": {
          "must_not": [
            {
              "terms": {
                "id": []
              }
            }
          ],
          "must": [
            {
              "bool": {
                "should": [
                  {
                    "multi_match": {
                      "query": query,
                      "type": "cross_fields",
                      "operator": "and",
                      "fields": [
                        "short_description^8",
                        "doctor.name^4",
                        "doctor.hospital.name^3",
                        "doctor.hospital.city_name^2",
                        "doctor.hospital.city_province_name^2",
                        "bak_closure_tags^2",
                        "doctor.hospital.officer_name^3"
                      ],
                      "analyzer": "gm_default_search"
                    }
                  },
                  {
                    "nested": {
                      "path": "sku_list",
                      "query": {
                        "multi_match": {
                          "query": query,
                          "fields": [
                            "sku_list.name^2",
                            "sku_list.new_sku_tags",
                            "sku_list.instrument",
                            "sku_list.materials",
                            "sku_list.new_sku_name",
                            "sku_list.sku_tags",
                            "sku_list.show_name",
                            "sku_list.show_project_type_name",
                            "sku_list.show_short_description"
                          ],
                          "operator": "and",
                          "type": "cross_fields"
                        }
                      }
                    }
                  }
                ],
                "minimum_should_match": 1
              }
            }
          ],
          "should": [
            {
              "nested": {
                "path": "sku_list",
                "query": {
                  "function_score": {
                    "query": {
                      "bool": {
                        "must": [
                          {
                            "range": {
                              "sku_list.start_time": {
                                "lte": "now"
                              }
                            }
                          },
                          {
                            "range": {
                              "sku_list.end_time": {
                                "gt": "now"
                              }
                            }
                          }
                        ],
                        "should": [
                          {
                            "constant_score": {
                              "filter": {
                                "multi_match": {
                                  "query": query,
                                  "fields": [
                                    "sku_list.name",
                                    "sku_list.new_sku_tags",
                                    "sku_list.instrument",
                                    "sku_list.materials",
                                    "sku_list.sku_tags",
                                    "sku_list.show_name",
                                    "sku_list.show_project_type_name",
                                    "sku_list.show_short_description"
                                  ],
                                  "operator": "and",
                                  "type": "cross_fields",
                                  "analyzer": "gm_default_index"
                                }
                              }
                            }
                          },
                          {
                            "match": {
                              "sku_list.new_sku_name": {
                                "query": query,
                                "analyzer": "gm_default_search",
                                "operator": "or"
                              }
                            }
                          }
                        ]
                      }
                    },
                    "boost_mode": "replace",
                    "score_mode": "max",
                    "min_score": 0
                  }
                },
                "inner_hits": {
                  "size": 1,
                  "sort": [
                    "_score",
                    {
                      "sku_list.price": "asc"
                    }
                  ],
                  "highlight": {
                    "fields": {
                      "sku_list.sku_item_names": {},
                      "sku_list.name": {},
                      "sku_list.show_name": {},
                      "sku_list.show_project_type_name": {},
                      "sku_list.show_short_description": {}
                    },
                    "fragment_size": 10000,
                    "pre_tags": [
                      "<ems>"
                    ],
                    "post_tags": [
                      "</ems>"
                    ],
                    "require_field_match": False,
                    "no_match_size": 200
                  }
                }
              }
            }
          ],
          "filter": {
            "bool": {
              "should": [
                {
                  "bool": {
                    "must": []
                  }
                }
              ],
              "must": [
                {
                  "term": {
                    "is_online": True
                  }
                }
              ]
            }
          },
          "minimum_should_match": 0
        }
      },
      "boost_mode": "replace",
      "score_mode": "max",
      "functions": [
        {
          "filter": {
            "nested": {
              "path": "sku_list",
              "query": {
                "multi_match": {
                  "query": query,
                  "fields": [
                    "sku_list.sku_tags",
                    "sku_list.show_name",
                    "sku_list.show_project_type_name",
                    "sku_list.show_short_description"
                  ],
                  "operator": "and",
                  "type": "cross_fields"
                }
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "match_phrase": {
              "short_description_by_standard_analyzer": {
                "analyzer": "standard",
                "query": query
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "match_phrase": {
              "doctor.name_by_standard_analyzer": {
                "analyzer": "standard",
                "query": query
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "match_phrase": {
              "doctor.hospital.name_by_standard_analyzer": {
                "analyzer": "standard",
                "query": query
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "match_phrase": {
              "doctor.hospital.city_name_by_standard_analyzer": {
                "analyzer": "standard",
                "query": query
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "match_phrase": {
              "doctor.hospital.city_province_name_by_standard_analyzer": {
                "analyzer": "standard",
                "query": query
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "match_phrase": {
              "bak_closure_tags_by_standard_analyzer": {
                "analyzer": "standard",
                "query": query
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "match_phrase": {
              "doctor.hospital.officer_name_by_standard_analyzer": {
                "analyzer": "standard",
                "query": query
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "nested": {
              "path": "sku_list",
              "query": {
                "match_phrase": {
                  "sku_list.name_by_standard_analyzer": {
                    "query": query,
                    "analyzer": "standard"
                  }
                }
              }
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "short_description": query
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "doctor.name": query
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "doctor.hospital.name": query
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "doctor.hospital.city_name": query
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "doctor.hospital.city_province_name": query
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "bak_closure_tags": query
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "doctor.hospital.officer_name": query
            }
          },
          "weight": 1000
        },
        {
          "filter": {
            "term": {
              "sku_list.name": query
            }
          },
          "weight": 1000
        }
      ]
    }
  },
  "sort": [
    {
      "_script": {
        "script": {
          "id": "service_sink",
          "params": {
            "current_time": 1607659609.436846
          }
        },
        "type": "number",
        "order": "asc"
      }
    },
    {
      "_script": {
        "script": {
          "id": "service_time_valid",
          "params": {
            "current_time": 1607659609.436846
          }
        },
        "type": "number",
        "order": "desc"
      }
    },
    {
      "_script": {
        "script": {
          "id": "service_sink_by_org",
          "params": {
            "current_time": 1607659609.436846
          }
        },
        "type": "number",
        "order": "asc"
      }
    },
    {
      "_script": {
        "type": "number",
        "order": "desc",
        "script": {
          "id": "service_region_related",
          "params": {
            "user_city_tag_id": -1,
            "in_whitelist": 0
          }
        }
      }
    },
    {
      "_score": {
        "order": "desc"
      }
    },
    {
      "is_promote": {
        "order": "desc"
      }
    },
    {
      "smart_rank2": {
        "order": "desc"
      }
    },
    {
      "ordering": {
        "order": "asc"
      }
    },
    {
      "start_time": {
        "order": "desc"
      }
    }
  ],
  "highlight": {
    "fields": {
      "short_description_pre": {},
      "doctor.hospital.name": {},
      "items_name": {}
    },
    "pre_tags": [
      "<ems>"
    ],
    "post_tags": [
      "</ems>"
    ],
    "fragment_size": 10000,
    "require_field_match": False
  },"size":10
}

        heasers = {
            "Content-Type": "application/x-www-form-urlencoded"
        }
        response = self.client.post('/gm-dbmw-service-read/_search',json=data, verify=False, auth=tuple(auth.split(':',1)))
        # print(response.text)
        # self.client.get("/hello")
        # self.client.get("/world")

    # @task(3)
    # def view_item(self):
    #     for item_id in range(10):
    #         self.client.get(f"/item?id={item_id}", name="/item")
    #         time.sleep(1)

    # def on_start(self):
    #     self.client.post("/login", json={"username":"foo", "password":"bar"})
