# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum, unique


@unique
class INVITE_TYPE(Enum):
    ALL_PEOPLE = 0, '全民分销商'
    OFFLINE = 1, '线下分销商'
    SECOND = 2, '二级分销商'


@unique
class CHANNEL(Enum):
    BEAUTY = 1, '美容'
    NAIL = 2, '美甲'
    MAKEUP = 3, '化妆品'
    DECORATE = 4, '饰品'
    BUYER = 5, '代购'
    SCHOOL = 6, '校园代理'
    CLUB = 7, '社群主'
    HOSPITAL = 8, '医院'


@unique
class FLOW_ACTION(Enum):
    NEW_ORDER = 'NEW_ORDER', '新订单'
    REFUND = 'REFUND', '订单退款'
    USE_ORDER = 'USE_ORDER', '订单验证'
    ABNORMAL_REFUND = 'ABNORMAL_REFUND', '验证后退款'
    SETTLE = 'SETTLE', '收益结算'
    WITHDRAWAL = 'WITHDRAWAL', '提现'
    OP_SUCCESS = 'OP_SUCCESS', '运营审核通过'
    OP_FAIL = 'OP_FAIL', '运营审核驳回'
    FIN_SUCCESS = 'FIN_SUCCESS', '财务审核通过'
    FIN_FAIL = 'FIN_FAIL', '财务审核驳回'


@unique
class WITHDRAWAL_AUDIT(Enum):
    ING = 'ING', '待审核'
    PASS = 'PASS', '审核通过'
    FAIL = 'FAIL', '审核未通过'


@unique
class SETTLE_STATUS(Enum):
    NOT = 'NOT', '待结算'
    SETTLED = 'SETTLED', '已结算'
    CANNOT = 'CANNOT', '无法结算'
    DEDUCT = 'DEDUCT', '已扣除'


@unique
class IMG_TYPE(Enum):
    POS = 'POS', '正面'
    NEG = 'NEG', '反面'


@unique
class SETTLE_STATUS_FILTER(Enum):
    ALL = 'ALL', '全部'
    NOT = 'NOT', '未结算'
    SETTLED = 'SETTLED', '已结算'
    CANNOT = 'CANNOT', '无法结算'
    DEDUCT = 'DEDUCT', '已扣除'


@unique
class TRADE_TYPE(Enum):
    SYSTEM = 'SYSTEM', '系统授予'
    WITHDRAWAL = 'WITHDRAWAL', '提现结算'


@unique
class FILTER_FLOW_ACTION(Enum):
    ABNORMAL_REFUND = 'ABNORMAL_REFUND', '返现扣减'
    SETTLE = 'SETTLE', '返现收入'
    WITHDRAWAL = 'WITHDRAWAL', '待审核'
    OP_SUCCESS = 'OP_SUCCESS', '待支付'
    OP_FAIL = 'OP_FAIL', '已取消'
    FIN_SUCCESS = 'FIN_SUCCESS', '已支付'
    FIN_FAIL = 'FIN_FAIL', '已驳回'


@unique
class FIN_PAY_RESULT(Enum):
    ING = 'ING', '待支付'
    PASS = 'PASS', '支付成功'
    FAIL = 'FAIL', '支付失败'


@unique
class AUDIT_STATUS(Enum):
    ING = 'ING', '待审核'
    PASS = 'PASS', '已通过'
    FAIL = 'FAIL', '已驳回'
