# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from .utils.enum import Enum

__all__ = ['NOTIFICATION_TYPE', 'DOCTOR_ACTIVITY_STATUS', 'DOCTOR_AREA_TYPE', 'DOCTOR_REGISTER_STATUS',
           'DOCTOR_LICENCE_TYPE', 'DOCTOR_INFO_STATUS', 'DOCTOR_ACCOUNT_TYPE', 'COUPON_FILTER_STATUS',
           'DOCTOR_ACCOUNT_STATUS',
           ]


class NOTIFICATION_TYPE(Enum):
    RESERVATION = ('1', '预约消息')
    TRADE = ('2', '购买验证')
    REFUND = ('3', '退款消息')
    USERCASE = ('4', '案例消息')


class DOCTOR_ACTIVITY_STATUS(Enum):
    DEFAULT = (0, '下线')
    WILL_START = (1, '即将开始')  # 上线且位于开始时间之前
    PROCESSING = (2, '进行中')  # 进行中，上线且位于开始时间结束时间之间, 可以报名
    OVER = (3, '已结束')  # 上线且位于结束时间之后
    HAVE_APPLIED = (4, '已经报名')  # 进行中，上线且位于开始时间结束时间之间, 已经报名过了


class DOCTOR_AREA_TYPE(Enum):
    CISBORDER = (1, u'境内')
    ABROAD = (2, u'境外')


class DOCTOR_REGISTER_STATUS(Enum):
    DATA_INIT = (0, '初始状态')  # 闲置状态
    DATA_SUBMITTED = (1, u'已提交注册资料')
    DATA_CHECKED = (2, u'资料已审核')
    AGREEMENT_CHECKED = (3, u'合同已审核')  # 此转态废弃，合同审核通过直接状态FINISHED
    FINISHED = (4, u'注册通过了')
    DATA_REJECT = (5, u'资料被驳回')
    OLD_DATA = (6, u'未生成医生的老注册申请')
    CHECK_PENDING = (7, u'已注册合同待审状态')


class DOCTOR_LICENCE_TYPE(Enum):
    BUSINESS = (1, u'资格证')
    PRACTICE = (2, u'执业许可证')
    TITLE = (3, u'职称证书')
    HOSPITAL_LEVEL = (4, u'医院等级图片')
    RETAIL_LEASE_CONTRACT = (5, u'商铺租赁合同')
    SAME_PROVINCE_CHAIN_HOSPITAL = (6, u'同省份机构的营业执照')
    INTER_PROVINCE_CHAIN_HOSPITAL = (7, u'跨省份机构的营业执照')
    DOCTOR_PERSONALIZED_PHOTO_ALBUM = (8, u'医生个性化照片')
    HOSPITAL_HONOR_PICTURE = (9, u'医院荣誉图片')
    PERSONAL_PICTURE = (10, u'个人形象照')


class DOCTOR_INFO_STATUS(Enum):
    CHECKED = (0, u'审核通过')
    APPLY_EDIT = (1, u'申请修改')
    REJECT = (2, u'已驳回')
    GIVE_UP = (3, u'放弃修改')
    CHECK_PENDING = (7, u'已注册合同待审状态')


class DOCTOR_ACCOUNT_TYPE(Enum):
    BANK = (0, u'银行')
    ALIPAY = (1, u'支付宝')


class DOCTOR_ACCOUNT_STATUS(Enum):
    """
        医生账号信息 审核状态
    """
    CHECKED = (0, u'审核通过')
    SUBMITED = (1, u'提交申请')
    REJECT = (2, u'已驳回')
    GIVE_UP = (3, u'放弃修改')


class COUPON_FILTER_STATUS(Enum):
    """ 用于医生后台刷选 条件"""
    ALL = (0, u'全部')
    DRAFT = (1, u'未生效')
    OPEN = (2, u'领取中')
    CLOSED = (3, u'已下线')
    ACTIVATED = (4, u'未领取')
    EXPIRED = (5, u'已过期')


class DOCTOR_TITLE_TYPE(Enum):
    EMPTY = ('0', u'无职称')
    RESIDENT = ('1', u'住院医师')
    MAIN = ('2', u'主治医师')
    VICE = ('3', u'副主任医师')
    CHIEF = ('4', u'主任医师')


class DOCTOR_BILL_TYPE(Enum):
    GENERAL = (0, u'纸质普通')
    SPECIAL = (1, u'纸质专用')
    ELECTRONIC = (2, u'电子普通')


class DOCTOR_BILL_CLASS(Enum):
    COMMISSION = (0, u'佣金发票')
    RECHANGE = (1, u'商桥充值发票')
    BUDAN = (2, u'转诊补单发票')


class DOCTOR_BILLAPPLY_STATUS(Enum):
    SUCCESS = (0, u'申请成功')
    REJECT = (1, u'已驳回')
    PENDING = (2, u'待审核')


class DOCTOR_EXPRESS_COMPANY(Enum):
    ZHONGTONG = (0, u'中通')
    SHENTONG = (1, u'申通')
    YUANTONG = (2, u'圆通')
    HUITONG = (3, u'百世汇通')
    YOUZHENG = (4, u'邮政')
    SHUNFENG = (5, u'顺丰')
    YUNDA = (6, u'韵达')
    DEFAULT = (20, u'')


class BILL_REFUSE_REASON(Enum):
    TAX_ID_ERROR = (0, u'税务登记号错误')
    BILL_NONE = (1, u'发票已用完，建议合并开发票')
    TAX_NAME_ERROR = (2, u'发票抬头错误')
    NOT_ONLINE = (3, u'不支持线上开票，请联系商务线下开')
    OTHERS = (4, u'其它原因')


class BILL_INFO_TYPE(Enum):
    NORMAL = (0, u'商户合同资料中的甲方公司信息')
    HANDLER = (1, u'商户合同资料中的甲方代运营公司信息')


class PV_TYPE(Enum):
    SERVICE = (1, u'商品详情页')
    HOSPITAL = (2, u'机构主页')
    DOCTOR = (3, u'医生主页')


class DOCTOR_MESSAGE_TYPE(Enum):
    BUDAN = (0, u'补单提醒')
    STATEMENT_CONFIRM = (1, u'对账单确认提醒')
    STATEMENT_SETTLE = (2, u'对账单结算提醒')
    STATEMENT_FAIL = (3, u'对账单打款失败提醒')
    SERVICE_ONLINE = (4, u'美购审核上线提醒')
    SERVICE_REFUSE = (5, u'美购审核驳回提醒')
    SERVICE_OFFLINE = (6, u'美购审核下线提醒')
    SERVICE_OFFLINE_REFUSE = (7, u'美购审核下线驳回提醒')
    SERVICE_EXPIRE = (8, u'美购到期提醒')
    ACTIVITY_SUCCESS = (9, u'活动报名成功提醒')
    ACTIVITY_FAIL = (10, u'活动报名失败提醒')
    DOCTOR_SUCCESS = (11, u'医生资料审核成功提醒')
    DOCTOR_REFUSE = (12, u'医生资料审核驳回提醒')
    FINANCE_SUCCESS = (13, u'医生结算信息审核通过提醒')
    FINANCE_REFUSE = (14, u'医生结算信息审核驳回提醒')
    AD_ARREARAGE = (15, u'商桥欠费提醒')
    AD_RECHANGE = (16, u'商桥充值成功提醒')
    AD_RECHANGE_FAIL = (17, u'商桥充值驳回提醒')
    DOWNSTREAM_REMINDER = (18, u'降流提醒')
    DOWNSTREAM_REMINDER_CANCEL = (19, u'取消降流提醒')
    DOCTOR_EXAMINE_PASS = (20, u'医生审核通过')
    DOCTOR_EXAMINE_REJECT = (21, u'医生审核驳回')
    DOCTOR_CASHBACK_EXPIRE = (22, u'医生返点到期提醒')
    COUNSELLOR_INFO_AUDIT_PASS = (23, u'面诊师资料审核通过提醒')
    COUNSELLOR_INFO_AUDIT_REJECT = (24, u'面诊师资料审核驳回提醒')
    CPT_THREE_DAY_REMIND = (25, u'CPT上线前三天提醒消息,未弹窗')
    CPT_THREE_DAY_REMIND_POP_UPS = (26, u'CPT上线前三天提醒消息,已弹窗')
    CPT_ONLINE_REMIND = (27, u'CPT上线提醒消息,未弹窗')
    CPT_ONLINE_REMIND_POP_UPS = (28, u'CPT上线提醒消息,已弹窗')

class DOCTOR_ORDER_MESSAGE_TYPE(Enum):
    ORDER = (0, u'订单')
    REFUND = (1, u'退款单')


class HOSPITAL_MEDICAL_TYPE(Enum):
    MEDICAL_BEAUTY_CLINIC = (0, u'医疗美容诊所')
    MEDICAL_BEAUTY_DEPARTMENT = (1, u'医疗美容门诊部')
    MEDICAL_BEAUTY_HOSPITAL = (2, u'医疗美容医院')
    NONE =  (3, u'境外医院无类型')
    BEAUTY_OF_LIVE = (4, u'生活美容')


class HOSPITAL_LEVEL(Enum):
    ONE_BING = (0, u'医院一级丙等')
    ONE_YI = (1, u'医院一级乙等')
    ONE_JIA = (2, u'医院一级甲等')
    TWO_BING = (3, u'医院二级丙等')
    TWO_YI = (4, u'医院二级乙等')
    TWO_JIA = (5, u'医院二级甲等')
    THREE_BING = (6, u'医院三级丙等')
    THREE_YI = (7, u'医院三级乙等')
    THREE_JIA = (8, u'医院三级甲等')
    THREE_SPECIAL = (9, u'医院三级特等')
    NONE = (10, u'无等级')


class HOSPITAL_SCALE(Enum):
    NONE = (0, u'')
    NATIONAL_CHAIN = (1, u'全国连锁')
    REGIONAL_LEADER = (2, u'本地名店')
    GOOD_CLINIC = (3, u'精品诊所')


class BUDAN_LURU_STATUS(Enum):
    ENTERED = (0, u'已录入')
    REVOKED = (1, u'已撤销')

class BUDAN_LURU_TYPE(Enum):
    COMMON = (0, u'常规补单')
    SPECIAL_FLAT_ACCOUNT = (1, u'特殊平账')
    PENALTY = (2, u'罚款')
    TRUMPET_ORDER = (3, u'小号拍单')
    TEST = (4, u'测试')
    KA_FLAT_ACCOUNT = (5, u'KA平账')


class BUDAN_LURU_OPERATE(Enum):
    ENTER = (0, u'录入')
    UNDO = (1, u'撤销')


class USER_BROWSING_TYPE(Enum):
    SERVICE = (1, u'商品详情页')
    HOSPITAL = (2, u'机构主页')
    DOCTOR = (3, u'医生主页')


class DATE_TYPE(Enum):
    THIS_MONTH = (1, u'当月')
    NEARLY_THERE_MONTH = (2, u'近三月')
    NEARLY_SIX_MONTH = (3, u'近三月')


class AGREEMENT_RECORD_STATUS(Enum):
    TODO = (0, u'未审核')
    APPROVE = (1, u'已审核')
    REJECT = (2, u'已驳回')


class HOSTING_TYPE(Enum):
    NONE = (1, u'非代运营')
    COMPANY = (2, u'委托代运营公司')
    PERSON = (3, u'委托代运营个人')


class AGREEMENT_TYPE(Enum):
    PUBLIC = (1, u'公立')
    PRIVATE = (2, u'私营')
    KA = (3, u'KA')


class BUSINESS_TYPE(Enum):
    MEDICAL = (1, u'医疗美容')
    LIVE = (2, u'生活美容')


class AGREEMENT_IMG_TYPE(Enum):
    AGREEMENT = (1, u'合同图片')
    HOSTING = (2, u'代运营图片')


class ID_TYPE(Enum):
    ID = (1, "身份证")
    PASSPORT = (2, "护照")
    OFFICER = (3, "军官证")
    HONGKONG = (4, "香港居民身份证")
    MACAU = (5, "澳门居民身份证")
    BACK = (6, "回乡证")
    TAIWAN_ID = (7, "台湾身份证")
    TAIWAN = (8, "台胞证")
    FOREIGNER = (9, "外国人永久居留证")


class GMEI_NAME(Enum):
    N1 = ("北京完美创意科技有限公司", "北京完美创意科技有限公司")
    N2 = ("北京更美互动信息科技有限公司", "北京更美互动信息科技有限公司")
    N3 = ("上海互美信息科技有限公司", "上海互美信息科技有限公司")
    N4 = ("北京更美分担科技有限公司", "北京更美分担科技有限公司")
    N5 = ("北京完美创意医疗美容诊所有限公司", "北京完美创意医疗美容诊所有限公司")
    N6 = ("苏州更美互动信息科技有限公司", "苏州更美互动信息科技有限公司")
    N7 = ("完美互动香港有限公司", "完美互动香港有限公司")


class BDTRANSFER_APPLY_STATUS(Enum):
    SUCCESS = (0, u'已审核')
    REJECT = (1, u'已驳回')
    PENDING = (2, u'审核中')


class BDTRANSFER_PIC_TYPE(Enum):
    PROOF_OF_PAYMENT = (0, u'支付凭证')
    AUTHORIZATION_VOUCHER = (1, u'代付凭证')
    COLLECTION_OF_PAYMENTS = (2, u'收款凭证')
