# -*- coding: utf-8 -*-
"""
Created on Mon Jan  8 17:05:21 2018

@author: hanye
"""
import logging
from func_build_maintainance_index import build_maintainance_index
import datetime


today=datetime.datetime.now()
previous_day=today-datetime.timedelta(days=1)
fetch_year=previous_day.year
fetch_month=previous_day.month
fetch_day=previous_day.day

# define logger
logger=logging.getLogger('maintainance_build_manual')
logger.setLevel(logging.DEBUG)
# create handler
path='/home/hanye/project_data/Python/Projects/proj-short-videos/write-data-into-es/log/'
log_fn='build_maintainance_for_%s_on_%s_log' % (previous_day.isoformat()[:10], datetime.datetime.now().isoformat().replace(':','-'))
fh=logging.FileHandler(path+log_fn)
fh.setLevel(logging.INFO)
# create formatter and add it to the handler
formatter=logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
fh.setFormatter(formatter)
# add handler to logger
logger.addHandler(fh)

logger.info('log starts at %s', datetime.datetime.now())

for cal_day in range(1, fetch_day+1):
    build_maintainance_index(fetch_year, fetch_month, cal_day)

