#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/08/09 12:05:29
#   Desc    :   医生后台类型
#
from __future__ import unicode_literals

from ..utils.enum import Enum, unique


# !!! 字符前面一定要记得加 u  !!!!!

@unique
class ASCLE_ENV(Enum):
    DEV = (0, u'开发环境')
    TEST = (1, u'测试环境')
    PROD = (2, u'线上环境')


@unique
class LOGIN_METHOD(Enum):
    PASSWORD = ('password', u'密码登录')
    AUTHCODE = ('authcode', u'验证码登录')
    EMAIL = ('email', u'邮箱登录')  # 也是密码登录的一种


@unique
class VERIFY_CODE_TYPE(Enum):
    CREATE = (0, u'创建用户')
    LOGIN = (1, u'登陆')
    BIND = (2, u'手机绑定')
    UPDATE = (3, u"修改属性")
    REGISTER = (4, u"提交注册")


@unique
class ORDER_ORDER_TYPE(Enum):
    CREATE_ASC = (0, u'下单时间正序')
    CREATE_DESC = (1, u'下单时间倒序')
    VALIDATE_ASC = (2, u'验证时间正序')
    VALIDATE_DESC = (3, u"验证时间倒序")
    ID_ASC = (4, u'ID正序')
    ID_DESC = (5, u"ID倒序")
    TOTAL_ASC = (6, u'订单总价正序')
    TOTAL_DESC = (7, u"订单总价倒序")
    PRE_ASC = (8, u'预付款正序')
    PRE_DESC = (9, u"预付款倒序")
    SETTLE_ASC = (10, u'应结付款正序')
    SETTLE_DESC = (11, u"应结付款倒序")
    PAY_ASC = (12, u'支付时间正序')
    PAY_DESC = (13, u'支付时间倒序')


@unique
class REFUND_ORDER_TYPE(Enum):
    CREATE_ASC = (0, u'下单时间正序')
    CREATE_DESC = (1, u'下单时间倒序')
    APPLY_ASC = (2, u'申请退款时间正序')
    APPLY_DESC = (3, u"申请退款时间倒序")


@unique
class STATEMENT_ORDER_TYPE(Enum):
    DATE_ASC = (0, u'结算周期升序')
    DATE_DESC = (1, u'结算周期倒序')
    ORDER_NUM_ASC = (2, u'订单数升序')
    ORDER_NUM_DESC = (3, u"订单数降序")
    TOTAL_NUM_ASC = (4, u'订单总金额升序')
    TOTAL_NUM_DESC = (5, u'订单总金额降序')
    SETTLE_NUM_ASC = (6, u'结算金额升序')
    SETTLE_NUM_DESC = (7, u'结算金额降序')
    STATUS_ASC = (8, u'状态升序')
    STATUS_DESC = (9, u'状态降序')


@unique
class SERVICE_ORDER_TYPE(Enum):
    DEFAULT = (0, u'默认排序')  # order_by('end_time', u'-start_time', u'ordering')
    ONLIENE_TIME_ASC = (1, u'上线时间升序')
    ONLINE_TIME_DESC = (2, u'上线时间降序')
    IS_ONLINE_ASC = (3, u'下线的在前')
    IS_ONLINE_DESC = (4, u'上线的在前')
    ORDER_NUM_ASC = (5, u'成单量升序')
    ORDER_NUM_DESC = (6, u'成单量降序')
    USED_NUM_ASC = (7, u'验证订单量升序')
    USED_NUM_DESC = (8, u'验证订单量降序')
    REFUNDED_NUM_ASC = (9, u'退款订单量升序')
    REFUNDED_NUM_DESC = (10, u'退款订单量降序')


@unique
class RESERVATION_OPERATION(Enum):
    """
        退款操作 描述 see gaia.ORDER_OPERATION_TYPE
    """
    DOCTOR_APPROVE = (9, u'您同意了该用户的退款')
    DOCTOR_REJECT = (8, u'您拒绝了该用户的退款')
    CANCEL_REFUND = (7, u'该用户取消了您的退款')
    REFUNDED = (6, u'该用户完成了您的退款')
    APPLY_REFUND = (16, u'该用户申请了您的退款')
    REFUND_TIMEOUT = (19, u'您未处理该用户的退款')

@unique
class SERVICE_REGISTER_REVIEW_STATUS(Enum):
    UNDER_REVIEW = (0, u'审核中')
    PASS_REVIEW = (10, u'已通过审核')

@unique
class UNDER_REVIEW_LIST_TYPES(Enum):
    """
    待审核列表的bar类型
    """
    NEW_PRODUCT = (0, u'新产品审核')
    OLD_PRODUCT = (1, u'产品修改审核')
    SPECIAL_APPROVAL = (2, u'特批审核')

@unique
class PASS_SERVICE_REVIEW_LIST_TYPES(Enum):
    """
    已审核列表的bar类型,这个和上面的UNDER_REVIEW_LIST_TYPES绝对不能重复，
    他们的作用一样，但是需要两个空间
    """
    ALL = (10, u'全部')
    ONLINE = (11, u'在线')
    OFFLINE = (12, u'下线')

@unique
class SERVICE_REVIEW_LIST_TYPES(Enum):
    """
    我的美购bar对应的类型
    """
    ALL = (0, u'全部')
    UNDER_PASS = (1, u'待上线')
    ONLINE = (2, u'在线')
    OFFLINE = (3, u'下线')


@unique
class HOTFIX_STATUS(Enum):
    """
        热修复的状态
    """
    DEFAULT = (0, u'默认')  # 默认不做任何处理
    CLEAR = (1, u'清除')  # 清除之前的hotfix, 相当于关闭hotfix
    HAVE_PATCH = (2, u'有更新')  # 有更新, 需要下载文件
    FIXED = (3, u'已修复过')  # 本地文件和服务器一样，无须重新下载文件

@unique
class TRFFIC_CHART(Enum):
    """
        医生流量分析图标类型
    """
    PV = (0, u'页面浏览')
    CONSULTING = (1, u'咨询量')
    ORDER = (2, u'订单')
    PAY = (3, u'支付')
    VALIDATE = (4, u'验证订单')
    DIARY = (5, u'日记')


@unique
class CHAIN_CHART(Enum):
    """
        连锁结构分析图表类型
    """
    PV = (0, u'页面浏览')
    PHONE = (1, u'咨询量（电话）')
    MESSAGE = (2, u'咨询量（私信）')
    ORDERNUM = (3, u'订单数')
    ORDERAMOUNT = (4, u'订单金额')
    PAYNUM = (5, u'支付订单数')
    PAYAMOUNT = (6, u'支付订单金额')
    VALIDATENUM = (7, u'验证订单数')
    VALIDATEAMOUNT = (8, u'验证订单金额')
    DIARY = (9, u'日记')


@unique
class HOSPITAL_INFO_REVIEW(Enum):
    """
        医院基础信息审核状态
    """
    SUBMIT = (0, u'待审核')
    PASS = (1, u'审核通过')
    REJECT = (2, u'已驳回')


@unique
class HOSPITAL_INFO_IMAGE(Enum):
    """
        医院基础信息图片类型
    """
    LEVEL = (0, u'医院级别图片')
    AREA = (1, u'医院平米数图片')
    CITY = (2, u'开设城市图片')
    CHAIN = (3, u'连锁医院图片')
    OPERATING = (4, u'手术室图片')
    INJECTION = (5, u'注射室图片')
    LASER = (6, u'激光治疗室图片')
    AD_CHECK_IMG = (7, u'医疗广告审查证明')

