# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum, unique


@unique
class MESSAGE_TYPE(Enum):
    TEXT = ('0', '文字')
    AUDIO = ('1', '语音')
    IMAGE = ('2', '图片')
    SERVICE = ('3', '美购详情')
    DOCTOR_TOPIC = ('4', '医生发布帖子')
    TEXT_WITH_URL = ('5', '文字+链接')
    CUSTOMER_SRV_CTRL = ('6', '客服控制消息')
    DIARY = ('8', "日记本")
    GIFT = ('9', "美券礼包")
    CONSULTATION_COUNSEL_REPLAY = ('10', "视频面诊回放")
    CONSULTATION_COUNSEL_REPORT = ('11', "面诊报告")
    APPOINTMENT_CARD = ('12', "预约卡片")


@unique
class CONVERSATION_TYPE(Enum):
    MESSAGE = (1, '普通私信会话')
    CUSTOMER_SRV = (2, '客服私信会话')
    CONSULTANT = (3, '更美咨询师会话')
    TRANSFER_CONSULTANT = (4, '转诊咨询师会话')
    AI_QA_MESSAGE = (5, 'ai问答消息会话')  # add in 7.30.0


@unique
class MESSAGE_RECEIVER_TYPE(Enum):
    ONE_TO_ONE = (1, '1对1单聊')
    GROUP = (2, '群聊')


class MESSAGE_GROUP_TYPE(Enum):
    NORMAL_GROUP = (1, '普通群')
    CUSTOMER_SERVICE_GROUP = (2, '转诊咨询群')


class MESSAGE_GROUP_USER_ROLE(Enum):
    NORMAL = (1, '普通用户')
    CUSTOMER_SERVICE = (2, '转诊咨询用户')


class TRANSFER_CONSULTANT_SWITCH_TYPE(Enum):
    BE_ACTIVATE = (1, '被激活与用户的会话')
    BE_REMOVED = (2, '被剔除与用户的会话')


class TRANSFER_CONSULTANT_LEVEL(Enum):
    ONE = (1, '一级转诊咨询师')
    TWO = (2, '二级转诊咨询师')


@unique
class CONVERSATION_ORDER(Enum):
    LAST_REPLY_TIME = (1, '最后对话时间')
    UNREAD = (2, '未读+最后对话时间')


@unique
class MessageTraceEventType(Enum):
    """ 私信链路事件追踪 """

    TRACE_BACKEND_PRIVATE_SEND = "GM.Message.TRACE_BACKEND_PRIVATE_SEND"
    TRACE_BACKEND_PRIVATE_SEND_SUCCESS = "GM.Message.TRACE_BACKEND_PRIVATE_SEND_SUCCESS"
    TRACE_BACKEND_PRIVATE_SEND_FAILED = "GM.Message.TRACE_BACKEND_PRIVATE_SEND_FAILED"

    TRACE_GAIA_RPC_CALLED = "GM.Message.TRACE_GAIA_RPC_CALLED"
    TRACE_GAIA_RPC_SUCCESSED = "GM.Message.TRACE_GAIA_RPC_SUCCESSED"
    TRACE_GAIA_RPC_FAILED = "GM.Message.TRACE_GAIA_RPC_FAILED"
    TRACE_GAIA_RPC_ERROR = "GM.Message.TRACE_GAIA_RPC_ERROR"

    TRACE_GAIA_WRITE_TO_MYSQL = "GM.Message.TRACE_GAIA_WRITE_TO_MYSQL"
    TRACE_GAIA_WRITE_TO_ES = "GM.Message.TRACE_GAIA_WRITE_TO_ES"

    TRACE_GAIA_MESSAGE_JPUSH_TASK_SENDED = "GM.Message.TRACE_GAIA_MESSAGE_JPUSH_TASK_SENDED"
    TRACE_GAIA_MESSAGE_JPUSH_TASK_RECIVED = "GM.Message.TRACE_GAIA_MESSAGE_JPUSH_TASK_RECIVED"
    TRACE_GAIA_MESSAGE_JPUSH_TO_USER = "GM.Message.TRACE_GAIA_MESSAGE_JPUSH_TO_USER"
    TRACE_GAIA_MESSAGE_JPUSH_TO_DOCTOR = "GM.Message.TRACE_GAIA_MESSAGE_JPUSH_TO_DOCTOR"

    TRACE_GAIA_MESSAGE_JIM_TASK_SENDED = "GM.Message.TRACE_GAIA_MESSAGE_JIM_TASK_SENDED"
    TRACE_GAIA_MESSAGE_JIM_TASK_RECIVED = "GM.Message.TRACE_GAIA_MESSAGE_JIM_TASK_RECIVED"
    TRACE_GAIA_MESSAGE_JIM_TO_USER = "GM.Message.TRACE_GAIA_MESSAGE_JIM_TO_USER"

    TRACE_GAIA_NOTI_POLL = "GM.Message.TRACE_GAIA_NOTI_POLL"

    TRACE_POLL_PUB_EMPTY_ADDR = "GM.Message.TRACE_POLL_PUBLISH_EMPTY_ADDR"
    TRACE_POLL_PUB_TO_ADDR = "GM.Message.TRACE_POLL_PUBLISH_TO_ADDR"
    TRACE_POLL_SUB_FROM_ADDR = "GM.Message.TRACE_POLL_SUB_FROM_ADDR"