# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


@unique
class BJD_MARRIAGE(Enum):
    MARRIED = 1, '已婚'
    UNMARRIED = 2, '未婚'
    DIVORCED = 3, '离异'
    WIDOWED = 4, '丧偶'


@unique
class BJD_EDUCATION(Enum):
    UNDER_SENIOR = 1, '高中以下'
    SENIOR = 2, '高中/中专'
    SPECIALTY = 3, '大专'
    BECHELOR = 4, '本科'
    MASTER = 5, '硕士研究生'
    DOCTOR = 6, '博士研究生'
    POST_DOCTOR = 7, '博士后'


@unique
class BJD_RELATION(Enum):
    SPOUSE = 1, '配偶'
    PARENTS = 2, '父母'
    CHILD = 3, '子女'
    OTHER_FAMLIY = 4, '其它亲属'
    CLASSMATE = 5, '同学'
    COLLEAGUE = 6, '同事'
    FRIEND = 7, '朋友'


@unique
class BJD_IDENTITY(Enum):
    STUDENT = 1, '学生'
    WORKER = 2, '职工'
    ENTREPRENEUR = 3, '企业主'


@unique
class BJD_BANK(Enum):
    ICBC = 'ICBC', '工商银行'
    BOC = 'BOC', '中国银行'
    CCB = 'CCB', '建设银行'
    PSBC = 'PSBC', '邮政储蓄'
    ECITIC = 'ECITIC', '中信银行'
    CEB = 'CEB', '光大银行'
    CIB = 'CIB', '兴业银行'
    HX = 'HX', '华夏银行'
    SPDB = 'SPDB', '浦发银行'
    SZPA = 'SZPA', '平安银行'
    CMBC = 'CMBC', '民生银行'
    GDB = 'GDB', '广发银行'
    BCCB = 'BCCB', '北京银行'
    ABC = 'ABC', '农业银行'
    SHB = 'SHB', '上海银行'
    CMBCHINA = 'CMBCHINA', '招商银行'
    BOCO = 'BOCO', '交通银行'


@unique
class BJD_REPAY_STATUS(Enum):
    UNPAY = '1', '待还款'
    PAYED = '2', '已还款'
    OVERDUE = '3', '已逾期'


@unique
class BJD_AUT_TYPE(Enum):
    ZHIMA = '1001', '芝麻信用'
    YUNYING = '1002', '运营商'
    JD = '1004', '京东'
    CARD = '1005', '信用卡'


@unique
class BJD_AUT_RESULT(Enum):
    UNAUT = '0', '未认证'
    AUT = '1', '已认证'
    FAIL = '5', '认证失败'
    AUTING = '3', '认证中'


@unique
class BJD_PAYRESOULT_CODE(Enum):
    PASS = '0000', '审核通过'
    REJECT = '4444', '审批拒绝'
    SUPPLY = '7777', '打回补充'
    AUDIT = '1111', '审批中'
    CONFIRM = '2222', '已审批，待用户确认'


@unique
class BJD_BACKCODE(Enum):
    BANK = '0001', '银行卡认证不成功'
    ZHIMA = '1001', '芝麻信用授信'
    YUNYING = '1002', '运营商'
    JD = '1004', '京东'
    CARD = '1005', '信用卡邮箱'
