# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


@unique
class INSTALLMENT_SERVICE(Enum):
    RENMAI = (2, u'任买')
    YIRENDAI = (3, u'宜人贷')
    RENMAI_CREDIT = (4, u'任买白条')


@unique
class MARRAGE_STATUS(Enum):
    UNMARRIED = ('10', '未婚')
    MARRIED = ('20', '已婚')
    OTHER = ('90', '其他')


class SOCIAL_STATUS(Enum):
    STUDENT = ('SI01', '学生')
    OFFICERS = ('SI02', '在职人员')
    FREE = ('SI03', '自由职业')

    # 产品文档里面没有
    # SUPERINTENDENT = ('SI04', '企业负责人')
    # UNEMPLOYED = ('SI05', '无业')
    # RETIREMENT = ('SI06', '退休')


class LIVING_STATUS(Enum):
    MORTGAGE = ('1', '自置无按揭')
    NOMORTGAGE = ('2', '自置有按揭')
    RELATIVES = ('3', '亲属楼宇')
    DORMITORY = ('4', '集体宿舍')
    RENT = ('5', '租房')
    OTHER = ('7', '其他')


class IMAGE_TYPE(Enum):
    APPLICANT = ('P', '身份证手持照')
    POSITIVEIDCARD = ('F', '身份证正面')
    OPPOSITEIDCARD = ('R', '身份证背面')
    BANKCARD = ('W', '代扣银行卡')
    PROVE = ('A', '工作证明或学生证明')
    SOCIALSECURITY = ('S', '社保卡')
    TRANSACTIONRECORD = ('C', '工资卡及流水')
    PROOFOFRESIDENCE = ('L', '居住证明')
    ACCOUNTBOOK = ('B', '户口本')
    OWNERSHIPCERTIFICATE = ('H', '房产证')
    POLICEPHOTO = ('N', '公安照片')
    GROUPPHOTO = ('G', '客户与RA合照')
    TICKET = ('T', '购货小票')
    FACE = ('D', '人脸识别照片')
    OTHER = ('Z', '其他')


class EDUCATION_LEVEL(Enum):
    UNDERJUNIOR = ('LE11', '初中以下')
    JUNIOR = ('LE10', '初中')
    SENIOR = ('LE09', '高中\中专\技校')
    SPECIALTY = ('LE05', '大学专科\专科学校')
    UNDERGRADUATE = ('LE06', '大学本科')
    MASTER = ('LE07', '硕士')
    DOCTOR = ('LE08', '博士及以上')


class CONTACT_RELATION(Enum):
    SPOUSE = ('RF01', ' 配偶')
    FATHER = ('RF02', ' 父亲')
    MATHER = ('RF03', ' 母亲')
    BROTHER = ('RF04', ' 兄弟')
    SISTER = ('RF05', ' 姐妹')
    CHILDREN = ('RF06', ' 子女')
    CLASSMATE = ('R002', ' 同学')
    COLLEAGUE = ('R003', ' 同事')
    FRIEND = ('R004', ' 朋友')
    OTHER = ('R005', ' 其他')


class RM_EDUCATION(Enum):
    NONE = (0, '无')
    JUNIOR_OR_UNDER = (3, '初中及以下')
    SENIOR = (4, '高中')
    SECONDARY = (5, '中专')
    SPECIALTY = (6, '大专')
    BECHELOR = (7, '本科')
    MASTER_OR_HIGHER = (8, '研究生及以上')


class RM_MARRIAGE(Enum):
    UNMARRIED = (0, '未婚')
    MARRIED = (1, '已婚')
    DIVORCED = (2, '离异')
    WIDOWED = (3, '丧偶')


class RM_CHILDRED(Enum):
    NONE = (0, '无子女')
    ONE = (1, '一个子女')
    TWO = (2, '2个子女及以上')


class RM_HOUSE(Enum):
    NONE = (0, '无房')
    MORTGAGE = (1, '有房有按揭')
    NO_MORTGAGE = (2, '有房无按揭')


class RM_IDENTITY_TYPE(Enum):
    WORKER = (0, '上班族')
    STUDENT = (1, '学生')


class RM_RELATIONSHIP(Enum):
    COLLEAGUE = (0, '同事')
    FATHER = (1, '父亲')
    MATHER = (2, '母亲')
    CHILDREN = (3, '子女')
    SPOUSE = (4, '配偶')
    SIBLING = (5, '亲兄弟姐妹')


class RM_IMAGE_TYPE(Enum):
    FRONT = (0, '身份证正面照')
    BACK = (1, '身份证背面照')
    HAND = (2, '手持身份证照片')


class RM_STATUS(Enum):
    NONE = (0, '无用，默认')
    AUDITING = (1, '审核中')
    GRANT = (2, '审核通过')
    REJECT = (3, '审核拒绝')
    REPAY = (4, '还款')
    REFUND = (5, '用户放弃')


class MSXF_ORDER_STATUS(Enum):
    AUDITING = (0, "待审批") #
    AUDITED = (1, "审批通过")
    REJECTED = (2, "审批不通过")
    CONFIRMED = (3, "合同已确认") # 合同已确认, 待支付, 等待用户放款确认
    PAID = (4, "已完成")  # 已放款
    CANCELED = (5, "已取消") # 超时取消, 风控拒绝
    RELINK = (8, "资料重传")


class RM_ORDER_STATUS(Enum):
    FORBID = (0, "不能分期")
    SUPPORT = (1, "尾款分期")
    AUDITING = (2, '分期审核中')
    GRANT = (3, '查看详情')
    REJECT = (4, '分期失败')
    REPAY = (5, '还款信息')


@unique
class YRD_CREDIT_STATUS(Enum):
    # 个人额度状态, 包括任买
    DEFAULT = (0, '默认，无用')
    PASS = (1, '通过授信')
    DENY = (2, '审核拒绝')
    NO_APPLY = (3, '未申请')
    OUT = (4, '额度超时')
    AUDIT = (5, '审核中')
    INFO_MISS = (6, '信息不符')
    CANCEL = (7, '信审取消')  # 任买信审取消
    REJECT_OUT = (8, '据贷状态失效')  # 据贷后一段时间又能申请


@unique
class REPAY_STATUS(Enum):
    UNPAIED = (1, '未还款')
    PAIED = (2, '已还款')
    OVERDUE = (3, '逾期')
    PAYING = (4, '还款中')
