# coding: utf-8

from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum as NewEnum


class VisualUnitRelatedServiceTemplate(NewEnum):
    """
    组件关联美购模板类型枚举
    """
    GOODS = (1, '普通商品')
    SECONDS_KILL = (2, "秒杀商品")
    GROUP_BOOKING = (3, "拼团商品")
    COMBO_PACKAGE = (4, "套餐商品")
    OVER_BOUGHT = (5, "多买商品")


class VisualUnitRelatedServiceType(NewEnum):
    """
    组件关联美购方式枚举
    """
    SUBMISSION = (1, "活动id")  # unit_id --- related_id 关联活动id
    APPLICATION = (2, "申请id")  # 例外 unit_id --- commodity_id 关联sku id
    SPU = (3, 'spu id')  # unit_id --- related_id 关联spu id
    SKU = (4, 'sku id')  # unit_id --- related_id 关联sku id
    TAG = (5, '标签 id')  # unit_id --- related_id 关联tag id
    PACKAGE = (6, '套餐id')  # unit_id --- related_id 关联套餐id，sku_id


class UnitType(NewEnum):
    """
    组价类型枚举
    """
    BANNER = (1, '轮播图')
    TOPIC = (2, '帖子')
    PICTURE_HOT_ZONE = (3, '图片热区')
    ANCHOR = (4, '电梯锚点')
    STOREY = (5, '楼层组件')
    SERVICE_LIST = (6, '商品列表')
    BOTTOM_NAVIGATION = (7, '底部导航')
    VIDEO = (8, '视频组件')
    GOOODS_WINDOWS = (9, '商品橱窗')


class RegionType(NewEnum):
    """
    大区枚举
    """
    EAST = (1, '华东')
    SOUTH = (2, '华南')
    WEST = (3, '华西')
    NORTH = (4, '华北')


class RecallType(NewEnum):
    """
    召回类型枚举
    """
    SKU = (1, 'sku')
    SPU = (2, 'spu')
    PACKAGE = (3, 'package')


class SpecialType(NewEnum):
    """
    专题类型枚举
    """
    DEAL = ('0', '交易')
    COMMUNITY = ('1', '社区')
